// $Id: benchmark.c 118 2009-05-20 22:01:32Z rosiere $

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#ifndef MIBENCH_DATA_PATH
# error "MIBENCH_DATA_PATH must be defined"
#endif

  #define MiBench_small
//#define MiBench_large

//-----[ automative ]-----------------------------
int main_basicmath_small    (void);
int main_basicmath_large    (void);
int main_bitcount           (int argc, char *argv[]);
int main_qsort_small        (int argc, char *argv[]);
int main_qsort_large        (int argc, char *argv[]);
int main_susan              (int argc, char *argv[]);
//-----[ office ]---------------------------------
int main_stringsearch_small (void);
int main_stringsearch_large (void);
//-----[ network ]--------------------------------
int main_dijkstra           (int argc, char *argv[]);
//-----[ security ]-------------------------------
int main_sha                (int argc, char *argv[]);

//=======================================================================================
//                                                                      [ run_none ]     
//=======================================================================================
void run_none (void)
{
  printf("***** none *****\n");
  return;
}

//=======================================================================================
//                                                      [ run_automative_basicmath ]
//=======================================================================================
void run_automative_basicmath (void)
{
  printf("***** automative.basicmath - Begin *****\n");

#ifdef MiBench_small
  main_basicmath_small ();
#endif
#ifdef MiBench_large
  main_basicmath_large ();
#endif

  printf("***** automative.basicmath - End   *****\n");
}

//=======================================================================================
//                                                       [ run_automative_bitcount ]
//=======================================================================================
#ifdef MiBench_small
void main_bitcount_small (void)
{
  int     argc = 2;
  char ** argv;

  char  * execname        = "./bitcount";
  char  * iteration       = "75000";

  argv    = (char **)malloc ((argc) * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname ));
  argv[0] = memcpy(argv[0],execname ,strlen(execname ));

  argv[1] = (char *) malloc (strlen(iteration));
  argv[1] = memcpy(argv[1],iteration,strlen(iteration));

  main_bitcount(argc, argv);
    
  for (int i=0; i<argc; ++i)
    free(argv[i]);
  free(argv);
}
#endif

#ifdef MiBench_large
void main_bitcount_large (void)
{
  int     argc = 2;
  char ** argv;

  char  * execname        = "./bitcount";
  char  * iteration       = "1125000";

  argv    = (char **)malloc ((argc) * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname ));
  argv[0] = memcpy(argv[0],execname ,strlen(execname ));

  argv[1] = (char *) malloc (strlen(iteration));
  argv[1] = memcpy(argv[1],iteration,strlen(iteration));

  main_bitcount(argc, argv);
    
  for (int i=0; i<argc; ++i)
    free(argv[i]);
  free(argv);
}
#endif
  
void run_automative_bitcount (void)
{
  printf("***** automative.bitcount - Begin *****\n");
  
#ifdef MiBench_small
  main_bitcount_small ();
#endif
#ifdef MiBench_large
  main_bitcount_large ();
#endif

  printf("***** automative.bitcount - End   *****\n");
}

//=======================================================================================
//                                                       [ run_automative_qsort ]
//=======================================================================================
#ifdef MiBench_small
void _main_qsort_small (void)
{
  int     argc = 2;
  char ** argv;

  char  * execname        = "./qsort";
  char  *_filename        = "/qsort-input_small.dat";
  char  * filename        = (char *) malloc(strlen(MIBENCH_DATA_PATH)+strlen(_filename));
  strcpy(filename,MIBENCH_DATA_PATH); strcat(filename,_filename);

  argv    = (char **)malloc ((argc) * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname ));
  argv[0] = memcpy(argv[0],execname ,strlen(execname));

  argv[1] = (char *) malloc (strlen(filename ));
  argv[1] = memcpy(argv[1],filename ,strlen(filename));

  main_qsort_small(argc, argv);
    
  for (int i=0; i<argc; ++i)
    free(argv[i]);
  free(argv);
}
#endif

#ifdef MiBench_large
void _main_qsort_large (void)
{
  int     argc = 2;
  char ** argv;

  char  * execname        = "./qsort";
  char  *_filename        = "/qsort-input_large.dat";
  char  * filename        = (char *) malloc(strlen(MIBENCH_DATA_PATH)+strlen(_filename));
  strcpy(filename,MIBENCH_DATA_PATH); strcat(filename,_filename);

  argv    = (char **)malloc ((argc) * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname ));
  argv[0] = memcpy(argv[0],execname ,strlen(execname));

  argv[1] = (char *) malloc (strlen(filename ));
  argv[1] = memcpy(argv[1],filename ,strlen(filename));

  main_qsort_large(argc, argv);
    
  for (int i=0; i<argc; ++i)
    free(argv[i]);
  free(argv);
}
#endif

void run_automative_qsort (void)
{
  printf("***** automative.qsort - Begin *****\n");
  
#ifdef MiBench_small
  _main_qsort_small ();
#endif
#ifdef MiBench_large
  _main_qsort_large ();
#endif

  printf("***** automative.qsort - End   *****\n");
}

//=======================================================================================
//                                                       [ run_automative_susan ]
//=======================================================================================
#ifdef MiBench_small
void main_susan_small (void)
{
  int     argc = 4;
  char ** argv;

  char  * execname        = "./susan";
  char  *_filename_input  = "/susan-input_small.pgm";
  char  * filename_input  = (char *) malloc(strlen(MIBENCH_DATA_PATH)+strlen(_filename_input));
  strcpy(filename_input,MIBENCH_DATA_PATH); strcat(filename_input,_filename_input);
  
  argv    = (char **)malloc ((argc) * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname       ));
  argv[0] = memcpy(argv[0],execname       ,strlen(execname       ));

  argv[1] = (char *) malloc (strlen(filename_input ));
  argv[1] = memcpy(argv[1],filename_input ,strlen(filename_input ));

  char  * filename_output = "output_small.smoothing.pgm";
  char  * option          = "-s";

  argv[2] = (char *) malloc (strlen(filename_output));
  argv[2] = memcpy(argv[2],filename_output,strlen(filename_output));

  argv[3] = (char *) malloc (strlen(option         ));
  argv[3] = memcpy(argv[3],option         ,strlen(option         ));

  main_susan(argc, argv);

  for (int i=2; i<argc; ++i)
    free(argv[i]);

  filename_output = "output_small.edges.pgm";
  option          = "-e";

  argv[2] = (char *) malloc (strlen(filename_output));
  argv[2] = memcpy(argv[2],filename_output,strlen(filename_output));

  argv[3] = (char *) malloc (strlen(option         ));
  argv[3] = memcpy(argv[3],option         ,strlen(option         ));

  main_susan(argc, argv);

  for (int i=2; i<argc; ++i)
    free(argv[i]);

  for (int i=2; i<argc; ++i)
    free(argv[i]);

  filename_output = "output_small.cornes.pgm";
  option          = "-c";

  argv[2] = (char *) malloc (strlen(filename_output));
  argv[2] = memcpy(argv[2],filename_output,strlen(filename_output));

  argv[3] = (char *) malloc (strlen(option         ));
  argv[3] = memcpy(argv[3],option         ,strlen(option         ));

  main_susan(argc, argv);
    
  for (int i=0; i<argc; ++i)
    free(argv[i]);
  free(argv);
}
#endif

#ifdef MiBench_large
void main_susan_large (void)
{
  int     argc = 4;
  char ** argv;

  char  * execname        = "./susan";
  char  *_filename_input  = "/susan-input_large.pgm";
  char  * filename_input  = (char *) malloc(strlen(MIBENCH_DATA_PATH)+strlen(_filename_input));
  strcpy(filename_input,MIBENCH_DATA_PATH); strcat(filename_input,_filename_input);
  
  argv    = (char **)malloc ((argc) * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname       ));
  argv[0] = memcpy(argv[0],execname       ,strlen(execname       ));

  argv[1] = (char *) malloc (strlen(filename_input ));
  argv[1] = memcpy(argv[1],filename_input ,strlen(filename_input ));

  char  * filename_output = "output_large.smoothing.pgm";
  char  * option          = "-s";

  argv[2] = (char *) malloc (strlen(filename_output));
  argv[2] = memcpy(argv[2],filename_output,strlen(filename_output));

  argv[3] = (char *) malloc (strlen(option         ));
  argv[3] = memcpy(argv[3],option         ,strlen(option         ));

  main_susan(argc, argv);

  for (int i=2; i<argc; ++i)
    free(argv[i]);

  filename_output = "output_large.edges.pgm";
  option          = "-e";

  argv[2] = (char *) malloc (strlen(filename_output));
  argv[2] = memcpy(argv[2],filename_output,strlen(filename_output));

  argv[3] = (char *) malloc (strlen(option         ));
  argv[3] = memcpy(argv[3],option         ,strlen(option         ));

  main_susan(argc, argv);

  for (int i=2; i<argc; ++i)
    free(argv[i]);

  for (int i=2; i<argc; ++i)
    free(argv[i]);

  filename_output = "output_large.cornes.pgm";
  option          = "-c";

  argv[2] = (char *) malloc (strlen(filename_output));
  argv[2] = memcpy(argv[2],filename_output,strlen(filename_output));

  argv[3] = (char *) malloc (strlen(option         ));
  argv[3] = memcpy(argv[3],option         ,strlen(option         ));

  main_susan(argc, argv);
    
  for (int i=0; i<argc; ++i)
    free(argv[i]);
  free(argv);
}
#endif

void run_automative_susan (void)
{
  printf("***** automative.susan - Begin *****\n");
  
#ifdef MiBench_small
  main_susan_small ();
#endif
#ifdef MiBench_large
  main_susan_large ();
#endif

  printf("***** automative.susan - End   *****\n");
}

//=======================================================================================
//                                                       [ run_network_dijkstra ]
//=======================================================================================

#ifdef MiBench_small
void main_dijkstra_small (void)
{
  int     argc = 3;
  
  char ** argv;

  char  * execname        = "./dijkstra";
  char  *_filename        = "/dijkstra-input.dat";
  char  * filename        = (char *) malloc(strlen(MIBENCH_DATA_PATH)+strlen(_filename));
  strcpy(filename,MIBENCH_DATA_PATH); strcat(filename,_filename);
  char  * nb_path         = "20";
  
  argv    = (char **)malloc ((argc) * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname       ));
  argv[0] = memcpy(argv[0],execname       ,strlen(execname       ));

  argv[1] = (char *) malloc (strlen(filename       ));
  argv[1] = memcpy(argv[1],filename       ,strlen(filename       ));

  argv[2] = (char *) malloc (strlen(nb_path        ));
  argv[2] = memcpy(argv[2],nb_path        ,strlen(nb_path        ));

  main_dijkstra(argc, argv);
    
  for (int i=0; i<argc; ++i)
    free(argv[i]);
  free(argv);
}
#endif


#ifdef MiBench_large
void main_dijkstra_large (void)
{
  int     argc = 3;
  
  char ** argv;

  char  * execname        = "./dijkstra";
  char  *_filename        = "/dijkstra-input.dat";
  char  * filename        = (char *) malloc(strlen(MIBENCH_DATA_PATH)+strlen(_filename));
  strcpy(filename,MIBENCH_DATA_PATH); strcat(filename,_filename);
  char  * nb_path         = "100";
  
  argv    = (char **)malloc ((argc) * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname       ));
  argv[0] = memcpy(argv[0],execname       ,strlen(execname       ));

  argv[1] = (char *) malloc (strlen(filename       ));
  argv[1] = memcpy(argv[1],filename       ,strlen(filename       ));

  argv[2] = (char *) malloc (strlen(nb_path        ));
  argv[2] = memcpy(argv[2],nb_path        ,strlen(nb_path        ));

  main_dijkstra(argc, argv);
    
  for (int i=0; i<argc; ++i)
    free(argv[i]);
  free(argv);
}
#endif

void run_network_dijkstra (void)
{
  printf("***** network.dijkstra - Begin *****\n");
  
#ifdef MiBench_small
  main_dijkstra_small ();
#endif
#ifdef MiBench_large
  main_dijkstra_large ();
#endif

  printf("***** network.dijkstra - End   *****\n");
}

//=======================================================================================
//                                                      [ run_office_stringsearch ]
//=======================================================================================
void run_office_stringsearch (void)
{
  printf("***** office.stringsearch - Begin *****\n");

#ifdef MiBench_small
  main_stringsearch_small ();
#endif
#ifdef MiBench_large
  main_stringsearch_large ();
#endif

  printf("***** office.stringsearch - End   *****\n");
}

//=======================================================================================
//                                                       [ run_security_sha ]
//=======================================================================================
#ifdef MiBench_small
void main_sha_small (void)
{
  int     argc = 2;
  char ** argv;

  char  * execname        = "./sha";
  char  *_filename        = "/sha-input_small.asc";
  char  * filename        = (char *) malloc(strlen(MIBENCH_DATA_PATH)+strlen(_filename));
  strcpy(filename,MIBENCH_DATA_PATH); strcat(filename,_filename);

  argv    = (char **)malloc ((argc) * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname ));
  argv[0] = memcpy(argv[0],execname ,strlen(execname));

  argv[1] = (char *) malloc (strlen(filename ));
  argv[1] = memcpy(argv[1],filename ,strlen(filename));

  main_sha(argc, argv);
    
  for (int i=0; i<argc; ++i)
    free(argv[i]);
  free(argv);
}
#endif

#ifdef MiBench_large
void main_sha_large (void)
{
  int     argc = 2;
  char ** argv;

  char  * execname        = "./sha";
  char  *_filename        = "/sha-input_large.asc";
  char  * filename        = (char *) malloc(strlen(MIBENCH_DATA_PATH)+strlen(_filename));
  strcpy(filename,MIBENCH_DATA_PATH); strcat(filename,_filename);

  argv    = (char **)malloc ((argc) * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname ));
  argv[0] = memcpy(argv[0],execname ,strlen(execname));

  argv[1] = (char *) malloc (strlen(filename ));
  argv[1] = memcpy(argv[1],filename ,strlen(filename));

  main_sha(argc, argv);
    
  for (int i=0; i<argc; ++i)
    free(argv[i]);
  free(argv);
}
#endif

void run_security_sha (void)
{
  printf("***** security.sha - Begin *****\n");
  
#ifdef MiBench_small
  main_sha_small ();
#endif
#ifdef MiBench_large
  main_sha_large ();
#endif

  printf("***** security.sha - End   *****\n");
}
