/*
 * $Id: Parameters.cpp 120 2009-05-26 19:01:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Read_unit_to_Execution_unit/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace read_unit_to_execution_unit {


#undef  FUNCTION
#define FUNCTION "Read_unit_to_Execution_unit::Parameters"
  Parameters::Parameters (uint32_t    nb_read_unit           ,
			  uint32_t  * nb_read_unit_port      ,
			  uint32_t    nb_execute_unit        ,
			  uint32_t  * nb_execute_unit_port   ,
			  uint32_t    nb_context             ,
			  uint32_t    nb_front_end           ,
			  uint32_t    nb_ooo_engine          ,
			  uint32_t    nb_packet              ,
			  uint32_t    size_general_data      ,
			  uint32_t    size_special_data      ,
			  uint32_t    nb_general_register    ,
			  uint32_t    nb_special_register    ,
			  uint32_t    size_store_queue       ,
			  uint32_t    size_load_queue        ,
			  Tpriority_t priority               ,
			  bool    *** table_routing          ,
			  bool     ** table_execute_type     ,
			  bool     ** table_execute_thread   ,
                          bool      * num_thread_valid       ,
                          bool        is_toplevel            )
  {
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"Begin");

    _nb_read_unit            = nb_read_unit        ;
    _nb_read_unit_port       = nb_read_unit_port   ;    
    _nb_execute_unit         = nb_execute_unit     ;
    _nb_execute_unit_port    = nb_execute_unit_port;
    _nb_context              = nb_context          ;
    _nb_front_end            = nb_front_end        ;
    _nb_ooo_engine           = nb_ooo_engine       ;
    _nb_packet               = nb_packet           ;
    _nb_general_register     = nb_general_register ;
    _nb_special_register     = nb_special_register ;
    _priority                = priority            ;
    _table_routing           = table_routing       ;
    _table_execute_type      = table_execute_type  ;
    _table_execute_thread    = table_execute_thread;
    _num_thread_valid        = num_thread_valid    ;

    log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"  * table_routing [nb_read_unit][nb_execute_unit][nb_execute_unit_port]");
    for (uint32_t i=0; i<_nb_read_unit; ++i)
      for (uint32_t j=0; j<_nb_execute_unit; ++j)
        for (uint32_t k=0; k<_nb_execute_unit_port[j]; ++k)
          if (_table_routing [i][j][k])
            log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"    [%d][%d][%d] -> true",i,j,k);

    log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"  * table_execute_type [nb_execute_unit][nb_type]");
    for (uint32_t i=0; i<_nb_execute_unit; ++i)
      for (uint32_t j=0; j<_nb_type; ++j)
        if (_table_execute_type [i][j])
          log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"    [%d][%d] -> true",i,j);

    log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"  * table_execute_thread [nb_execute_unit][nb_thread]");
    for (uint32_t i=0; i<_nb_execute_unit; ++i)
      for (uint32_t j=0; j<_nb_thread; ++j)
        if (_table_execute_thread [i][j])
          log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"    [%d][%d] -> true",i,j);

    _max_nb_read_unit_port   = max<uint32_t>(_nb_read_unit_port, _nb_read_unit);
    _max_nb_execute_unit_port= max<uint32_t>(_nb_execute_unit_port, _nb_execute_unit);

    _nb_thread               = get_nb_thread (nb_context, nb_front_end, nb_ooo_engine);
    _nb_load_store_unit      = 0;

    for (uint32_t i=0; i<nb_execute_unit; i++)
      {
	if (table_execute_type[i][TYPE_MEMORY] == true)
	  _nb_load_store_unit ++;
      }
    // a execution_unit can't be a load_store unit and a functionnal unit
    _nb_functionnal_unit = nb_execute_unit-_nb_load_store_unit;

    test();

    if (is_toplevel)
      {
        _size_context_id         = log2(nb_context         );
        _size_front_end_id       = log2(nb_front_end       );
        _size_ooo_engine_id      = log2(nb_ooo_engine      );
        _size_rob_ptr            = log2(nb_packet          );
        _size_general_register   = log2(nb_general_register);
        _size_special_register   = log2(nb_special_register);
        _size_general_data       = size_general_data   ;
        _size_special_data       = size_special_data   ;
        _size_store_queue_ptr    = log2(size_store_queue   );
        _size_load_queue_ptr     = log2(size_load_queue    );
        
        _have_port_context_id    = _size_context_id    > 0;
        _have_port_front_end_id  = _size_front_end_id  > 0;
        _have_port_ooo_engine_id = _size_ooo_engine_id > 0;
        _have_port_rob_ptr       = _size_rob_ptr       > 0;
        _have_port_load_queue_ptr= _size_load_queue_ptr> 0;
        
        copy();
      }

    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Read_unit_to_Execution_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"Begin");

//     test();
//     log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Read_unit_to_Execution_unit::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"Begin");
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Read_unit_to_Execution_unit::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"Begin");
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"End");
  };

}; // end namespace read_unit_to_execution_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
