#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_update_prediction_table_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_update_prediction_table_Parameters_h

/*
 * $Id: Parameters.h 120 2009-05-26 19:01:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t   _nb_context                ;
  public : uint32_t * _size_upt_queue            ; // [nb_context]
  public : uint32_t * _size_ufpt_queue           ; // [nb_context]
//public : uint32_t   _size_address              ;
  public : uint32_t   _nb_inst_predict           ;
  public : uint32_t   _nb_inst_decod             ;
  public : uint32_t   _nb_inst_branch_complete   ;
  public : uint32_t   _nb_inst_update            ;
  public : uint32_t   _size_history              ;
  public : uint32_t * _size_ras_index            ; // [nb_context]
  public : uint32_t   _nb_thread                          ;
  public : uint32_t * _translate_num_context_to_num_thread;//[nb_context]                    
  public : const bool _accurate_block_predict    ;
  public : const bool _accurate_block_decod      ;

//public : uint32_t   _size_context_id           ;
//public : uint32_t * _size_depth                ; // [nb_context]
//public : uint32_t   _max_size_depth            ;
  public : uint32_t   _max_size_ras_index        ;
		                                 
//public : bool       _have_port_context_id      ;
//public : bool     * _have_port_depth           ; // [nb_context]
//public : bool       _have_port_max_depth       ;
  public : bool       _have_port_history         ;
    
  public : bool              * _have_thread             ;//[nb_thread]

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t   nb_context             ,
			uint32_t * size_upt_queue         ,
			uint32_t * size_ufpt_queue        ,
			uint32_t   size_address           ,
			uint32_t   nb_inst_predict        ,
			uint32_t   nb_inst_decod          ,
			uint32_t   nb_inst_branch_complete,
			uint32_t   nb_inst_update         ,
			uint32_t   size_history           ,
			uint32_t * size_ras_index         ,
                        uint32_t   nb_thread                           ,
                        uint32_t * translate_num_context_to_num_thread ,//[nb_context]                    
                        bool       is_toplevel=false);
//public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::Parameters & x);
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
