#ifdef SYSTEMC
/*
 * $Id: Core_Glue_genMealy_issue.cpp 120 2009-05-26 19:01:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {

  /*
      OOO        SLOT     Execute Loop                                  
    ---+                      +-----
       |  +-----+     +-----+ |     
      -+->|     |     |     |-+->   
       |  |     |-()->|     | |     
      -+->| _ _ |     |     |-+->   
       |  | _X_ |-()->|     | |     
      -+->|     |     |     | +-----
       |  |     |-()->|     |       
      -+->|     |     |     | +-----
       |  +-----+     |     | |     
    ---+  crossbar    | _ _ |-+->   
                      | _X_ | |     
    ---+              |     |-+->   
       |  +-----+     |     | |     
      -+->|     |     |     | +-----
       |  |     |-()->|     |       
      -+->| _ _ |     |     | +-----
       |  | _X_ |-()->|     | |     
      -+->|     |     |     |-+->   
       |  |     |-()->|     | |     
      -+->|     |     |     |-+->   
       |  +-----+     +-----+ |     
    ---+  crossbar   dispatch +-----
  */


// class num_read_unit_t
//   {
//   public : const uint32_t num_execute_loop;
//   public : const uint32_t num_read_unit;
    
//   public : num_read_unit_t (uint32_t num_execute_loop,
//                             uint32_t num_read_unit) :
//     this->num_execute_loop (num_execute_loop),
//     this->num_read_unit    (num_read_unit   )
//     {};
//   }

#undef  FUNCTION
#define FUNCTION "Core_Glue::genMealy_issue"
  void Core_Glue::genMealy_issue (void)
  {
    log_begin(Core_Glue,FUNCTION);
    log_function(Core_Glue,FUNCTION,_name.c_str());

    Tcontrol_t ISSUE_OOO_ENGINE_ACK   [_param->_nb_ooo_engine  ][_param->_max_nb_inst_issue_queue];
    Tcontrol_t ISSUE_EXECUTE_LOOP_VAL [_param->_nb_execute_loop][_param->_max_nb_read_unit];
    Tcontrol_t READ_UNIT_ENABLE       [_param->_nb_execute_loop][_param->_max_nb_read_unit];
    Tcontrol_t SLOT_ENABLE            [_param->_nb_ooo_engine  ][_param->_max_nb_inst_issue_slot];
    
    // Init -> all at 0
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      {
        for (uint32_t j=0; j<_param->_nb_inst_issue_queue[i]; ++j)
          ISSUE_OOO_ENGINE_ACK [i][j] = 0;
        for (uint32_t j=0; j<_param->_nb_inst_issue_slot[i]; ++j)
          SLOT_ENABLE [i][j] = 1;         
      }

    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
        {
          ISSUE_EXECUTE_LOOP_VAL [i][j] = 0;

          // Read unit is enable is signal ack is set
          READ_UNIT_ENABLE       [i][j] = (PORT_READ(in_ISSUE_EXECUTE_LOOP_ACK [i][j]) == 1);
	  log_printf(TRACE,Core_Glue,FUNCTION,"  * Read_unit [%d][%d].enable : %d",i,j,READ_UNIT_ENABLE[i][j]);
        }

//     std::list<num_read_unit_t> SLOT_TYPE [_param->_nb_ooo_engine][_param->_max_nb_inst_issue_slot][_param->_nb_type];

//     // for each read_unit
//     for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
//       for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
//         // test if this read_unit can receive an instruction
//         if (PORT_READ(in_ISSUE_EXECUTE_LOOP_ACK [i][j]) == 1)
//           for (uint32_t x=0; x<_nb_ooo_engine; ++x)
//             for (uint32_t y=0; y<_nb_inst_issue_slot[y]; ++y)
//               // test if can dispatch
//               if (_param->_table_dispatch [x][y][i][j])
//                 for (uint32_t k=0;k<_param->_nb_type; ++k)
//                   // Can receive this type
//                   if (_param->_table_dispatch [i][j][k])
//                     SLOT_TYPE[x][y][k].push_back(num_read_unit_t(i,j));

//     // Select an issue_slot of an ooo_engine
//     std::list<generic::priority::select_t> * select_ooo_engine = _priority_ooo_engine->select();
//     for (std::list<generic::priority::select_t>::iterator it_ooo_engine=select_ooo_engine->begin();
//          it_ooo_engine!=select_ooo_engine->end();
//          ++it_ooo_engine)
//       { 
//         // ... get id of the most priotary
//         const uint32_t num_ooo_engine      = it_ooo_engine->grp;
//         const uint32_t num_inst_issue_slot = it_ooo_engine->elt;

//         // Test if this ooo_engine is enable (can be desable if issue in_order)
//         if (OOO_ENGINE_ENABLE[num_ooo_engine])
//           {

//           }
//       }

//     for (uint32_t num_ooo_engine=0; num_ooo_engine<_param->_nb_ooo_engine; ++num_ooo_engine)

    std::list<generic::priority::select_t> * select_ooo_engine = _priority_ooo_engine->select();
    for (std::list<generic::priority::select_t>::iterator it_ooo_engine=select_ooo_engine->begin();
         it_ooo_engine!=select_ooo_engine->end();
         ++it_ooo_engine)
      {
        uint32_t num_ooo_engine      = it_ooo_engine->grp;

        for (uint32_t num_inst_issue_queue=0; num_inst_issue_queue<_param->_nb_inst_issue_queue[num_ooo_engine]; ++num_inst_issue_queue)
          {
            bool find = false;
            
            Tcontrol_t val  = PORT_READ(in_ISSUE_OOO_ENGINE_VAL  [num_ooo_engine][num_inst_issue_queue]);
            Ttype_t    type = PORT_READ(in_ISSUE_OOO_ENGINE_TYPE [num_ooo_engine][num_inst_issue_queue]);
            
            log_printf(TRACE,Core_Glue,FUNCTION,"  * num_ooo_engine                : %d",num_ooo_engine      );
            log_printf(TRACE,Core_Glue,FUNCTION,"  * num_inst_issue_queue          : %d",num_inst_issue_queue);
            log_printf(TRACE,Core_Glue,FUNCTION,"    * val                         : %d",val);
            log_printf(TRACE,Core_Glue,FUNCTION,"    * type                        : %d",type);
            
            if (val)
              for (uint32_t num_inst_issue_slot=0; num_inst_issue_slot<_param->_nb_inst_issue_slot[num_ooo_engine]; ++num_inst_issue_slot)
                {
                  log_printf(TRACE,Core_Glue,FUNCTION,"    * num_inst_issue_slot         : %d",num_inst_issue_slot);
                  
                  // scan all read_unit
                  
                  if (SLOT_ENABLE [num_ooo_engine][num_inst_issue_slot])
                    for (uint32_t num_execute_loop=0; num_execute_loop<_param->_nb_execute_loop; ++num_execute_loop)
                      {
                        std::list<generic::priority::select_t> * select_read_unit = _priority_read_unit[num_execute_loop]->select();
                        for (std::list<generic::priority::select_t>::iterator it_read_unit=select_read_unit->begin();
                             it_read_unit!=select_read_unit->end();
                             ++it_read_unit)
                          {
                            // get the most priotary ...
                            uint32_t num_read_unit = it_read_unit->grp;
                            Tcontrol_t ack = READ_UNIT_ENABLE [num_execute_loop][num_read_unit];
                            
                            log_printf(TRACE,Core_Glue,FUNCTION,"      * num_execute_loop          : %d",num_execute_loop);
                            log_printf(TRACE,Core_Glue,FUNCTION,"      * num_read_unit             : %d",num_read_unit   );
                            log_printf(TRACE,Core_Glue,FUNCTION,"        * read_unit_enable        : %d",ack             );
                            
                            // test if :
                            //  * read_unit can accept an instruction (valid and no previous instruction)
                            //  * slot can issue an instruction at this read_unit
                            //  * read_unit can accept this type
                            if (ack and
                                _param->_table_dispatch [num_ooo_engine][num_inst_issue_slot][num_execute_loop][num_read_unit] and
                                _param->_table_issue_type [num_execute_loop][num_read_unit][type])
                              {
                                log_printf(TRACE,Core_Glue,FUNCTION,"  * find !!!");
                                
                                // find !
                                // Transaction
                                READ_UNIT_ENABLE       [num_execute_loop][num_read_unit] = false; // now, this read_unit is busy
                                ISSUE_EXECUTE_LOOP_VAL [num_execute_loop][num_read_unit] = 1; // = val
                                ISSUE_OOO_ENGINE_ACK   [num_ooo_engine][num_inst_issue_queue] = 1; // = ack
                                SLOT_ENABLE            [num_ooo_engine][num_inst_issue_slot]  = false; // now this slot is used
                                      
                                if (_param->_have_port_context_id)
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_CONTEXT_ID            [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_CONTEXT_ID            [num_ooo_engine][num_inst_issue_queue]));
			        if (_param->_have_port_front_end_id)
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_FRONT_END_ID          [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_FRONT_END_ID          [num_ooo_engine][num_inst_issue_queue]));
			        if (_param->_have_port_ooo_engine_id)
                                  {
                                Tcontext_t ooo_engine_id = _param->_translate_num_ooo_engine_to_execute_loop_ooo_engine_id [num_ooo_engine][num_execute_loop];
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID         [num_execute_loop][num_read_unit],ooo_engine_id);
                                  }
			        if (_param->_have_port_rob_ptr)
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_PACKET_ID             [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_PACKET_ID             [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_OPERATION             [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_OPERATION             [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_TYPE                  [num_execute_loop][num_read_unit],type);
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE [num_ooo_engine][num_inst_issue_queue]));
			        if (_param->_have_port_load_queue_ptr)
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE  [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE  [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT          [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT          [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_IMMEDIAT              [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_IMMEDIAT              [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RA               [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RA               [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RA            [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RA            [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RB               [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RB               [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RB            [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RB            [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RC               [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RC               [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RC            [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RC            [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_WRITE_RD              [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_WRITE_RD              [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RD            [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RD            [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_WRITE_RE              [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_WRITE_RE              [num_ooo_engine][num_inst_issue_queue]));
			        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RE            [num_execute_loop][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RE            [num_ooo_engine][num_inst_issue_queue]));
                              
                                
                                find = true;
                                break;
                              }
                            //if (find)
                            //  break;
                          }
                        if (find)
                          break;
                      }
                  if (find)
                    break;
                }
            
            if (_param->_issue_queue_in_order [num_ooo_engine] and
                not find and 
                (num_inst_issue_queue >= _param->_nb_inst_reexecute [num_ooo_engine]))
              {
                log_printf(TRACE,Core_Glue,FUNCTION,"  * stop scan !!!");
                
                break; // stop scan
              }
          }
      }

    // Write output
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_param->_nb_inst_issue_queue[i]; ++j)
        PORT_WRITE(out_ISSUE_OOO_ENGINE_ACK [i][j], ISSUE_OOO_ENGINE_ACK [i][j]);
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_VAL [i][j], ISSUE_EXECUTE_LOOP_VAL [i][j]);

    log_end(Core_Glue,FUNCTION);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif

    /*
    bool       OOO_ENGINE_ENABLE      [_param->_nb_ooo_engine  ];
    Tcontrol_t SLOT_ENABLE            [_param->_nb_ooo_engine  ][_param->_max_nb_inst_issue_slot];
    bool       READ_UNIT_ENABLE       [_param->_nb_execute_loop][_param->_max_nb_read_unit];

    // Init -> all at 0
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      {
        OOO_ENGINE_ENABLE [i] = true;

        for (uint32_t j=0; j<_param->_nb_inst_issue_slot[i]; ++j)
          SLOT_ENABLE [i][j] = 1;         
      }

    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
        {
          // Read unit is enable is signal ack is set
          READ_UNIT_ENABLE       [i][j] = (PORT_READ(in_ISSUE_EXECUTE_LOOP_ACK [i][j]) == 1);
	  log_printf(TRACE,Core_Glue,FUNCTION,"  * Read_unit [%d][%d].enable : %d",i,j,READ_UNIT_ENABLE[i][j]);
        }


    // for each execute_loop
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      {
        // Scan all read_unit
        std::list<generic::priority::select_t> * select_read_unit = _priority_read_unit[i]->select();
        for (std::list<generic::priority::select_t>::iterator it_read_unit=select_read_unit->begin();
             it_read_unit!=select_read_unit->end();
             ++it_read_unit)
          {
            // get the most priotary ...
            uint32_t num_read_unit = it_read_unit->grp;
            
            log_printf(TRACE,Core_Glue,FUNCTION,"  * read_unit [%d][%d]",i,num_read_unit);

            // ... and test if this read_unit is valid
            if (READ_UNIT_ENABLE [i][num_read_unit])
              {
                bool find = false;
                
                // This read_unit is valid, now find an valid instruction
                // for each issue of each ooo_engine ...
                std::list<generic::priority::select_t> * select_ooo_engine = _priority_ooo_engine[i]->select();
                for (std::list<generic::priority::select_t>::iterator it_ooo_engine=select_ooo_engine->begin();
                     it_ooo_engine!=select_ooo_engine->end();
                     ++it_ooo_engine)
                  { 
                    // ... get id of the most priotary
                    const uint32_t ooo_engine_id       = it_ooo_engine->grp;
                    const uint32_t num_ooo_engine      = _param->_translate_execute_loop_num_ooo_engine [i][ooo_engine_id];
                    const uint32_t num_inst_issue_slot = it_ooo_engine->elt;
                    
                    log_printf(TRACE,Core_Glue,FUNCTION,"    * num_ooo_engine [%d (%d)][%d]",num_ooo_engine, ooo_engine_id,num_inst_issue_slot);
                    
                    if (OOO_ENGINE_ENABLE [num_ooo_engine] and SLOT_ENABLE [num_ooo_engine][num_inst_issue_slot])
                      {
                        uint32_t num_inst_issue_queue = 0;
                        for (; num_inst_issue_queue < _param->_nb_inst_issue_queue [num_ooo_engine]; num_inst_issue_queue ++)
                          {
                            // Test if this instruction is not previously send at a read_unit
                            if (not ISSUE_OOO_ENGINE_ACK [num_ooo_engine][num_inst_issue_queue])
                              {
                                Tcontrol_t ooo_engine_val = PORT_READ(in_ISSUE_OOO_ENGINE_VAL  [num_ooo_engine][num_inst_issue_queue]);
                                Ttype_t    type           = PORT_READ(in_ISSUE_OOO_ENGINE_TYPE [num_ooo_engine][num_inst_issue_queue]);
                                // Test if have an link and read unit is enable
                                bool can_dispatch   = _param->_table_dispatch [num_ooo_engine][num_inst_issue_slot][i][num_read_unit];
                                bool can_issue_type = _param->_table_issue_type [i][num_read_unit][type];
                                
                                log_printf(TRACE,Core_Glue,FUNCTION,"      * num_ooo_engine_queue  : %d",num_inst_issue_queue);
                                log_printf(TRACE,Core_Glue,FUNCTION,"      * type                  : %s",toString(type).c_str());
                                log_printf(TRACE,Core_Glue,FUNCTION,"      * ISSUE_OOO_ENGINE_VAL  : %d",ooo_engine_val);
                                log_printf(TRACE,Core_Glue,FUNCTION,"      * table_dispatch        : %d",can_dispatch);
                                log_printf(TRACE,Core_Glue,FUNCTION,"      * table_issue_type      : %d",can_issue_type);
                                
                                
                                // test if have a request ?
                                // and test if have a link between the issue slot and read_unit 
                                // and if the read_unit accept this instruction's type
                                if (ooo_engine_val and 
                                    can_dispatch   and
                                    can_issue_type)
                                  {
//                                     log_printf(TRACE,Core_Glue,FUNCTION,"          * find !!!");
                                    
                                    // Transaction
                                    READ_UNIT_ENABLE       [i][num_read_unit] = false; // now, this read_unit is busy
                                    ISSUE_EXECUTE_LOOP_VAL [i][num_read_unit] = ooo_engine_val;
                                    ISSUE_OOO_ENGINE_ACK   [num_ooo_engine][num_inst_issue_queue] = 1;
                                    SLOT_ENABLE            [num_ooo_engine][num_inst_issue_slot]  = 0; // now this slot is used
                                      
			            if (_param->_have_port_context_id)
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_CONTEXT_ID            [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_CONTEXT_ID            [num_ooo_engine][num_inst_issue_queue]));
			            if (_param->_have_port_front_end_id)
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_FRONT_END_ID          [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_FRONT_END_ID          [num_ooo_engine][num_inst_issue_queue]));
			            if (_param->_have_port_ooo_engine_id)
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID         [i][num_read_unit],ooo_engine_id);
			            if (_param->_have_port_rob_ptr)
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_PACKET_ID             [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_PACKET_ID             [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_OPERATION             [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_OPERATION             [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_TYPE                  [i][num_read_unit],type);
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE [num_ooo_engine][num_inst_issue_queue]));
			            if (_param->_have_port_load_queue_ptr)
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE  [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE  [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT          [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT          [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_IMMEDIAT              [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_IMMEDIAT              [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RA               [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RA               [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RA            [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RA            [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RB               [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RB               [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RB            [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RB            [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RC               [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RC               [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RC            [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RC            [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_WRITE_RD              [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_WRITE_RD              [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RD            [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RD            [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_WRITE_RE              [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_WRITE_RE              [num_ooo_engine][num_inst_issue_queue]));
			            PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RE            [i][num_read_unit],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RE            [num_ooo_engine][num_inst_issue_queue]));
                                    
                                    find = true;// find : stop scan read_unit
                                  }
                              }
                            if (find)
                              break;
                          }

                        if (find)
                          {
                            log_printf(TRACE,Core_Glue,FUNCTION,"    * find !!!");
                            break;
                          }
                        else
                          {
                            log_printf(TRACE,Core_Glue,FUNCTION,"    * not find !!!");
                            log_printf(TRACE,Core_Glue,FUNCTION,"      * issue_queue_in_order: %d",_param->_issue_queue_in_order [num_ooo_engine]);
                            log_printf(TRACE,Core_Glue,FUNCTION,"      * num_inst_issue_queue: %d",num_inst_issue_queue);
                            log_printf(TRACE,Core_Glue,FUNCTION,"      * nb_inst_reexecute   : %d",_param->_nb_inst_reexecute [num_ooo_engine]);

                            if (_param->_issue_queue_in_order [num_ooo_engine] and
                                (num_inst_issue_queue >= _param->_nb_inst_reexecute [num_ooo_engine]))
                                OOO_ENGINE_ENABLE [num_ooo_engine] = false;
                          }
                      }
                  }
              }
          }
      }
    */ 

