/*
 * $Id: Commit_unit.cpp 121 2009-05-27 10:13:56Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Commit_unit.h"
#include "Behavioural/include/Simulation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace commit_unit {


#undef  FUNCTION
#define FUNCTION "Commit_unit::Commit_unit"
  Commit_unit::Commit_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Commit_unit,FUNCTION);

    usage_environment(_usage);

#if DEBUG_Commit_unit == true
    log_printf(TRACE,Commit_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif

    log_printf(INFO,Commit_unit,FUNCTION,_("<%s> Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Commit_unit,FUNCTION,_("<%s> Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Commit_unit,FUNCTION,_("<%s> Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        // Constant
	for (uint32_t i=0; i<_param->_nb_front_end; i++)
	  for (uint32_t j=0; j<_param->_nb_context [i]; j++)
	    {
              internal_EVENT_ACK [i][j] = 1;
              PORT_WRITE(out_EVENT_ACK [i][j], internal_EVENT_ACK [i][j]);

              internal_RETIRE_EVENT_VAL [i][j] = 1;
              PORT_WRITE(out_RETIRE_EVENT_VAL [i][j], internal_RETIRE_EVENT_VAL [i][j]);
            }

	log_printf(INFO,Commit_unit,FUNCTION,_("<%s> Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Commit_unit,FUNCTION,_("<%s> Method - genMoore"),_name.c_str());

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Commit_unit,FUNCTION,_("<%s> Method - genMealy_insert"),_name.c_str());

	SC_METHOD (genMealy_insert);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
// 	for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
// 	  for (uint32_t j=0; j<_param->_nb_inst_insert[i]; j++)
// 	    sensitive << (*(in_INSERT_VAL [i][j]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
// 	for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
// 	  for (uint32_t j=0; j<_param->_nb_inst_insert[i]; j++)
// 	    for (uint32_t x=0; x<_param->_nb_rename_unit; x++)
// 	      for (uint32_t y=0; y<_param->_nb_inst_insert[x]; y++)
// 		{
// 		  (*(out_INSERT_ACK       [i][j])) (*(in_INSERT_VAL [x][y]));
// 		  if (_param->_have_port_rob_ptr)
// 		  (*(out_INSERT_PACKET_ID [i][j])) (*(in_INSERT_VAL [x][y]));
// 		}
# endif    

	log_printf(INFO,Commit_unit,FUNCTION,_("<%s> Method - genMealy_retire"),_name.c_str());

	SC_METHOD (genMealy_retire);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
	for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	  for (uint32_t j=0; j<_param->_nb_inst_retire[i]; j++)
	    sensitive << (*(in_RETIRE_ACK [i][j]));

	for (uint32_t i=0; i<_param->_nb_front_end; ++i)
	  for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
	    sensitive << (*(in_SPR_WRITE_ACK [i][j]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	  for (uint32_t j=0; j<_param->_nb_inst_retire[i]; j++)
	    {
	      for (uint32_t x=0; x<_param->_nb_rename_unit; x++)
		for (uint32_t y=0; y<_param->_nb_inst_retire[x]; y++)
		  {
		    (*(out_RETIRE_VAL                   [i][j])) (*(in_RETIRE_ACK [x][y]));
		    if (_param->_have_port_front_end_id)
		    (*(out_RETIRE_FRONT_END_ID          [i][j])) (*(in_RETIRE_ACK [x][y]));
		    if (_param->_have_port_context_id)
		    (*(out_RETIRE_CONTEXT_ID            [i][j])) (*(in_RETIRE_ACK [x][y]));
// 		    (*(out_RETIRE_RENAME_UNIT_ID        [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_RETIRE_USE_STORE_QUEUE       [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_RETIRE_USE_LOAD_QUEUE        [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_RETIRE_STORE_QUEUE_PTR_WRITE [i][j])) (*(in_RETIRE_ACK [x][y]));
		    if (_param->_have_port_load_queue_ptr)
		    (*(out_RETIRE_LOAD_QUEUE_PTR_WRITE  [i][j])) (*(in_RETIRE_ACK [x][y]));
// 		    (*(out_RETIRE_READ_RA               [i][j])) (*(in_RETIRE_ACK [x][y]));
// 		    (*(out_RETIRE_NUM_REG_RA_PHY        [i][j])) (*(in_RETIRE_ACK [x][y]));
// 		    (*(out_RETIRE_READ_RB               [i][j])) (*(in_RETIRE_ACK [x][y]));
// 		    (*(out_RETIRE_NUM_REG_RB_PHY        [i][j])) (*(in_RETIRE_ACK [x][y]));
// 		    (*(out_RETIRE_READ_RC               [i][j])) (*(in_RETIRE_ACK [x][y]));
// 		    (*(out_RETIRE_NUM_REG_RC_PHY        [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_RETIRE_WRITE_RD              [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_RETIRE_NUM_REG_RD_LOG        [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_RETIRE_NUM_REG_RD_PHY_OLD    [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_RETIRE_NUM_REG_RD_PHY_NEW    [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_RETIRE_WRITE_RE              [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_RETIRE_NUM_REG_RE_LOG        [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_RETIRE_NUM_REG_RE_PHY_OLD    [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_RETIRE_NUM_REG_RE_PHY_NEW    [i][j])) (*(in_RETIRE_ACK [x][y]));
		  }

	      for (uint32_t x=0; x<_param->_nb_front_end; ++x)
		for (uint32_t y=0; y<_param->_nb_context[x]; ++y)
		  {
		    (*(out_RETIRE_VAL                   [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    if (_param->_have_port_front_end_id)
		    (*(out_RETIRE_FRONT_END_ID          [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    if (_param->_have_port_context_id)
		    (*(out_RETIRE_CONTEXT_ID            [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
// 		    (*(out_RETIRE_RENAME_UNIT_ID        [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_RETIRE_USE_STORE_QUEUE       [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_RETIRE_USE_LOAD_QUEUE        [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_RETIRE_STORE_QUEUE_PTR_WRITE [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    if (_param->_have_port_load_queue_ptr)
		    (*(out_RETIRE_LOAD_QUEUE_PTR_WRITE  [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
// 		    (*(out_RETIRE_READ_RA               [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
// 		    (*(out_RETIRE_NUM_REG_RA_PHY        [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
// 		    (*(out_RETIRE_READ_RB               [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
// 		    (*(out_RETIRE_NUM_REG_RB_PHY        [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
// 		    (*(out_RETIRE_READ_RC               [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
// 		    (*(out_RETIRE_NUM_REG_RC_PHY        [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_RETIRE_WRITE_RD              [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_RETIRE_NUM_REG_RD_LOG        [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_RETIRE_NUM_REG_RD_PHY_OLD    [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_RETIRE_NUM_REG_RD_PHY_NEW    [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_RETIRE_WRITE_RE              [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_RETIRE_NUM_REG_RE_LOG        [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_RETIRE_NUM_REG_RE_PHY_OLD    [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_RETIRE_NUM_REG_RE_PHY_NEW    [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		  }
	    }

	for (uint32_t i=0; i<_param->_nb_front_end; ++i)
	  for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
	    {
	      for (uint32_t x=0; x<_param->_nb_rename_unit; x++)
		for (uint32_t y=0; y<_param->_nb_inst_retire[x]; y++)
		  {
		    (*(out_SPR_WRITE_VAL       [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_SPR_WRITE_SR_F_VAL  [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_SPR_WRITE_SR_F      [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_SPR_WRITE_SR_CY_VAL [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_SPR_WRITE_SR_CY     [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_SPR_WRITE_SR_OV_VAL [i][j])) (*(in_RETIRE_ACK [x][y]));
		    (*(out_SPR_WRITE_SR_OV     [i][j])) (*(in_RETIRE_ACK [x][y]));
		  }

	      for (uint32_t x=0; x<_param->_nb_front_end; ++x)
		for (uint32_t y=0; y<_param->_nb_context[x]; ++y)
		  {
		    (*(out_SPR_WRITE_VAL       [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_SPR_WRITE_SR_F_VAL  [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_SPR_WRITE_SR_F      [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_SPR_WRITE_SR_CY_VAL [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_SPR_WRITE_SR_CY     [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_SPR_WRITE_SR_OV_VAL [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		    (*(out_SPR_WRITE_SR_OV     [i][j])) (*(in_SPR_WRITE_ACK [x][y]));
		  }
	    }
# endif    

	log_printf(INFO,Commit_unit,FUNCTION,_("<%s> Method - genMealy_commit"),_name.c_str());

	SC_METHOD (genMealy_commit);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
        for (uint32_t j=0; j<_param->_nb_inst_commit; j++)
          {
            sensitive << (*(in_COMMIT_VAL [j]));
            if (_param->_have_port_rob_ptr)
              sensitive << (*(in_COMMIT_PACKET_ID [j]));
          }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
        for (uint32_t j=0; j<_param->_nb_inst_commit; j++)
          for (uint32_t y=0; y<_param->_nb_inst_commit; y++)
            {
              (*(out_COMMIT_ACK [j])) (*(in_COMMIT_VAL       [y]));
              if (_param->_have_port_rob_ptr)
                (*(out_COMMIT_ACK [j])) (*(in_COMMIT_PACKET_ID [y]));
            }
# endif    
	
#endif

        // Init stop condition
        while (_simulation_nb_instruction_commited.size() < _param->_nb_thread)
          _simulation_nb_instruction_commited.push_back(0);
      }
    log_end(Commit_unit,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Commit_unit::~Commit_unit"
  Commit_unit::~Commit_unit (void)
  {
    log_begin(Commit_unit,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Commit_unit,FUNCTION,_("<%s> Deallocation"),_name.c_str());
    deallocation ();

    log_end(Commit_unit,FUNCTION);
  };

}; // end namespace commit_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
