/*
 * $Id: test.cpp 121 2009-05-27 10:13:56Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Register_translation_unit * _Register_translation_unit = new Register_translation_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_RENAME_VAL               ," in_RENAME_VAL               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_RENAME_ACK               ,"out_RENAME_ACK               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_FRONT_END_ID      ," in_RENAME_FRONT_END_ID      ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_CONTEXT_ID        ," in_RENAME_CONTEXT_ID        ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_READ_RA           ," in_RENAME_READ_RA           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_NUM_REG_RA_LOG    ," in_RENAME_NUM_REG_RA_LOG    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_READ_RB           ," in_RENAME_READ_RB           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_NUM_REG_RB_LOG    ," in_RENAME_NUM_REG_RB_LOG    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_READ_RC           ," in_RENAME_READ_RC           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_NUM_REG_RC_LOG    ," in_RENAME_NUM_REG_RC_LOG    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_WRITE_RD          ," in_RENAME_WRITE_RD          ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_NUM_REG_RD_LOG    ," in_RENAME_NUM_REG_RD_LOG    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_WRITE_RE          ," in_RENAME_WRITE_RE          ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RENAME_NUM_REG_RE_LOG    ," in_RENAME_NUM_REG_RE_LOG    ",Tspecial_address_t,_param->_nb_inst_insert);

  ALLOC1_SC_SIGNAL(out_INSERT_VAL               ,"out_INSERT_VAL               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_ACK               ," in_INSERT_ACK               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_FRONT_END_ID      ,"out_INSERT_FRONT_END_ID      ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_CONTEXT_ID        ,"out_INSERT_CONTEXT_ID        ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_READ_RA           ,"out_INSERT_READ_RA           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RA_LOG    ,"out_INSERT_NUM_REG_RA_LOG    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RA_PHY    ,"out_INSERT_NUM_REG_RA_PHY    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_READ_RB           ,"out_INSERT_READ_RB           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RB_LOG    ,"out_INSERT_NUM_REG_RB_LOG    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RB_PHY    ,"out_INSERT_NUM_REG_RB_PHY    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_READ_RC           ,"out_INSERT_READ_RC           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RC_LOG    ,"out_INSERT_NUM_REG_RC_LOG    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RC_PHY    ,"out_INSERT_NUM_REG_RC_PHY    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_WRITE_RD          ,"out_INSERT_WRITE_RD          ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RD_LOG    ,"out_INSERT_NUM_REG_RD_LOG    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RD_PHY_OLD,"out_INSERT_NUM_REG_RD_PHY_OLD",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RD_PHY_NEW,"out_INSERT_NUM_REG_RD_PHY_NEW",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_WRITE_RE          ,"out_INSERT_WRITE_RE          ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RE_LOG    ,"out_INSERT_NUM_REG_RE_LOG    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RE_PHY_OLD,"out_INSERT_NUM_REG_RE_PHY_OLD",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RE_PHY_NEW,"out_INSERT_NUM_REG_RE_PHY_NEW",Tspecial_address_t,_param->_nb_inst_insert);

  ALLOC1_SC_SIGNAL( in_RETIRE_VAL               ," in_RETIRE_VAL               ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_RETIRE_ACK               ,"out_RETIRE_ACK               ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_FRONT_END_ID      ," in_RETIRE_FRONT_END_ID      ",Tcontext_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_CONTEXT_ID        ," in_RETIRE_CONTEXT_ID        ",Tcontext_t        ,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_READ_RA           ," in_RETIRE_READ_RA           ",Tcontrol_t        ,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RA_PHY    ," in_RETIRE_NUM_REG_RA_PHY    ",Tgeneral_address_t,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_READ_RB           ," in_RETIRE_READ_RB           ",Tcontrol_t        ,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RB_PHY    ," in_RETIRE_NUM_REG_RB_PHY    ",Tgeneral_address_t,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_READ_RC           ," in_RETIRE_READ_RC           ",Tcontrol_t        ,_param->_nb_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RC_PHY    ," in_RETIRE_NUM_REG_RC_PHY    ",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_WRITE_RD          ," in_RETIRE_WRITE_RD          ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_LOG    ," in_RETIRE_NUM_REG_RD_LOG    ",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_PHY_OLD," in_RETIRE_NUM_REG_RD_PHY_OLD",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_PHY_NEW," in_RETIRE_NUM_REG_RD_PHY_NEW",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_WRITE_RE          ," in_RETIRE_WRITE_RE          ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_LOG    ," in_RETIRE_NUM_REG_RE_LOG    ",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_PHY_OLD," in_RETIRE_NUM_REG_RE_PHY_OLD",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_PHY_NEW," in_RETIRE_NUM_REG_RE_PHY_NEW",Tspecial_address_t,_param->_nb_inst_retire);

  ALLOC2_SC_SIGNAL( in_RETIRE_EVENT_VAL            ," in_RETIRE_EVENT_VAL            ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_EVENT_ACK            ,"out_RETIRE_EVENT_ACK            ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_RETIRE_EVENT_STATE          ," in_RETIRE_EVENT_STATE          ",Tevent_state_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Register_translation_unit.\n"),name.c_str());

  (*(_Register_translation_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Register_translation_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_VAL               ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_RENAME_ACK               ,_param->_nb_inst_insert);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_FRONT_END_ID      ,_param->_nb_inst_insert);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_CONTEXT_ID        ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_READ_RA           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_NUM_REG_RA_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_READ_RB           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_NUM_REG_RB_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_READ_RC           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_NUM_REG_RC_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_WRITE_RD          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_NUM_REG_RD_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_WRITE_RE          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RENAME_NUM_REG_RE_LOG    ,_param->_nb_inst_insert);

  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_VAL               ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_INSERT_ACK               ,_param->_nb_inst_insert);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_FRONT_END_ID      ,_param->_nb_inst_insert);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_CONTEXT_ID        ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_READ_RA           ,_param->_nb_inst_insert);
#ifdef DEBUG
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_NUM_REG_RA_LOG    ,_param->_nb_inst_insert);
#endif
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_NUM_REG_RA_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_READ_RB           ,_param->_nb_inst_insert);
#ifdef DEBUG
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_NUM_REG_RB_LOG    ,_param->_nb_inst_insert);
#endif
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_NUM_REG_RB_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_READ_RC           ,_param->_nb_inst_insert);
#ifdef DEBUG
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_NUM_REG_RC_LOG    ,_param->_nb_inst_insert);
#enif
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_NUM_REG_RC_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_WRITE_RD          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_NUM_REG_RD_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_NUM_REG_RD_PHY_OLD,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_NUM_REG_RD_PHY_NEW,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_WRITE_RE          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_NUM_REG_RE_LOG    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_NUM_REG_RE_PHY_OLD,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_INSERT_NUM_REG_RE_PHY_NEW,_param->_nb_inst_insert);
  
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_VAL               ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit,out_RETIRE_ACK               ,_param->_nb_inst_retire);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_FRONT_END_ID      ,_param->_nb_inst_retire);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_CONTEXT_ID        ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_READ_RA           ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_NUM_REG_RA_PHY    ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_READ_RB           ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_NUM_REG_RB_PHY    ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_READ_RC           ,_param->_nb_inst_retire);
//   INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_NUM_REG_RC_PHY    ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_WRITE_RD          ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_NUM_REG_RD_LOG    ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_NUM_REG_RD_PHY_OLD,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_NUM_REG_RD_PHY_NEW,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_WRITE_RE          ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_NUM_REG_RE_LOG    ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_NUM_REG_RE_PHY_OLD,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Register_translation_unit, in_RETIRE_NUM_REG_RE_PHY_NEW,_param->_nb_inst_retire);

  INSTANCE2_SC_SIGNAL(_Register_translation_unit, in_RETIRE_EVENT_VAL         ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Register_translation_unit,out_RETIRE_EVENT_ACK         ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Register_translation_unit, in_RETIRE_EVENT_STATE       ,_param->_nb_front_end, _param->_nb_context[it1]);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_RENAME_VAL               ;
  delete [] out_RENAME_ACK               ;
  delete []  in_RENAME_FRONT_END_ID      ;
  delete []  in_RENAME_CONTEXT_ID        ;
  delete []  in_RENAME_READ_RA           ;
  delete []  in_RENAME_NUM_REG_RA_LOG    ;
  delete []  in_RENAME_READ_RB           ;
  delete []  in_RENAME_NUM_REG_RB_LOG    ;
  delete []  in_RENAME_READ_RC           ;
  delete []  in_RENAME_NUM_REG_RC_LOG    ;
  delete []  in_RENAME_WRITE_RD          ;
  delete []  in_RENAME_NUM_REG_RD_LOG    ;
  delete []  in_RENAME_WRITE_RE          ;
  delete []  in_RENAME_NUM_REG_RE_LOG    ;

  delete [] out_INSERT_VAL               ;
  delete []  in_INSERT_ACK               ;
  delete [] out_INSERT_FRONT_END_ID      ;
  delete [] out_INSERT_CONTEXT_ID        ;
  delete [] out_INSERT_READ_RA           ;
#ifdef DEBUG
  delete [] out_INSERT_NUM_REG_RA_LOG    ;
#endif
  delete [] out_INSERT_NUM_REG_RA_PHY    ;
  delete [] out_INSERT_READ_RB           ;
#ifdef DEBUG
  delete [] out_INSERT_NUM_REG_RB_LOG    ;
#endif
  delete [] out_INSERT_NUM_REG_RB_PHY    ;
  delete [] out_INSERT_READ_RC           ;
#ifdef DEBUG
  delete [] out_INSERT_NUM_REG_RC_LOG    ;
#endif
  delete [] out_INSERT_NUM_REG_RC_PHY    ;
  delete [] out_INSERT_WRITE_RD          ;
  delete [] out_INSERT_NUM_REG_RD_LOG    ;
  delete [] out_INSERT_NUM_REG_RD_PHY_OLD;
  delete [] out_INSERT_NUM_REG_RD_PHY_NEW;
  delete [] out_INSERT_WRITE_RE          ;
  delete [] out_INSERT_NUM_REG_RE_LOG    ;
  delete [] out_INSERT_NUM_REG_RE_PHY_OLD;
  delete [] out_INSERT_NUM_REG_RE_PHY_NEW;

  delete []  in_RETIRE_VAL               ;
  delete [] out_RETIRE_ACK               ;
  delete []  in_RETIRE_FRONT_END_ID      ;
  delete []  in_RETIRE_CONTEXT_ID        ;
//   delete []  in_RETIRE_READ_RA           ;
//   delete []  in_RETIRE_NUM_REG_RA_PHY    ;
//   delete []  in_RETIRE_READ_RB           ;
//   delete []  in_RETIRE_NUM_REG_RB_PHY    ;
//   delete []  in_RETIRE_READ_RC           ;
//   delete []  in_RETIRE_NUM_REG_RC_PHY    ;
  delete []  in_RETIRE_WRITE_RD          ;
  delete []  in_RETIRE_NUM_REG_RD_LOG    ;
  delete []  in_RETIRE_NUM_REG_RD_PHY_OLD;
  delete []  in_RETIRE_NUM_REG_RD_PHY_NEW;
  delete []  in_RETIRE_WRITE_RE          ;
  delete []  in_RETIRE_NUM_REG_RE_LOG    ;
  delete []  in_RETIRE_NUM_REG_RE_PHY_OLD;
  delete []  in_RETIRE_NUM_REG_RE_PHY_NEW;

  DELETE2_SC_SIGNAL( in_RETIRE_EVENT_VAL            ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_EVENT_ACK            ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_RETIRE_EVENT_STATE          ,_param->_nb_front_end, _param->_nb_context[it1]);
#endif

  delete _Register_translation_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
