#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_issue_queue_Types_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_issue_queue_Types_h

/*
 * $Id: Types.h 122 2009-06-03 08:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {

  typedef enum 
    {
       ISSUE_QUEUE_SCHEME_IN_ORDER        // Each instruction is issue in of order
//       ,ISSUE_QUEUE_SCHEME_IN_BUNDLE_ORDER // Each bundle is issue in order. In bundle, an instruction is issue out of order
      ,ISSUE_QUEUE_SCHEME_OUT_OF_ORDER    // Each instruction is issue out of order
    } Tissue_queue_scheme_t;

  class entry_t
  {
  public : Tcontext_t         _context_id            ;
  public : Tcontext_t         _front_end_id          ;
  public : Tpacket_t          _packet_id             ;
  public : Toperation_t       _operation             ;
  public : Ttype_t            _type                  ;
  public : Tlsq_ptr_t         _store_queue_ptr_write ;
  public : Tlsq_ptr_t         _store_queue_ptr_read  ;
  public : Tcontrol_t         _store_queue_empty     ;
  public : Tlsq_ptr_t         _load_queue_ptr_write  ;
  public : Tcontrol_t         _has_immediat          ;
  public : Tgeneral_data_t    _immediat              ;
  public : Tcontrol_t         _read_ra               ;
  public : Tgeneral_address_t _num_reg_ra            ;
  public : Tcontrol_t         _read_rb               ;
  public : Tgeneral_address_t _num_reg_rb            ;
  public : Tcontrol_t         _read_rc               ;
  public : Tspecial_address_t _num_reg_rc            ;
  public : Tcontrol_t         _write_rd              ;
  public : Tgeneral_address_t _num_reg_rd            ;
  public : Tcontrol_t         _write_re              ;
  public : Tspecial_address_t _num_reg_re            ;
    
  public : entry_t (Tcontext_t         context_id            ,
		    Tcontext_t         front_end_id          ,
		    Tpacket_t          packet_id             ,
		    Toperation_t       operation             ,
		    Ttype_t            type                  ,
		    Tlsq_ptr_t         store_queue_ptr_write ,
		    Tlsq_ptr_t         store_queue_ptr_read  ,
		    Tcontrol_t         store_queue_empty     ,
		    Tlsq_ptr_t         load_queue_ptr_write  ,
		    Tcontrol_t         has_immediat          ,
		    Tgeneral_data_t    immediat              ,
		    Tcontrol_t         read_ra               ,
		    Tgeneral_address_t num_reg_ra            ,
		    Tcontrol_t         read_rb               ,
		    Tgeneral_address_t num_reg_rb            ,
		    Tcontrol_t         read_rc               ,
		    Tspecial_address_t num_reg_rc            ,
		    Tcontrol_t         write_rd              ,
		    Tgeneral_address_t num_reg_rd            ,
		    Tcontrol_t         write_re              ,
		    Tspecial_address_t num_reg_re            )
    {
      _context_id            = context_id           ;
      _front_end_id          = front_end_id         ;
      _packet_id             = packet_id            ;
      _operation             = operation            ;
      _type                  = type                 ;
      _store_queue_ptr_write = store_queue_ptr_write;
      _store_queue_ptr_read  = store_queue_ptr_read ;
      _store_queue_empty     = store_queue_empty    ;
      _load_queue_ptr_write  = load_queue_ptr_write ;
      _has_immediat          = has_immediat         ;
      _immediat              = immediat             ;
      _read_ra               = read_ra              ;
      _num_reg_ra            = num_reg_ra           ;
      _read_rb               = read_rb              ;
      _num_reg_rb            = num_reg_rb           ;
      _read_rc               = read_rc              ;
      _num_reg_rc            = num_reg_rc           ;
      _write_rd              = write_rd             ;
      _num_reg_rd            = num_reg_rd           ;
      _write_re              = write_re             ;
      _num_reg_re            = num_reg_re           ;
    }
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core
}; // end namespace behavioural

  template<> inline std::string toString<morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Tissue_queue_scheme_t>(const morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Tissue_queue_scheme_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::ISSUE_QUEUE_SCHEME_IN_ORDER        : return "in_order"       ; break;
//       case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::ISSUE_QUEUE_SCHEME_IN_BUNDLE_ORDER : return "in_bundle_order"; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::ISSUE_QUEUE_SCHEME_OUT_OF_ORDER    : return "out_of_order"   ; break;
      default : return ""; break;
      }
  };

  template<> inline morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Tissue_queue_scheme_t fromString<morpheo::behavioural::core::multi_ooo_engine
::ooo_engine::issue_queue::Tissue_queue_scheme_t>(const std::string& x)
  {
    if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::ISSUE_QUEUE_SCHEME_IN_ORDER))) == 0) or
         (x.compare("in_order")        == 0))
      return morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::ISSUE_QUEUE_SCHEME_IN_ORDER;
//     if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::ISSUE_QUEUE_SCHEME_IN_BUNDLE_ORDER))) == 0) or
//          (x.compare("in_bundle_order") == 0))
//       return morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::ISSUE_QUEUE_SCHEME_IN_BUNDLE_ORDER;
    if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::ISSUE_QUEUE_SCHEME_OUT_OF_ORDER))) == 0) or
         (x.compare("out_of_order")    == 0))
      return morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::ISSUE_QUEUE_SCHEME_OUT_OF_ORDER;
    
    throw (ErrorMorpheo ("<fromString> : Unknow string : \""+x+"\""));
  };

}; // end namespace morpheo              

#endif
