#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_rename_unit_glue_Rename_unit_Glue_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_rename_unit_glue_Rename_unit_Glue_h

/*
 * $Id: Rename_unit_Glue.h 122 2009-06-03 08:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_unit_Glue/include/Parameters.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_unit_Glue/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_unit_glue {


  class Rename_unit_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_VAL                                    ;//[nb_inst_insert]
//public    : SC_IN (Tcontrol_t        )   **  in_INSERT_ACK                                    ;//[nb_inst_insert]
  public    : SC_OUT(Tcontext_t        )   ** out_INSERT_FRONT_END_ID                           ;//[nb_inst_insert]
  public    : SC_OUT(Tcontext_t        )   ** out_INSERT_CONTEXT_ID                             ;//[nb_inst_insert]
  public    : SC_OUT(Ttype_t           )   ** out_INSERT_TYPE                                   ;//[nb_inst_insert]
  public    : SC_OUT(Toperation_t      )   ** out_INSERT_OPERATION                              ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_data_t   )   ** out_INSERT_IMMEDIAT                               ;//[nb_inst_insert]
  public    : SC_OUT(Texception_t      )   ** out_INSERT_EXCEPTION_USE                          ;//[nb_inst_insert]
  public    : SC_OUT(Texception_t      )   ** out_INSERT_EXCEPTION                              ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_INSERT_NUM_REG_RE_PHY_NEW                     ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_NO_EXECUTE                             ;//[nb_inst_insert]
											        
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_RENAME_SELECT_VAL                      ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_RENAME_SELECT_ACK                      ;//[nb_inst_insert]
  public    : SC_IN (Tcontext_t        )   **  in_INSERT_RENAME_SELECT_FRONT_END_ID             ;//[nb_inst_insert]
  public    : SC_IN (Tcontext_t        )   **  in_INSERT_RENAME_SELECT_CONTEXT_ID               ;//[nb_inst_insert]
  public    : SC_IN (Ttype_t           )   **  in_INSERT_RENAME_SELECT_TYPE                     ;//[nb_inst_insert]
  public    : SC_IN (Toperation_t      )   **  in_INSERT_RENAME_SELECT_OPERATION                ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_data_t   )   **  in_INSERT_RENAME_SELECT_IMMEDIAT                 ;//[nb_inst_insert]
  public    : SC_IN (Texception_t      )   **  in_INSERT_RENAME_SELECT_EXCEPTION_USE            ;//[nb_inst_insert]
  public    : SC_IN (Texception_t      )   **  in_INSERT_RENAME_SELECT_EXCEPTION                ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_RENAME_SELECT_NO_EXECUTE               ;//[nb_inst_insert]
											        
  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_REGISTER_TRANSLATION_VAL               ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_REGISTER_TRANSLATION_ACK               ;//[nb_inst_insert]
  public    : SC_OUT(Tcontext_t        )   ** out_INSERT_REGISTER_TRANSLATION_FRONT_END_ID      ;//[nb_inst_insert]
  public    : SC_OUT(Tcontext_t        )   ** out_INSERT_REGISTER_TRANSLATION_CONTEXT_ID        ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_INSERT_REGISTER_TRANSLATION_NUM_REG_RE_PHY_NEW;//[nb_inst_insert]

  public    : SC_OUT(Tcontrol_t        )   ** out_INSERT_LOAD_STORE_QUEUE_POINTER_VAL           ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_INSERT_LOAD_STORE_QUEUE_POINTER_ACK           ;//[nb_inst_insert]
  public    : SC_OUT(Tcontext_t        )   ** out_INSERT_LOAD_STORE_QUEUE_POINTER_FRONT_END_ID  ;//[nb_inst_insert]
  public    : SC_OUT(Tcontext_t        )   ** out_INSERT_LOAD_STORE_QUEUE_POINTER_CONTEXT_ID    ;//[nb_inst_insert]
  public    : SC_OUT(Ttype_t           )   ** out_INSERT_LOAD_STORE_QUEUE_POINTER_TYPE          ;//[nb_inst_insert]
  public    : SC_OUT(Toperation_t      )   ** out_INSERT_LOAD_STORE_QUEUE_POINTER_OPERATION     ;//[nb_inst_insert]
											        
    // ~~~~~[ Interface : "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~		        
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_VAL                                    ;//[nb_inst_retire]
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_ACK                                    ;//[nb_inst_retire]
											        
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_LOAD_STORE_QUEUE_POINTER_VAL           ;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_LOAD_STORE_QUEUE_POINTER_ACK           ;//[nb_inst_retire]
											        
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_REGISTER_TRANSLATION_VAL               ;//[nb_inst_retire]
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_REGISTER_TRANSLATION_ACK               ;//[nb_inst_retire]

    // ~~~~~[ Interface : "retire_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_EVENT_VAL                              ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t        )  *** out_RETIRE_EVENT_ACK                              ;//[nb_front_end][nb_context]
											        
  public    : SC_OUT(Tcontrol_t        )  *** out_RETIRE_EVENT_LOAD_STORE_QUEUE_POINTER_VAL     ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_EVENT_LOAD_STORE_QUEUE_POINTER_ACK     ;//[nb_front_end][nb_context]
											        
  public    : SC_OUT(Tcontrol_t        )  *** out_RETIRE_EVENT_REGISTER_TRANSLATION_VAL         ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_EVENT_REGISTER_TRANSLATION_ACK         ;//[nb_front_end][nb_context]

    // ~~~~~[ Interface : "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~		        
  public    : SC_IN (Tspr_t            )  ***  in_SPR_READ_SR                                   ;//[nb_front_end][nb_context]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Rename_unit_Glue);
#endif
  public  :          Rename_unit_Glue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Rename_unit_Glue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                   (void);
//public  : void        genMoore                     (void);
  public  : void        genMealy_insert_valack       (void);
  public  : void        genMealy_retire_valack       (void);
  public  : void        genMealy_retire_event_valack (void);
  public  : void        genMealy_insert              (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace rename_unit_glue
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
