/*
 * $Id: Rename_unit_Glue_allocation.cpp 122 2009-06-03 08:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_unit_Glue/include/Rename_unit_Glue.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_unit_glue {



#undef  FUNCTION
#define FUNCTION "Rename_unit_Glue::allocation"
  void Rename_unit_Glue::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_begin(Rename_unit_Glue,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Rename_unit_Glue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("insert",OUT,NORTH,_("Insert interface"),_param->_nb_inst_insert);

//    ALLOC1_SIGNAL_OUT(out_INSERT_VAL                                    ,"VAL"                                    ,Tcontrol_t        ,1);
//    ALLOC1_SIGNAL_IN ( in_INSERT_ACK                                    ,"ACK"                                    ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_FRONT_END_ID                           ,"FRONT_END_ID"                           ,Tcontext_t        ,_param->_size_front_end_id);
      ALLOC1_SIGNAL_OUT(out_INSERT_CONTEXT_ID                             ,"CONTEXT_ID"                             ,Tcontext_t        ,_param->_size_context_id);
      ALLOC1_SIGNAL_OUT(out_INSERT_TYPE                                   ,"TYPE"                                   ,Ttype_t           ,_param->_size_type);
      ALLOC1_SIGNAL_OUT(out_INSERT_OPERATION                              ,"OPERATION"                              ,Toperation_t      ,_param->_size_operation);
      ALLOC1_SIGNAL_OUT(out_INSERT_IMMEDIAT                               ,"IMMEDIAT"                               ,Tgeneral_data_t   ,_param->_size_general_data);
//    ALLOC1_SIGNAL_OUT(out_INSERT_EXCEPTION_USE                          ,"EXCEPTION_USE"                          ,Texception_t      ,_param->_size_exception_use);
      ALLOC1_SIGNAL_OUT(out_INSERT_EXCEPTION                              ,"EXCEPTION"                              ,Texception_t      ,_param->_size_exception);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RE_PHY_NEW                     ,"NUM_REG_RE_PHY_NEW"                     ,Tspecial_address_t,_param->_size_special_register);
      ALLOC1_SIGNAL_OUT(out_INSERT_NO_EXECUTE                             ,"NO_EXECUTE"                             ,Tcontrol_t        ,1);

      ALLOC1_SIGNAL_IN ( in_INSERT_RENAME_SELECT_VAL                      ,"RENAME_SELECT_VAL"                      ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_RENAME_SELECT_ACK                      ,"RENAME_SELECT_ACK"                      ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_RENAME_SELECT_FRONT_END_ID             ,"RENAME_SELECT_FRONT_END_ID"             ,Tcontext_t        ,_param->_size_front_end_id);
      ALLOC1_SIGNAL_IN ( in_INSERT_RENAME_SELECT_CONTEXT_ID               ,"RENAME_SELECT_CONTEXT_ID"               ,Tcontext_t        ,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_INSERT_RENAME_SELECT_TYPE                     ,"RENAME_SELECT_TYPE"                     ,Ttype_t           ,_param->_size_type);
      ALLOC1_SIGNAL_IN ( in_INSERT_RENAME_SELECT_OPERATION                ,"RENAME_SELECT_OPERATION"                ,Toperation_t      ,_param->_size_operation);
      ALLOC1_SIGNAL_IN ( in_INSERT_RENAME_SELECT_IMMEDIAT                 ,"RENAME_SELECT_IMMEDIAT"                 ,Tgeneral_data_t   ,_param->_size_general_data);
//    ALLOC1_SIGNAL_IN ( in_INSERT_RENAME_SELECT_EXCEPTION_USE            ,"RENAME_SELECT_EXCEPTION_USE"            ,Texception_t      ,_param->_size_exception_use);
      ALLOC1_SIGNAL_IN ( in_INSERT_RENAME_SELECT_EXCEPTION                ,"RENAME_SELECT_EXCEPTION"                ,Texception_t      ,_param->_size_exception);
      ALLOC1_SIGNAL_IN ( in_INSERT_RENAME_SELECT_NO_EXECUTE               ,"RENAME_SELECT_NO_EXECUTE"               ,Tcontrol_t        ,1);

      ALLOC1_SIGNAL_OUT(out_INSERT_REGISTER_TRANSLATION_VAL               ,"REGISTER_TRANSLATION_VAL"               ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_REGISTER_TRANSLATION_ACK               ,"REGISTER_TRANSLATION_ACK"               ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_REGISTER_TRANSLATION_FRONT_END_ID      ,"REGISTER_TRANSLATION_FRONT_END_ID"      ,Tcontext_t        ,_param->_size_front_end_id);
      ALLOC1_SIGNAL_OUT(out_INSERT_REGISTER_TRANSLATION_CONTEXT_ID        ,"REGISTER_TRANSLATION_CONTEXT_ID"        ,Tcontext_t        ,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_INSERT_REGISTER_TRANSLATION_NUM_REG_RE_PHY_NEW,"REGISTER_TRANSLATION_NUM_REG_RE_PHY_NEW",Tspecial_address_t,_param->_size_special_register);
      ALLOC1_SIGNAL_OUT(out_INSERT_LOAD_STORE_QUEUE_POINTER_VAL           ,"LOAD_STORE_QUEUE_POINTER_VAL"           ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_INSERT_LOAD_STORE_QUEUE_POINTER_ACK           ,"LOAD_STORE_QUEUE_POINTER_ACK"           ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_INSERT_LOAD_STORE_QUEUE_POINTER_FRONT_END_ID  ,"LOAD_STORE_QUEUE_POINTER_FRONT_END_ID"  ,Tcontext_t        ,_param->_size_front_end_id);
      ALLOC1_SIGNAL_OUT(out_INSERT_LOAD_STORE_QUEUE_POINTER_CONTEXT_ID    ,"LOAD_STORE_QUEUE_POINTER_CONTEXT_ID"    ,Tcontext_t        ,_param->_size_context_id);
      ALLOC1_SIGNAL_OUT(out_INSERT_LOAD_STORE_QUEUE_POINTER_TYPE          ,"LOAD_STORE_QUEUE_POINTER_TYPE"          ,Ttype_t           ,_param->_size_type);
      ALLOC1_SIGNAL_OUT(out_INSERT_LOAD_STORE_QUEUE_POINTER_OPERATION     ,"LOAD_STORE_QUEUE_POINTER_OPERATION"     ,Toperation_t      ,_param->_size_operation);

      ALLOC1_INTERFACE_END(_param->_nb_inst_insert);
    }

    // ~~~~~[ Interface : "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("retire",OUT,NORTH,_("Retire interface"),_param->_nb_inst_retire);

      ALLOC1_SIGNAL_IN ( in_RETIRE_VAL                                   ,"VAL"                                  ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_RETIRE_ACK                                   ,"ACK"                                  ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_RETIRE_LOAD_STORE_QUEUE_POINTER_VAL          ,"LOAD_STORE_QUEUE_POINTER_VAL"         ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_RETIRE_LOAD_STORE_QUEUE_POINTER_ACK          ,"LOAD_STORE_QUEUE_POINTER_ACK"         ,Tcontrol_t        ,1);
//    ALLOC1_SIGNAL_OUT(out_RETIRE_LOAD_STORE_QUEUE_POINTER_TYPE         ,"LOAD_STORE_QUEUE_POINTER_TYPE"        ,Ttype_t           ,_param->_size_type);
//    ALLOC1_SIGNAL_OUT(out_RETIRE_LOAD_STORE_QUEUE_POINTER_OPERATION    ,"LOAD_STORE_QUEUE_POINTER_OPERATION"   ,Toperation_t      ,_param->_size_operation);
      ALLOC1_SIGNAL_OUT(out_RETIRE_REGISTER_TRANSLATION_VAL              ,"REGISTER_TRANSLATION_VAL"             ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_RETIRE_REGISTER_TRANSLATION_ACK              ,"REGISTER_TRANSLATION_ACK"             ,Tcontrol_t        ,1);

      ALLOC1_INTERFACE_END(_param->_nb_inst_retire);
    }

    // ~~~~~[ Interface : "retire_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("retire_event",OUT,NORTH,_("Retire_Event interface"),_param->_nb_front_end,_param->_nb_context[it1]);

      _ALLOC2_SIGNAL_IN ( in_RETIRE_EVENT_VAL                             ,"VAL"                                  ,Tcontrol_t        ,1,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_EVENT_ACK                             ,"ACK"                                  ,Tcontrol_t        ,1,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_EVENT_LOAD_STORE_QUEUE_POINTER_VAL    ,"LOAD_STORE_QUEUE_POINTER_VAL"         ,Tcontrol_t        ,1,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_RETIRE_EVENT_LOAD_STORE_QUEUE_POINTER_ACK    ,"LOAD_STORE_QUEUE_POINTER_ACK"         ,Tcontrol_t        ,1,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_RETIRE_EVENT_REGISTER_TRANSLATION_VAL        ,"REGISTER_TRANSLATION_VAL"             ,Tcontrol_t        ,1,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_RETIRE_EVENT_REGISTER_TRANSLATION_ACK        ,"REGISTER_TRANSLATION_ACK"             ,Tcontrol_t        ,1,_param->_nb_front_end,_param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end,_param->_nb_context[it1]);
    }

    // ~~~~~[ Interface : "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("spr_read",IN ,NORTH,_("SPR read"),_param->_nb_front_end,_param->_nb_context[it1]);

      _ALLOC2_SIGNAL_IN ( in_SPR_READ_SR                                  ,"SR"                                   ,Tspr_t            ,_param->_size_spr,_param->_nb_front_end,_param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end,_param->_nb_context[it1]);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
	_component->generate_file();
#endif

    log_end(Rename_unit_Glue,FUNCTION);
  };

}; // end namespace rename_unit_glue
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
