#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_reservation_station_Reservation_station_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_reservation_station_Reservation_station_h

/*
 * $Id: Reservation_station.h 122 2009-06-03 08:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#ifndef  SYSTEMC_VHDL_COMPATIBILITY
#include "Behavioural/Generic/Queue_Control/include/Queue_Control.h"
#endif
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace reservation_station {

  class Reservation_station 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )    *  in_INSERT_VAL            ;
  public    : SC_OUT(Tcontrol_t        )    * out_INSERT_ACK            ;
  public    : SC_IN (Tcontext_t        )    *  in_INSERT_CONTEXT_ID     ;
  public    : SC_IN (Tcontext_t        )    *  in_INSERT_FRONT_END_ID   ;
  public    : SC_IN (Tcontext_t        )    *  in_INSERT_OOO_ENGINE_ID  ;
  public    : SC_IN (Tpacket_t         )    *  in_INSERT_ROB_ID         ;
  public    : SC_IN (Toperation_t      )    *  in_INSERT_OPERATION      ;
  public    : SC_IN (Ttype_t           )    *  in_INSERT_TYPE           ;
  public    : SC_IN (Tlsq_ptr_t        )    *  in_INSERT_STORE_QUEUE_PTR_WRITE;
  public    : SC_IN (Tlsq_ptr_t        )    *  in_INSERT_STORE_QUEUE_PTR_READ ;
  public    : SC_IN (Tcontrol_t        )    *  in_INSERT_STORE_QUEUE_EMPTY    ;
  public    : SC_IN (Tlsq_ptr_t        )    *  in_INSERT_LOAD_QUEUE_PTR_WRITE ;
  public    : SC_IN (Tcontrol_t        )    *  in_INSERT_HAS_IMMEDIAT   ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_INSERT_IMMEDIAT       ;
//public    : SC_IN (Tcontrol_t        )    *  in_INSERT_READ_RA        ;
  public    : SC_IN (Tgeneral_address_t)    *  in_INSERT_NUM_REG_RA     ;
  public    : SC_IN (Tcontrol_t        )    *  in_INSERT_DATA_RA_VAL    ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_INSERT_DATA_RA        ;
//public    : SC_IN (Tcontrol_t        )    *  in_INSERT_READ_RB        ;
  public    : SC_IN (Tgeneral_address_t)    *  in_INSERT_NUM_REG_RB     ;
  public    : SC_IN (Tcontrol_t        )    *  in_INSERT_DATA_RB_VAL    ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_INSERT_DATA_RB        ;
//public    : SC_IN (Tcontrol_t        )    *  in_INSERT_READ_RC        ;
  public    : SC_IN (Tspecial_address_t)    *  in_INSERT_NUM_REG_RC     ;
  public    : SC_IN (Tcontrol_t        )    *  in_INSERT_DATA_RC_VAL    ;
  public    : SC_IN (Tspecial_data_t   )    *  in_INSERT_DATA_RC        ;
  public    : SC_IN (Tcontrol_t        )    *  in_INSERT_WRITE_RD       ;
  public    : SC_IN (Tgeneral_address_t)    *  in_INSERT_NUM_REG_RD     ;
  public    : SC_IN (Tcontrol_t        )    *  in_INSERT_WRITE_RE       ;
  public    : SC_IN (Tspecial_address_t)    *  in_INSERT_NUM_REG_RE     ;

    // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_VAL            ;
  public    : SC_IN (Tcontrol_t        )   **  in_RETIRE_ACK            ;
  public    : SC_OUT(Tcontext_t        )   ** out_RETIRE_CONTEXT_ID     ;
  public    : SC_OUT(Tcontext_t        )   ** out_RETIRE_FRONT_END_ID   ;
  public    : SC_OUT(Tcontext_t        )   ** out_RETIRE_OOO_ENGINE_ID  ;
  public    : SC_OUT(Tpacket_t         )   ** out_RETIRE_ROB_ID         ;
  public    : SC_OUT(Toperation_t      )   ** out_RETIRE_OPERATION      ;
  public    : SC_OUT(Ttype_t           )   ** out_RETIRE_TYPE           ;
  public    : SC_OUT(Tlsq_ptr_t        )   ** out_RETIRE_STORE_QUEUE_PTR_WRITE;
  public    : SC_OUT(Tlsq_ptr_t        )   ** out_RETIRE_STORE_QUEUE_PTR_READ ;
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_STORE_QUEUE_EMPTY    ;
  public    : SC_OUT(Tlsq_ptr_t        )   ** out_RETIRE_LOAD_QUEUE_PTR_WRITE ;
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_HAS_IMMEDIAT   ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_RETIRE_IMMEDIAT       ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_RETIRE_DATA_RA        ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_RETIRE_DATA_RB        ;
  public    : SC_OUT(Tspecial_data_t   )   ** out_RETIRE_DATA_RC        ;
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_WRITE_RD       ;
  public    : SC_OUT(Tgeneral_address_t)   ** out_RETIRE_NUM_REG_RD     ;
  public    : SC_OUT(Tcontrol_t        )   ** out_RETIRE_WRITE_RE       ;
  public    : SC_OUT(Tspecial_address_t)   ** out_RETIRE_NUM_REG_RE     ;

    // ~~~~~[ Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontrol_t        )   **  in_GPR_WRITE_VAL          ; // val and ack
  public    : SC_IN (Tcontext_t        )   **  in_GPR_WRITE_OOO_ENGINE_ID;
  public    : SC_IN (Tgeneral_address_t)   **  in_GPR_WRITE_NUM_REG      ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_GPR_WRITE_DATA         ;

    // ~~~~~[ Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontrol_t        )   **  in_SPR_WRITE_VAL          ; // val and ack
  public    : SC_IN (Tcontext_t        )   **  in_SPR_WRITE_OOO_ENGINE_ID;
  public    : SC_IN (Tspecial_address_t)   **  in_SPR_WRITE_NUM_REG      ;
  public    : SC_IN (Tspecial_data_t   )   **  in_SPR_WRITE_DATA         ;

    // ~~~~~[ Interface "bypass_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontext_t        )   **  in_BYPASS_WRITE_OOO_ENGINE_ID ;
  public    : SC_IN (Tcontrol_t        )   **  in_BYPASS_WRITE_GPR_VAL       ;
  public    : SC_IN (Tgeneral_address_t)   **  in_BYPASS_WRITE_GPR_NUM_REG   ; // RD
  public    : SC_IN (Tgeneral_data_t   )   **  in_BYPASS_WRITE_GPR_DATA      ;
  public    : SC_IN (Tcontrol_t        )   **  in_BYPASS_WRITE_SPR_VAL       ;
  public    : SC_IN (Tspecial_address_t)   **  in_BYPASS_WRITE_SPR_NUM_REG   ; // RE
  public    : SC_IN (Tspecial_data_t   )   **  in_BYPASS_WRITE_SPR_DATA      ;

    // ~~~~~[ Interface "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  public    : SC_IN (Tcontrol_t        )   **  in_BYPASS_MEMORY_VAL          ;
  public    : SC_IN (Tcontext_t        )   **  in_BYPASS_MEMORY_OOO_ENGINE_ID;
  public    : SC_IN (Tgeneral_address_t)   **  in_BYPASS_MEMORY_NUM_REG      ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_BYPASS_MEMORY_DATA         ;


    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#ifdef  SYSTEMC_VHDL_COMPATIBILITY
  protected : bool                          *  _queue_valid;
  protected : uint32_t                         internal_INSERT_SLOT;
#else
  protected : morpheo::behavioural::generic::queue_control::Queue_Control * _queue_control;
#endif
  protected : Treservation_station_entry_t  *  _queue;

  protected : Tcontrol_t                       internal_INSERT_ACK;
  protected : Tcontrol_t                    *  internal_RETIRE_VAL;
  protected : uint32_t                      *  internal_RETIRE_SLOT;
#endif

    // -----[ methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Reservation_station);
#endif
  public  :          Reservation_station              (
#ifdef SYSTEMC
						       sc_module_name                                name,
#else					       
						       string                                        name,
#endif					       
#ifdef STATISTICS
						       morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
						       Parameters                                  * param,
						       morpheo::behavioural::Tusage_t                usage );

  public  :          ~Reservation_station             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
  public  : void     transition                (void);
  public  : void     genMoore                  (void);
#endif					       

#ifdef STATISTICS
  public  : void     statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void     end_cycle                 (void);
#endif
  };

}; // end namespace reservation_station
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
