#ifdef SYSTEMC
/*
 * $Id: Read_queue_allocation.cpp 122 2009-06-03 08:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Read_queue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {


  void Read_queue::allocation (void)
  {
    log_printf(FUNC,Read_queue,"allocation","Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Read_queue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }
    // ~~~~~[ Interface : "read_queue_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("read_queue_in",IN,EAST,"Input of read_queue");

      ALLOC0_VALACK_IN ( in_READ_QUEUE_IN_VAL                  ,VAL);
      ALLOC0_VALACK_OUT(out_READ_QUEUE_IN_ACK                  ,ACK);
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_CONTEXT_ID           ,"context_id"           ,Tcontext_t        ,_param->_size_context_id      );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_FRONT_END_ID         ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id    );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_OOO_ENGINE_ID        ,"ooo_engine_id"        ,Tcontext_t        ,_param->_size_ooo_engine_id   );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_ROB_ID               ,"rob_id"               ,Tpacket_t         ,_param->_size_rob_ptr         );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_OPERATION            ,"operation"            ,Toperation_t      ,_param->_size_operation       );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_TYPE                 ,"type"                 ,Ttype_t           ,_param->_size_type            );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_STORE_QUEUE_PTR_WRITE,"store_queue_ptr_write",Tlsq_ptr_t        ,_param->_size_store_queue_ptr);
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_STORE_QUEUE_PTR_READ ,"store_queue_ptr_read" ,Tlsq_ptr_t        ,_param->_size_store_queue_ptr);
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_STORE_QUEUE_EMPTY    ,"store_queue_empty"    ,Tcontrol_t        ,1);
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_LOAD_QUEUE_PTR_WRITE ,"load_queue_ptr_write" ,Tlsq_ptr_t        ,_param->_size_load_queue_ptr);
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_HAS_IMMEDIAT         ,"has_immediat"         ,Tcontrol_t        ,1                             );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_IMMEDIAT             ,"immediat"             ,Tgeneral_data_t   ,_param->_size_general_data    );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_READ_RA              ,"read_ra"              ,Tcontrol_t        ,1                             );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_NUM_REG_RA           ,"num_reg_ra"           ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_READ_RB              ,"read_rb"              ,Tcontrol_t        ,1                             );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_NUM_REG_RB           ,"num_reg_rb"           ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_READ_RC              ,"read_rc"              ,Tcontrol_t        ,1                             );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_NUM_REG_RC           ,"num_reg_rc"           ,Tspecial_address_t,_param->_size_special_register);
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_WRITE_RD             ,"write_rd"             ,Tcontrol_t        ,1                             );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_NUM_REG_RD           ,"num_reg_rd"           ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_WRITE_RE             ,"write_re"             ,Tcontrol_t        ,1                             );
      ALLOC0_SIGNAL_IN ( in_READ_QUEUE_IN_NUM_REG_RE           ,"num_reg_re"           ,Tspecial_address_t,_param->_size_special_register);      
     
      ALLOC0_INTERFACE_END();
    }

    // ~~~~~[ Interface : "read_queue_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("read_queue_out",OUT,EAST,"Input of read_queue");
      
      ALLOC0_VALACK_OUT(out_READ_QUEUE_OUT_VAL                   ,VAL);
      ALLOC0_VALACK_IN ( in_READ_QUEUE_OUT_ACK                   ,ACK);
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_CONTEXT_ID            ,"context_id"           ,Tcontext_t        ,_param->_size_context_id       );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_FRONT_END_ID          ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id     );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_OOO_ENGINE_ID         ,"ooo_engine_id"        ,Tcontext_t        ,_param->_size_ooo_engine_id    );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_ROB_ID                ,"rob_id"               ,Tpacket_t         ,_param->_size_rob_ptr          );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_OPERATION             ,"operation"            ,Toperation_t      ,_param->_size_operation        );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_TYPE                  ,"type"                 ,Ttype_t           ,_param->_size_type             );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_STORE_QUEUE_PTR_WRITE ,"store_queue_ptr_write",Tlsq_ptr_t        , _param->_size_store_queue_ptr );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_STORE_QUEUE_PTR_READ  ,"store_queue_ptr_read" ,Tlsq_ptr_t        , _param->_size_store_queue_ptr );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_STORE_QUEUE_EMPTY     ,"store_queue_empty"    ,Tcontrol_t        ,1                              );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_LOAD_QUEUE_PTR_WRITE  ,"load_queue_ptr_write" ,Tlsq_ptr_t        , _param->_size_load_queue_ptr  );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_HAS_IMMEDIAT          ,"has_immediat"         ,Tcontrol_t        ,1                              );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_IMMEDIAT              ,"immediat"             ,Tgeneral_data_t   ,_param->_size_general_data     );
//    ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_READ_RA               ,"read_ra"              ,Tcontrol_t        ,1                              );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_NUM_REG_RA            ,"num_reg_ra"           ,Tgeneral_address_t,_param->_size_general_register );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_DATA_RA_VAL           ,"data_ra_val"          ,Tcontrol_t        ,1                              );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_DATA_RA               ,"data_ra"              ,Tgeneral_data_t   ,_param->_size_general_data     );
//    ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_READ_RB               ,"read_rb"              ,Tcontrol_t        ,1                              );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_NUM_REG_RB            ,"num_reg_rb"           ,Tgeneral_address_t,_param->_size_general_register );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_DATA_RB_VAL           ,"data_rb_val"          ,Tcontrol_t        ,1                              );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_DATA_RB               ,"data_rb"              ,Tgeneral_data_t   ,_param->_size_general_data     );
//    ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_READ_RC               ,"read_rc"              ,Tcontrol_t        ,1                              );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_NUM_REG_RC            ,"num_reg_rc"           ,Tspecial_address_t,_param->_size_special_register );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_DATA_RC_VAL           ,"data_rc_val"          ,Tcontrol_t        ,1                              );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_DATA_RC               ,"data_rc"              ,Tspecial_data_t   ,_param->_size_special_data     );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_WRITE_RD              ,"write_rd"             ,Tcontrol_t        ,1                              );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_NUM_REG_RD            ,"num_reg_rd"           ,Tgeneral_address_t,_param->_size_general_register );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_WRITE_RE              ,"write_re"             ,Tcontrol_t        ,1                              );
      ALLOC0_SIGNAL_OUT(out_READ_QUEUE_OUT_NUM_REG_RE            ,"num_reg_re"           ,Tspecial_address_t,_param->_size_special_register );      
     
      ALLOC0_INTERFACE_END();
    }

    // ~~~~~[ Interface : "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("gpr_read",IN,SOUTH,_("Interface with the General RegisterFile"),_param->_nb_gpr_read);

      ALLOC1_VALACK_OUT(out_GPR_READ_VAL           ,VAL);
      ALLOC1_VALACK_IN ( in_GPR_READ_ACK           ,ACK);
      ALLOC1_SIGNAL_OUT(out_GPR_READ_OOO_ENGINE_ID ,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_OUT(out_GPR_READ_NUM_REG       ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_IN ( in_GPR_READ_DATA          ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data);
      ALLOC1_SIGNAL_IN ( in_GPR_READ_DATA_VAL      ,"data_val"     ,Tcontrol_t        ,1);

      ALLOC1_INTERFACE_END(_param->_nb_gpr_read);
    }
    
    // ~~~~~[ Interface : "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("spr_read",IN,SOUTH,_("Interface with the General RegisterFile"),_param->_nb_spr_read);

      ALLOC1_VALACK_OUT(out_SPR_READ_VAL           ,VAL);
      ALLOC1_VALACK_IN ( in_SPR_READ_ACK           ,ACK);
      ALLOC1_SIGNAL_OUT(out_SPR_READ_OOO_ENGINE_ID ,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_OUT(out_SPR_READ_NUM_REG       ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_IN ( in_SPR_READ_DATA          ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data);
      ALLOC1_SIGNAL_IN ( in_SPR_READ_DATA_VAL      ,"data_val"     ,Tcontrol_t        ,1);

      ALLOC1_INTERFACE_END(_param->_nb_spr_read);
    }

    // ~~~~~[ Interface : "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("gpr_write",IN,SOUTH,_("Interface with write queue to bypass the write in the RegisterFile"),_param->_nb_gpr_write);

      ALLOC1_VALACK_IN (in_GPR_WRITE_VAL           ,VAL);
      ALLOC1_SIGNAL_IN (in_GPR_WRITE_OOO_ENGINE_ID ,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_IN (in_GPR_WRITE_NUM_REG       ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_IN (in_GPR_WRITE_DATA          ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data);
      
      ALLOC1_INTERFACE_END(_param->_nb_gpr_write);
    }

    // ~~~~~[ Interface : "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("spr_write",IN,SOUTH,_("Interface with write queue to bypass the write in the RegisterFile"),_param->_nb_spr_write);

      ALLOC1_VALACK_IN (in_SPR_WRITE_VAL           ,VAL);
      ALLOC1_SIGNAL_IN (in_SPR_WRITE_OOO_ENGINE_ID ,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_IN (in_SPR_WRITE_NUM_REG       ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_register);
      ALLOC1_SIGNAL_IN (in_SPR_WRITE_DATA          ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data);
      
      ALLOC1_INTERFACE_END(_param->_nb_spr_write);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    _queue      = new std::list<Tread_queue_entry_t *>;
    _queue_head = new Tread_queue_head_entry_t;

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Read_queue,"allocation","End");
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
