/*
 * $Id: Rename_unit_Glue.cpp 122 2009-06-03 08:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_unit_Glue/include/Rename_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_unit_glue {


#undef  FUNCTION
#define FUNCTION "Rename_unit_Glue::Rename_unit_Glue"
  Rename_unit_Glue::Rename_unit_Glue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_unit_glue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Rename_unit_Glue,FUNCTION);

    usage_environment(_usage);

#if DEBUG_Rename_unit_Glue == true
    log_printf(INFO,Rename_unit_Glue,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

    log_printf(INFO,Rename_unit_Glue,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Rename_unit_Glue,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Rename_unit_Glue,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Rename_unit_Glue,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

// 	log_printf(INFO,Rename_unit_Glue,FUNCTION,_("<%s> : Method - genMoore"),_name.c_str());

// 	SC_METHOD (genMoore);
// 	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information
// # endif    

	log_printf(INFO,Rename_unit_Glue,FUNCTION,_("<%s> : Method - genMealy_insert_valack"),_name.c_str());

	SC_METHOD (genMealy_insert_valack);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
	
	for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	  sensitive 
	  //<< (*(in_INSERT_ACK                          [i]))
	    << (*(in_INSERT_RENAME_SELECT_VAL            [i]))
	    << (*(in_INSERT_RENAME_SELECT_NO_EXECUTE     [i]))
	    << (*(in_INSERT_REGISTER_TRANSLATION_ACK     [i]))
	    << (*(in_INSERT_LOAD_STORE_QUEUE_POINTER_ACK [i]))
	    ;

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Rename_unit_Glue,FUNCTION,_("<%s> : Method - genMealy_retire_valack"),_name.c_str());

	SC_METHOD (genMealy_retire_valack);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
	for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	  sensitive 
	    << (*(in_RETIRE_VAL                          [i]))
	    << (*(in_RETIRE_LOAD_STORE_QUEUE_POINTER_ACK [i]))
	    << (*(in_RETIRE_REGISTER_TRANSLATION_ACK     [i]))
	    ;

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Rename_unit_Glue,FUNCTION,_("<%s> : Method - genMealy_retire_event_valack"),_name.c_str());

	SC_METHOD (genMealy_retire_event_valack);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
	for (uint32_t i=0; i<_param->_nb_front_end; i++)
	  for (uint32_t j=0; j<_param->_nb_context[i]; j++)
            sensitive 
              << (*(in_RETIRE_EVENT_VAL                          [i][j]))
              << (*(in_RETIRE_EVENT_LOAD_STORE_QUEUE_POINTER_ACK [i][j]))
              << (*(in_RETIRE_EVENT_REGISTER_TRANSLATION_ACK     [i][j]))
              ;

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Rename_unit_Glue,FUNCTION,_("<%s> : Method - genMealy_insert"),_name.c_str());

	SC_METHOD (genMealy_insert);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
	for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	  {
	    if (_param->_have_port_front_end_id)
	    sensitive << (*(in_INSERT_RENAME_SELECT_FRONT_END_ID              [i]));
	    if (_param->_have_port_context_id)
	    sensitive << (*(in_INSERT_RENAME_SELECT_CONTEXT_ID                [i]));
	    sensitive << (*(in_INSERT_RENAME_SELECT_TYPE                      [i]))
		      << (*(in_INSERT_RENAME_SELECT_OPERATION                 [i]))
		      << (*(in_INSERT_RENAME_SELECT_IMMEDIAT                  [i]))
// 		      << (*(in_INSERT_RENAME_SELECT_EXCEPTION_USE             [i]))
		      << (*(in_INSERT_RENAME_SELECT_EXCEPTION                 [i]))
		      << (*(in_INSERT_REGISTER_TRANSLATION_NUM_REG_RE_PHY_NEW [i]));

	  }
	for (uint32_t i=0; i<_param->_nb_front_end; i++)
	  for (uint32_t j=0; j<_param->_nb_context[i]; j++)
	    sensitive << (*(in_SPR_READ_SR [i][j]));
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_end(Rename_unit_Glue,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Rename_unit_Glue::~Rename_unit_Glue"
  Rename_unit_Glue::~Rename_unit_Glue (void)
  {
    log_begin(Rename_unit_Glue,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Rename_unit_Glue,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Rename_unit_Glue,FUNCTION);
  };

}; // end namespace rename_unit_glue
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
