/*
 * $Id: Icache_Access.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Icache_Access/include/Icache_Access.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace icache_access {


#undef  FUNCTION
#define FUNCTION "Icache_Access::Icache_Access"
  Icache_Access::Icache_Access 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::icache_access::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Icache_Access,FUNCTION);

    usage_environment(_usage);

// #if DEBUG_Core == true
//     log_printf(INFO,Core,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Icache_Access,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Icache_Access,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Icache_Access,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Icache_Access,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

// 	log_printf(INFO,Icache_Access,FUNCTION,_("<%s> : Method - genMoore"),_name.c_str());

// 	SC_METHOD (genMoore);
// 	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information
// # endif    

	log_printf(INFO,Icache_Access,FUNCTION,_("<%s> : Method - genMealy_req"),_name.c_str());

	SC_METHOD (genMealy_req);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register

	for (uint32_t i=0; i<_param->_nb_icache_port; ++i)
	  sensitive << (*(in_ICACHE_REQ_ACK [i]));
	for (uint32_t i=0; i<_param->_nb_front_end; ++i)
	  for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
	    {
	      sensitive << (*(in_CONTEXT_REQ_VAL        [i][j]))
			<< (*(in_CONTEXT_REQ_ADDRESS    [i][j]))
			<< (*(in_CONTEXT_REQ_TYPE       [i][j]));
	      if (_param->_have_port_packet_id [i][j])
	      sensitive << (*(in_CONTEXT_REQ_PACKET_ID  [i][j]));
	    }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information

	for (uint32_t i=0; i<_param->_nb_icache_port; ++i)
	  {
	    for (uint32_t x=0; x<_param->_nb_icache_port; ++x)
	      {
		(*(out_ICACHE_REQ_VAL       [i])) (*(in_ICACHE_REQ_ACK [x]));
		if (_param->_have_port_icache_thread_id)
		(*(out_ICACHE_REQ_THREAD_ID [i])) (*(in_ICACHE_REQ_ACK [x]));
		if (_param->_have_port_icache_packet_id)
		(*(out_ICACHE_REQ_PACKET_ID [i])) (*(in_ICACHE_REQ_ACK [x]));
		(*(out_ICACHE_REQ_ADDRESS   [i])) (*(in_ICACHE_REQ_ACK [x]));
		(*(out_ICACHE_REQ_TYPE      [i])) (*(in_ICACHE_REQ_ACK [x]));
	      }
	    for (uint32_t x=0; x<_param->_nb_front_end; ++x)
	      for (uint32_t y=0; y<_param->_nb_context[x]; ++y)
		{
		  (*(out_ICACHE_REQ_VAL       [i])) (*(in_CONTEXT_REQ_VAL        [x][y]));
		  if (_param->_have_port_packet_id [x][y])
		  (*(out_ICACHE_REQ_PACKET_ID [i])) (*(in_CONTEXT_REQ_PACKET_ID  [x][y]));
		  (*(out_ICACHE_REQ_ADDRESS   [i])) (*(in_CONTEXT_REQ_ADDRESS    [x][y]));
		  (*(out_ICACHE_REQ_TYPE      [i])) (*(in_CONTEXT_REQ_TYPE       [x][y]));
		}
	  }

	for (uint32_t i=0; i<_param->_nb_front_end; ++i)
	  for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
	    {
	      for (uint32_t x=0; x<_param->_nb_front_end; ++x)
		for (uint32_t y=0; y<_param->_nb_context[x]; ++y)
		  (*(out_CONTEXT_REQ_ACK [i][j])) (*(in_CONTEXT_REQ_VAL        [x][y]));

	      for (uint32_t x=0; x<_param->_nb_icache_port; ++x)
		(*(out_CONTEXT_REQ_ACK [i][j])) (*(in_ICACHE_REQ_ACK [x]));
	    }
# endif    

	log_printf(INFO,Icache_Access,FUNCTION,_("<%s> : Method - genMealy_rsp"),_name.c_str());

	SC_METHOD (genMealy_rsp);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
	for (uint32_t i=0; i<_param->_nb_icache_port; ++i)
	  {
	    sensitive << (*(in_ICACHE_RSP_VAL         [i]))
		      << (*(in_ICACHE_RSP_ERROR       [i]));
	    if (_param->_have_port_icache_thread_id)
	    sensitive << (*(in_ICACHE_RSP_THREAD_ID   [i]));
	    if (_param->_have_port_icache_packet_id)
	    sensitive << (*(in_ICACHE_RSP_PACKET_ID   [i]));

	    for (uint32_t j=0; j<_param->_icache_nb_instruction[i]; ++j)
	      sensitive << (*(in_ICACHE_RSP_INSTRUCTION [i][j]));
	  }
	
	for (uint32_t i=0; i<_param->_nb_front_end; ++i)
	  for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
	    sensitive << (*(in_CONTEXT_RSP_ACK [i][j]));


	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information

	for (uint32_t i=0; i<_param->_nb_icache_port; ++i)
	  {
	    if (_param->_have_port_icache_thread_id)
	    (*(out_ICACHE_RSP_ACK [i])) (*(in_ICACHE_RSP_THREAD_ID   [i]));

	    for (uint32_t x=0; x<_param->_nb_front_end; ++x)
	      for (uint32_t y=0; y<_param->_nb_context[x]; ++y)
		(*(out_ICACHE_RSP_ACK [i])) (*(in_CONTEXT_RSP_ACK [x][y]));
	  }

	for (uint32_t i=0; i<_param->_nb_front_end; ++i)
	  for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
	    for (uint32_t x=0; x<_param->_nb_icache_port; ++x)
	      {
		if (_param->_have_port_icache_thread_id)
		  {
		    (*(out_CONTEXT_RSP_VAL         [i][j]))    (*(in_ICACHE_RSP_THREAD_ID   [x]));
		    if (_param->_have_port_packet_id [i][j])
		    (*(out_CONTEXT_RSP_PACKET_ID   [i][j]))    (*(in_ICACHE_RSP_THREAD_ID   [x]));
		    (*(out_CONTEXT_RSP_ERROR       [i][j]))    (*(in_ICACHE_RSP_THREAD_ID   [x]));
		    for (uint32_t k=0; k<_param->_nb_instruction [i][j]; ++k)
		    (*(out_CONTEXT_RSP_INSTRUCTION [i][j][k])) (*(in_ICACHE_RSP_THREAD_ID   [x]));
		  }

		(*(out_CONTEXT_RSP_VAL         [i][j]))    (*(in_ICACHE_RSP_VAL         [x]));
		if (_param->_have_port_packet_id [i][j])
		(*(out_CONTEXT_RSP_PACKET_ID   [i][j]))    (*(in_ICACHE_RSP_PACKET_ID   [x]));
		(*(out_CONTEXT_RSP_ERROR       [i][j]))    (*(in_ICACHE_RSP_ERROR       [x]));
		for (uint32_t k=0; k<_param->_nb_instruction [i][j]; ++k)
                  for (uint32_t y=0; y<_param->_icache_nb_instruction[x]; ++y)
                    (*(out_CONTEXT_RSP_INSTRUCTION [i][j][k])) (*(in_ICACHE_RSP_INSTRUCTION [x][y]));
	      }
# endif
	
#endif
      }
    log_end(Icache_Access,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Icache_Access::~Icache_Access"
  Icache_Access::~Icache_Access (void)
  {
    log_begin(Icache_Access,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Icache_Access,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Icache_Access,FUNCTION);
  };

}; // end namespace icache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
