#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id: Register_unit_Glue_genMealy_gpr_registerfile.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/Register_unit_Glue/include/Register_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {
namespace register_unit_glue {


#undef  FUNCTION
#define FUNCTION "Register_unit_Glue::genMealy_gpr_write"
  void Register_unit_Glue::genMealy_gpr_write_registerfile (void)
  {
    log_begin(Register_unit_Glue,FUNCTION);
    log_function(Register_unit_Glue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
	for (uint32_t j=0; j<_param->_nb_gpr_write; j++)
	  {
	    Tcontext_t ooo_engine_id    = (_param->_have_port_ooo_engine_id == true)?PORT_READ(in_GPR_WRITE_OOO_ENGINE_ID[j]):0;
	    Tcontrol_t val              = PORT_READ(in_GPR_WRITE_VAL [j]);
	    Tcontrol_t status_ack       = PORT_READ(in_GPR_WRITE_STATUS_ACK       [ooo_engine_id][j]);
	    Tcontrol_t registerfile_val = val and status_ack;
	    
	    for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	      {
		Tcontrol_t id = (i == ooo_engine_id)?1:0;
		PORT_WRITE(out_GPR_WRITE_REGISTERFILE_VAL [i][j], (id and registerfile_val));
	      }
	  }
      }
    else
      {
	for (uint32_t j=0; j<_param->_nb_gpr_write; j++)
	  for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	    PORT_WRITE(out_GPR_WRITE_REGISTERFILE_VAL [i][j], 0);
      }

    log_end(Register_unit_Glue,FUNCTION);
  };

}; // end namespace register_unit_glue
}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//#endif
