#ifndef morpheo_behavioural_core_multi_front_end_front_end_decod_unit_Decod_unit_h
#define morpheo_behavioural_core_multi_front_end_front_end_decod_unit_Decod_unit_h

/*
 * $Id: Decod_unit.h 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Decod.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Decod_queue.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/include/Parameters.h"
#include "Behavioural/include/Types.h"

#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {


  class Decod_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "ifetch_unit" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         ) ***  in_IFETCH_VAL                         ;//[nb_context][nb_inst_fetch]
  public    : SC_OUT(Tcontrol_t         ) *** out_IFETCH_ACK                         ;//[nb_context][nb_inst_fetch]
  public    : SC_IN (Tinstruction_t     ) ***  in_IFETCH_INSTRUCTION                 ;//[nb_context][nb_inst_fetch]
  public    : SC_IN (Tcontext_t         )  **  in_IFETCH_CONTEXT_ID                  ;//[nb_context]
  public    : SC_IN (Tgeneral_address_t )  **  in_IFETCH_ADDRESS                     ;//[nb_context]
//public    : SC_IN (Tgeneral_address_t )  **  in_IFETCH_ADDRESS_NEXT                ;//[nb_context]
  public    : SC_IN (Tinst_ifetch_ptr_t )  **  in_IFETCH_INST_IFETCH_PTR             ;//[nb_context]
  public    : SC_IN (Tbranch_state_t    )  **  in_IFETCH_BRANCH_STATE                ;//[nb_context]
  public    : SC_IN (Tprediction_ptr_t  )  **  in_IFETCH_BRANCH_UPDATE_PREDICTION_ID ;//[nb_context]
  public    : SC_IN (Texception_t       )  **  in_IFETCH_EXCEPTION                   ;//[nb_context]
										     
    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	     
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_VAL                          ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_ACK                          ;//[nb_inst_decod]
  public    : SC_OUT(Tcontext_t         )  ** out_DECOD_CONTEXT_ID                   ;//[nb_inst_decod]
  public    : SC_OUT(Tdepth_t           )  ** out_DECOD_DEPTH                        ;//[nb_inst_decod]
  public    : SC_OUT(Ttype_t            )  ** out_DECOD_TYPE                         ;//[nb_inst_decod]
  public    : SC_OUT(Toperation_t       )  ** out_DECOD_OPERATION                    ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_NO_EXECUTE                   ;//[nb_inst_decod]
//public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_HAVE_EVENT                   ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_LAST_EVENT                   ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_IS_DELAY_SLOT                ;//[nb_inst_decod]
#ifdef DEBUG
  public    : SC_OUT(Tgeneral_data_t    )  ** out_DECOD_ADDRESS                      ;//[nb_inst_decod]
#endif
  public    : SC_OUT(Tgeneral_data_t    )  ** out_DECOD_ADDRESS_NEXT                 ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_HAS_IMMEDIAT                 ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_DECOD_IMMEDIAT                     ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_READ_RA                      ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_address_t )  ** out_DECOD_NUM_REG_RA                   ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_READ_RB                      ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_address_t )  ** out_DECOD_NUM_REG_RB                   ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_READ_RC                      ;//[nb_inst_decod]
  public    : SC_OUT(Tspecial_address_t )  ** out_DECOD_NUM_REG_RC                   ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_WRITE_RD                     ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_address_t )  ** out_DECOD_NUM_REG_RD                   ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_WRITE_RE                     ;//[nb_inst_decod]
  public    : SC_OUT(Tspecial_address_t )  ** out_DECOD_NUM_REG_RE                   ;//[nb_inst_decod]
  public    : SC_OUT(Texception_t       )  ** out_DECOD_EXCEPTION_USE                ;//[nb_inst_decod]
  public    : SC_OUT(Texception_t       )  ** out_DECOD_EXCEPTION                    ;//[nb_inst_decod]

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_VAL                        ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_ACK                        ;//[nb_inst_decod]
  public    : SC_OUT(Tcontext_t         )  ** out_PREDICT_CONTEXT_ID                 ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_MATCH_INST_IFETCH_PTR      ;//[nb_inst_decod]
  public    : SC_OUT(Tbranch_state_t    )  ** out_PREDICT_BRANCH_STATE               ;//[nb_inst_decod]
  public    : SC_OUT(Tprediction_ptr_t  )  ** out_PREDICT_BRANCH_UPDATE_PREDICTION_ID;//[nb_inst_decod]
  public    : SC_OUT(Tbranch_condition_t)  ** out_PREDICT_BRANCH_CONDITION           ;//[nb_inst_decod]
//public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_BRANCH_STACK_WRITE         ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_BRANCH_DIRECTION           ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_PREDICT_ADDRESS_SRC                ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_PREDICT_ADDRESS_DEST               ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_CAN_CONTINUE               ;//[nb_inst_decod]

    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tdepth_t           )  **  in_DEPTH_MIN                          ;//[nb_context]
  public    : SC_IN (Tdepth_t           )  **  in_DEPTH_MAX                          ;//[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_DEPTH_FULL                         ;//[nb_context]

    // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcounter_t         )  ** out_NB_INST_DECOD_ALL                  ;//[nb_context]

    // ~~~~~[ Interface : "context" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_CONTEXT_DECOD_ENABLE               ;//[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_CONTEXT_EVENT                      ;//[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_CONTEXT_DEPTH_VAL                  ;//[nb_context]
  public    : SC_IN (Tdepth_t           )  **  in_CONTEXT_DEPTH                      ;//[nb_context]
										     
    // ~~~~~[ Interface : "context_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	     
  public    : SC_OUT(Tcontrol_t         )   * out_CONTEXT_EVENT_VAL                  ;
  public    : SC_IN (Tcontrol_t         )   *  in_CONTEXT_EVENT_ACK                  ;
  public    : SC_OUT(Tcontext_t         )   * out_CONTEXT_EVENT_CONTEXT_ID           ;
  public    : SC_OUT(Tdepth_t           )   * out_CONTEXT_EVENT_DEPTH                ;
  public    : SC_OUT(Tevent_type_t      )   * out_CONTEXT_EVENT_TYPE                 ;
  public    : SC_OUT(Tcontrol_t         )   * out_CONTEXT_EVENT_IS_DELAY_SLOT        ;
  public    : SC_OUT(Tgeneral_data_t    )   * out_CONTEXT_EVENT_ADDRESS              ;
  public    : SC_OUT(Tgeneral_data_t    )   * out_CONTEXT_EVENT_ADDRESS_EPCR         ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  public : morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod      ::Decod       * _component_decod;
  public : morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Decod_queue * _component_decod_queue;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Decod_unit);
#endif
  public  :          Decod_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Decod_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif					       
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
