#ifdef SYSTEMC
/*
 * $Id: Branch_Target_Buffer_Glue_genMealy_decod.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Glue/include/Branch_Target_Buffer_Glue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_glue {

#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Glue::genMealy_decod"
  void Branch_Target_Buffer_Glue::genMealy_decod (void)
  {
    log_begin(Branch_Target_Buffer_Glue,FUNCTION);
    log_function(Branch_Target_Buffer_Glue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
      {
        log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"  * DECOD [%d]",i);
	Tcontrol_t val          = PORT_READ(in_DECOD_VAL          [i]);
	Tcontrol_t register_ack = PORT_READ(in_DECOD_REGISTER_ACK [i]);
	Tcontrol_t victim_ack   = (_param->_have_port_victim)?PORT_READ(in_DECOD_VICTIM_ACK [i]):true;
	
        log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"    * val          : %d", val         );
        log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"    * register_ack : %d", register_ack);
        log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"    * victim_ack   : %d", victim_ack  );

	PORT_WRITE(out_DECOD_ACK            [i], (
//                                                val          and
                                                  register_ack and 
                                                  victim_ack
                                                  ));
        PORT_WRITE(out_DECOD_REGISTER_VAL   [i], (
                                                  val          and
//                                                register_ack and 
                                                  victim_ack
                                                  ));
	if (_param->_have_port_victim)
	  {
	PORT_WRITE(out_DECOD_VICTIM_VAL     [i], (
                                                  val          and
                                                  register_ack // and 
//                                                victim_ack
                                                  ));
	if (not _param->_is_full_associative)
          {
            Tgeneral_data_t address_src = PORT_READ(in_DECOD_ADDRESS_SRC [i]);
            log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"    * address_src  : %.8x", address_src);
            
            PORT_WRITE(out_DECOD_VICTIM_ADDRESS [i], (address_src >> _param->_shift_bank)&_param->_mask_bank);
          }
	  }
      }
      }
    else
      {
        for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
          {
            PORT_WRITE(out_DECOD_ACK            [i], 0);
            PORT_WRITE(out_DECOD_REGISTER_VAL   [i], 0);
            if (_param->_have_port_victim)
            PORT_WRITE(out_DECOD_VICTIM_VAL     [i], 0);
          }
      }

    log_end(Branch_Target_Buffer_Glue,FUNCTION);
  };

}; // end namespace branch_target_buffer_glue
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
