/*
 * $Id: Register_Address_Translation_unit.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/include/Register_Address_Translation_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_address_translation_unit {


#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::Register_Address_Translation_unit"
  Register_Address_Translation_unit::Register_Address_Translation_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"Begin");

// #if DEBUG_Register_Address_Translation_unit == true
//     log_printf(INFO,Register_Address_Translation_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	// Constant : accepted already transaction
	for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	  {
	    internal_RENAME_ACK [i] = 1;
	    internal_INSERT_ACK [i] = 1;

	    PORT_WRITE(out_RENAME_ACK[i],internal_RENAME_ACK [i]);
	    PORT_WRITE(out_INSERT_ACK[i],internal_INSERT_ACK [i]);
	  }

	for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	  {
	    internal_RETIRE_ACK [i] = 1;

	    PORT_WRITE(out_RETIRE_ACK[i],internal_RETIRE_ACK [i]);
	  }

        for (uint32_t i=0; i<_param->_nb_front_end; ++i)
          for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
            {
              internal_RETIRE_EVENT_ACK [i][j] = 1;
              
              PORT_WRITE(out_RETIRE_EVENT_ACK[i][j],internal_RETIRE_EVENT_ACK [i][j]);
            }

	log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Method - genMealy_rename");

	SC_METHOD (genMealy_rename);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
        for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
          {
            if (_param->_have_port_front_end_id) 
            sensitive << (*(in_RENAME_FRONT_END_ID   [i]));
            if (_param->_have_port_context_id  )
            sensitive << (*(in_RENAME_CONTEXT_ID     [i]));
            
            sensitive << (*(in_RENAME_VAL            [i])) // Not necessary
                      << (*(in_RENAME_NUM_REG_RA_LOG [i]))
                      << (*(in_RENAME_NUM_REG_RB_LOG [i]))
                      << (*(in_RENAME_NUM_REG_RC_LOG [i]))
                      << (*(in_RENAME_NUM_REG_RD_LOG [i]))
                      << (*(in_RENAME_NUM_REG_RE_LOG [i]));
          }
        for (uint32_t i=0; i<_param->_nb_front_end; ++i)
          for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
            sensitive << (*(in_RETIRE_EVENT_VAL   [i][j]))
                      << (*(in_RETIRE_EVENT_STATE [i][j]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Method - genMealy_retire");

	SC_METHOD (genMealy_retire);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
        for (uint32_t i=0; i<_param->_nb_inst_retire; ++i)
          {
            if (param->_have_port_front_end_id)
            sensitive << (*(in_RETIRE_FRONT_END_ID   [i]));
            if (param->_have_port_context_id)
            sensitive << (*(in_RETIRE_CONTEXT_ID     [i]));
            
            sensitive << (*(in_RETIRE_WRITE_RD       [i]))
                      << (*(in_RETIRE_WRITE_RE       [i]))
                      << (*(in_RETIRE_NUM_REG_RD_LOG [i]))
                      << (*(in_RETIRE_NUM_REG_RE_LOG [i]));
          }

        for (uint32_t i=0; i<_param->_nb_front_end; ++i)
          for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
            sensitive << (*(in_RETIRE_EVENT_VAL   [i][j]))
                      << (*(in_RETIRE_EVENT_STATE [i][j]));
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::~Register_Address_Translation_unit"
  Register_Address_Translation_unit::~Register_Address_Translation_unit (void)
  {
    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"End");
  };

}; // end namespace register_address_translation_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
