#ifdef SYSTEMC
/*
 * $Id: Victim_Pseudo_LRU_transition.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {

  void Victim_Pseudo_LRU::transition (void)
  {
    for (uint32_t i=0; i<_param->_nb_access; i++)
      {
	if (PORT_READ (in_ACCESS_VAL[i]) and internal_ACCESS_ACK)
	  {
	    Taddress_t address = (_param->_size_table>1)?PORT_READ(in_ACCESS_ADDRESS[i]):0;
	    Tentity_t  entity  = 0;

	    if (PORT_READ(in_ACCESS_HIT [i]))
	      {
		// Hit  : don't need a victim
// #ifdef STATISTICS
// 		_stat_nb_update ++;
// #endif
		entity = PORT_READ(in_ACCESS_ENTITY[i]);
	      }
	    else
	      {
		// Miss : need victim
// #ifdef STATISTICS
// 		_stat_nb_access ++;
// #endif
		entity = internal_ACCESS_VICTIM[i];
	      }

	    reg_TABLE[address]->update(entity);
	  }
      }//end for i
    
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
