/*
 * $Id: Branch_Target_Buffer_Glue.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Glue/include/Branch_Target_Buffer_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_glue {


#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Glue::Branch_Target_Buffer_Glue"
  Branch_Target_Buffer_Glue::Branch_Target_Buffer_Glue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::branch_target_buffer_glue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"Begin");

// #if DEBUG_Branch_Target_Buffer_Glue == true
//     log_printf(INFO,Branch_Target_Buffer_Glue,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Branch_Target_Buffer_Glue,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Branch_Target_Buffer_Glue,FUNCTION,"Allocation of statistics");

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Branch_Target_Buffer_Glue,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
	log_printf(INFO,Branch_Target_Buffer_Glue,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();

#  ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
#  endif
# endif

	log_printf(INFO,Branch_Target_Buffer_Glue,FUNCTION,"Method - genMealy_predict");

	SC_METHOD (genMealy_predict);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't use internal register

	for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	  {
	    sensitive << (*(in_PREDICT_VAL                   [i]))
		      << (*(in_PREDICT_REGISTER_ACK          [i]));
	    if (_param->_have_port_victim)
	      sensitive << (*(in_PREDICT_SORT_VAL              [i]))
			<< (*(in_PREDICT_SORT_INDEX            [i]))
			<< (*(in_PREDICT_VICTIM_ACK            [i]));
	    for (uint32_t j=0; j<_param->_associativity; j++)
	      sensitive << (*(in_PREDICT_REGISTER_HIT          [i][j]))
			<< (*(in_PREDICT_REGISTER_ADDRESS_SRC  [i][j]))
			<< (*(in_PREDICT_REGISTER_ADDRESS_DEST [i][j]))
			<< (*(in_PREDICT_REGISTER_CONDITION    [i][j]))
			<< (*(in_PREDICT_REGISTER_LAST_TAKE    [i][j]))
			<< (*(in_PREDICT_REGISTER_IS_ACCURATE  [i][j]));
	  }
	
// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information

// 	for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
// 	  {
// 	    for (uint32_t j=0; j<_param->_associativity; j++)
// 	    (*(out_PREDICT_HIT            [i])) (*(in_PREDICT_REGISTER_HIT          [i][j]));
// 	    if (_param->_have_port_victim)
// 	    (*(out_PREDICT_HIT            [i])) (*(in_PREDICT_SORT_INDEX            [i]));

// 	    for (uint32_t j=0; j<_param->_associativity; j++)
// 	    (*(out_PREDICT_ADDRESS_SRC    [i])) (*(in_PREDICT_REGISTER_ADDRESS_SRC  [i][j]));
// 	    if (_param->_have_port_victim)
// 	    (*(out_PREDICT_ADDRESS_SRC    [i])) (*(in_PREDICT_SORT_INDEX            [i]));

// 	    for (uint32_t j=0; j<_param->_associativity; j++)
// 	    (*(out_PREDICT_ADDRESS_DEST   [i])) (*(in_PREDICT_REGISTER_ADDRESS_DEST [i][j]));
// 	    if (_param->_have_port_victim)
// 	    (*(out_PREDICT_ADDRESS_DEST   [i])) (*(in_PREDICT_SORT_INDEX            [i]));

// 	    for (uint32_t j=0; j<_param->_associativity; j++)
// 	    (*(out_PREDICT_CONDITION      [i])) (*(in_PREDICT_REGISTER_CONDITION    [i][j]));
// 	    if (_param->_have_port_victim)
// 	    (*(out_PREDICT_CONDITION      [i])) (*(in_PREDICT_SORT_INDEX            [i]));

// 	    for (uint32_t j=0; j<_param->_associativity; j++)
// 	    (*(out_PREDICT_LAST_TAKE      [i])) (*(in_PREDICT_REGISTER_LAST_TAKE    [i][j]));
// 	    if (_param->_have_port_victim)
// 	    (*(out_PREDICT_LAST_TAKE      [i])) (*(in_PREDICT_SORT_INDEX            [i]));

// 	    for (uint32_t j=0; j<_param->_associativity; j++)
// 	    (*(out_PREDICT_IS_ACCURATE    [i])) (*(in_PREDICT_REGISTER_IS_ACCURATE  [i][j]));
// 	    if (_param->_have_port_victim)
// 	    (*(out_PREDICT_IS_ACCURATE    [i])) (*(in_PREDICT_SORT_INDEX            [i]));


// 	    (*(out_PREDICT_ACK            [i])) (*(in_PREDICT_REGISTER_ACK          [i]));
// 	    if (_param->_have_port_victim)
// 	      {
// 	    (*(out_PREDICT_ACK            [i])) (*(in_PREDICT_SORT_VAL              [i]));
// 	    (*(out_PREDICT_ACK            [i])) (*(in_PREDICT_VICTIM_ACK            [i]));
// 	      }

// 	    (*(out_PREDICT_REGISTER_VAL   [i])) (*(in_PREDICT_VAL                   [i]));
// 	    if (_param->_have_port_victim)
// 	      {
// 	    (*(out_PREDICT_REGISTER_VAL   [i])) (*(in_PREDICT_SORT_VAL              [i]));
// 	    (*(out_PREDICT_REGISTER_VAL   [i])) (*(in_PREDICT_VICTIM_ACK            [i]));
// 	      }

// 	    if (_param->_have_port_victim)
// 	      {
// 	    (*(out_PREDICT_VICTIM_VAL     [i])) (*(in_PREDICT_VAL                   [i]));
// 	    (*(out_PREDICT_VICTIM_VAL     [i])) (*(in_PREDICT_REGISTER_ACK          [i]));
// 	    (*(out_PREDICT_VICTIM_VAL     [i])) (*(in_PREDICT_SORT_VAL              [i]));

// 	    for (uint32_t j=0; j<_param->_associativity; j++)
// 	    (*(out_PREDICT_VICTIM_HIT     [i])) (*(in_PREDICT_REGISTER_HIT          [i][j]));
// 	    (*(out_PREDICT_VICTIM_HIT     [i])) (*(in_PREDICT_SORT_INDEX            [i]));

// 	    if (not _param->_is_full_associative)
// 	      {
// 	    for (uint32_t j=0; j<_param->_associativity; j++)
// 	    (*(out_PREDICT_VICTIM_ADDRESS [i])) (*(in_PREDICT_REGISTER_ADDRESS_SRC  [i][j]));
// 	    (*(out_PREDICT_VICTIM_ADDRESS [i])) (*(in_PREDICT_SORT_INDEX            [i]));
// 	      }
// 	    (*(out_PREDICT_VICTIM_INDEX   [i])) (*(in_PREDICT_SORT_INDEX            [i]));
// 	      }
// 	  }
// # endif

	log_printf(INFO,Branch_Target_Buffer_Glue,FUNCTION,"Method - genMealy_decod");

	SC_METHOD (genMealy_decod);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't use internal register

	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {
	    sensitive << (*(in_DECOD_VAL                   [i]))
		      << (*(in_DECOD_REGISTER_ACK          [i]));
	    if (_param->_have_port_victim)
	      {
		if (not _param->_is_full_associative)
		  sensitive << (*(in_DECOD_ADDRESS_SRC           [i]));
		sensitive << (*(in_DECOD_VICTIM_ACK            [i]));
	      }
	  }
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information

	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {
	    (*(out_DECOD_ACK            [i])) (*(in_DECOD_REGISTER_ACK          [i]));
	    if (_param->_have_port_victim)
	    (*(out_DECOD_ACK            [i])) (*(in_DECOD_VICTIM_ACK            [i]));

	    (*(out_DECOD_REGISTER_VAL   [i])) (*(in_DECOD_VAL                   [i]));
	    if (_param->_have_port_victim)
	    (*(out_DECOD_REGISTER_VAL   [i])) (*(in_DECOD_VICTIM_ACK            [i]));

	    if (_param->_have_port_victim)
	      {
	    (*(out_DECOD_VICTIM_VAL     [i])) (*(in_DECOD_VAL                   [i]));
	    (*(out_DECOD_VICTIM_VAL     [i])) (*(in_DECOD_REGISTER_ACK          [i]));

	    if (not _param->_is_full_associative)
	    (*(out_DECOD_VICTIM_ADDRESS [i])) (*(in_DECOD_ADDRESS_SRC           [i]));
	      }
	  }
# endif

	log_printf(INFO,Branch_Target_Buffer_Glue,FUNCTION,"Method - genMealy_update");

	SC_METHOD (genMealy_update);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't use internal register

	for (uint32_t i=0; i<_param->_nb_inst_update; i++)
	  {
	    sensitive << (*(in_UPDATE_VAL                   [i]))
		      << (*(in_UPDATE_REGISTER_ACK          [i]));
	    if (_param->_have_port_victim)
	      {
		if (not _param->_is_full_associative)
		  sensitive << (*(in_UPDATE_ADDRESS_SRC           [i]));
		sensitive << (*(in_UPDATE_VICTIM_ACK            [i]));
	      }
	  }
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information

	for (uint32_t i=0; i<_param->_nb_inst_update; i++)
	  {
	    (*(out_UPDATE_ACK            [i])) (*(in_UPDATE_REGISTER_ACK          [i]));
	    if (_param->_have_port_victim)
	    (*(out_UPDATE_ACK            [i])) (*(in_UPDATE_VICTIM_ACK            [i]));

	    (*(out_UPDATE_REGISTER_VAL   [i])) (*(in_UPDATE_VAL                   [i]));
	    if (_param->_have_port_victim)
	    (*(out_UPDATE_REGISTER_VAL   [i])) (*(in_UPDATE_VICTIM_ACK            [i]));

	    if (_param->_have_port_victim)
	      {
	    (*(out_UPDATE_VICTIM_VAL     [i])) (*(in_UPDATE_VAL                   [i]));
	    (*(out_UPDATE_VICTIM_VAL     [i])) (*(in_UPDATE_REGISTER_ACK          [i]));

	    if (not _param->_is_full_associative)
	    (*(out_UPDATE_VICTIM_ADDRESS [i])) (*(in_UPDATE_ADDRESS_SRC           [i]));
	      }
	  }
# endif

#endif
      }
    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Glue::~Branch_Target_Buffer_Glue"
  Branch_Target_Buffer_Glue::~Branch_Target_Buffer_Glue (void)
  {
    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Branch_Target_Buffer_Glue,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"End");
  };

}; // end namespace branch_target_buffer_glue
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
