/*
 * $Id: Rename_unit_allocation.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/include/Rename_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {



#undef  FUNCTION
#define FUNCTION "Rename_unit::allocation"
  void Rename_unit::allocation 
  (
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
   void
#endif
   )
  {
    log_begin(Rename_unit,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Rename_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();
    
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "rename_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("rename_in", IN, EAST, _("output of decod's stage"), _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      
      _ALLOC2_VALACK_IN ( in_RENAME_IN_VAL           ,VAL, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_VALACK_OUT(out_RENAME_IN_ACK           ,ACK, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_FRONT_END_ID  ,"front_end_id" ,Tcontext_t        ,_param->_size_front_end_id          , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_CONTEXT_ID    ,"context_id"   ,Tcontext_t        ,_param->_size_context_id            , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_DEPTH         ,"depth"        ,Tdepth_t          ,_param->_size_depth                 , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_TYPE          ,"type"         ,Ttype_t           ,_param->_size_type                  , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_OPERATION     ,"operation"    ,Toperation_t      ,_param->_size_operation             , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_NO_EXECUTE    ,"no_execute"   ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
//    _ALLOC2_SIGNAL_IN ( in_RENAME_IN_HAVE_EVENT    ,"have_event"   ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_LAST_EVENT    ,"last_event"   ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_IS_DELAY_SLOT ,"is_delay_slot",Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
#ifdef DEBUG
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_ADDRESS       ,"address"      ,Taddress_t        ,_param->_size_instruction_address   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
#endif
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_ADDRESS_NEXT  ,"address_next" ,Taddress_t        ,_param->_size_instruction_address   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_HAS_IMMEDIAT  ,"has_immediat" ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_IMMEDIAT      ,"immediat"     ,Tgeneral_data_t   ,_param->_size_general_data          , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_READ_RA       ,"read_ra"      ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RA    ,"num_reg_ra"   ,Tgeneral_address_t,_param->_size_general_register_logic, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_READ_RB       ,"read_rb"      ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RB    ,"num_reg_rb"   ,Tgeneral_address_t,_param->_size_general_register_logic, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_READ_RC       ,"read_rc"      ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RC    ,"num_reg_rc"   ,Tspecial_address_t,_param->_size_special_register_logic, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_WRITE_RD      ,"write_rd"     ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RD    ,"num_reg_rd"   ,Tgeneral_address_t,_param->_size_general_register_logic, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_WRITE_RE      ,"write_re"     ,Tcontrol_t        ,1                                   , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_NUM_REG_RE    ,"num_reg_re"   ,Tspecial_address_t,_param->_size_special_register_logic, _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_EXCEPTION_USE ,"exception_use",Texception_t      ,_param->_size_exception_use         , _param->_nb_front_end, _param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IN_EXCEPTION     ,"exception"    ,Texception_t      ,_param->_size_exception             , _param->_nb_front_end, _param->_nb_inst_decod[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end, _param->_nb_inst_decod[it1]);
    }

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("insert",OUT,WEST , _("Instruction with physical register"), _param->_nb_inst_insert);
      
      ALLOC1_VALACK_OUT(out_INSERT_VAL                  ,VAL);
      ALLOC1_VALACK_IN ( in_INSERT_ACK                  ,ACK);
      ALLOC1_SIGNAL_OUT(out_INSERT_FRONT_END_ID         ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id          );
      ALLOC1_SIGNAL_OUT(out_INSERT_CONTEXT_ID           ,"context_id"           ,Tcontext_t        ,_param->_size_context_id            );
      ALLOC1_SIGNAL_OUT(out_INSERT_DEPTH                ,"depth"                ,Tdepth_t          ,_param->_size_depth                 );
      ALLOC1_SIGNAL_OUT(out_INSERT_TYPE                 ,"type"                 ,Ttype_t           ,_param->_size_type                  );
      ALLOC1_SIGNAL_OUT(out_INSERT_OPERATION            ,"operation"            ,Toperation_t      ,_param->_size_operation             );
      ALLOC1_SIGNAL_OUT(out_INSERT_NO_EXECUTE           ,"no_execute"           ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_INSERT_LAST_EVENT           ,"last_event"           ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_INSERT_IS_DELAY_SLOT        ,"is_delay_slot"        ,Tcontrol_t        ,1                                   );
#ifdef DEBUG
      ALLOC1_SIGNAL_OUT(out_INSERT_ADDRESS              ,"address"              ,Taddress_t        ,_param->_size_instruction_address   );
#endif
      ALLOC1_SIGNAL_OUT(out_INSERT_ADDRESS_NEXT         ,"address_next"         ,Taddress_t        ,_param->_size_instruction_address   );
      ALLOC1_SIGNAL_OUT(out_INSERT_HAS_IMMEDIAT         ,"has_immediat"         ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_INSERT_IMMEDIAT             ,"immediat"             ,Tgeneral_data_t   ,_param->_size_general_data          );
      ALLOC1_SIGNAL_OUT(out_INSERT_STORE_QUEUE_PTR_WRITE,"store_queue_ptr_write",Tlsq_ptr_t        ,_param->_size_store_queue_ptr       );
      ALLOC1_SIGNAL_OUT(out_INSERT_STORE_QUEUE_PTR_READ ,"store_queue_ptr_read" ,Tlsq_ptr_t        ,_param->_size_store_queue_ptr       );
      ALLOC1_SIGNAL_OUT(out_INSERT_STORE_QUEUE_EMPTY    ,"store_queue_empty"    ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_INSERT_LOAD_QUEUE_PTR_WRITE ,"load_queue_ptr_write" ,Tlsq_ptr_t        ,_param->_size_load_queue_ptr        );
      ALLOC1_SIGNAL_OUT(out_INSERT_EXCEPTION_USE        ,"exception_use"        ,Texception_t      ,_param->_size_exception_use         );
      ALLOC1_SIGNAL_OUT(out_INSERT_EXCEPTION            ,"exception"            ,Texception_t      ,_param->_size_exception             );
      ALLOC1_SIGNAL_OUT(out_INSERT_READ_RA              ,"read_ra"              ,Tcontrol_t        ,1                                   );
#ifdef DEBUG
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RA_LOG       ,"num_reg_ra_log"       ,Tgeneral_address_t,_param->_size_general_register_logic);
#endif
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RA_PHY       ,"num_reg_ra_phy"       ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_READ_RB              ,"read_rb"              ,Tcontrol_t        ,1                                   );
#ifdef DEBUG
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RB_LOG       ,"num_reg_rb_log"       ,Tgeneral_address_t,_param->_size_general_register_logic);
#endif
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RB_PHY       ,"num_reg_rb_phy"       ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_READ_RC              ,"read_rc"              ,Tcontrol_t        ,1                                   );
#ifdef DEBUG
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RC_LOG       ,"num_reg_rc_log"       ,Tspecial_address_t,_param->_size_special_register_logic);
#endif
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RC_PHY       ,"num_reg_rc_phy"       ,Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_WRITE_RD             ,"write_rd"             ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RD_LOG       ,"num_reg_rd_log"       ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RD_PHY_OLD   ,"num_reg_rd_phy_old"   ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RD_PHY_NEW   ,"num_reg_rd_phy_new"   ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_WRITE_RE             ,"write_re"             ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RE_LOG       ,"num_reg_re_log"       ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RE_PHY_OLD   ,"num_reg_re_phy_old"   ,Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RE_PHY_NEW   ,"num_reg_re_phy_new"   ,Tspecial_address_t,_param->_size_special_register      );

      ALLOC1_INTERFACE_END(_param->_nb_inst_insert);
    }

    // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("retire",IN ,NORTH, _("Retire instruction, update renaming structure."), _param->_nb_inst_retire);

      ALLOC1_VALACK_IN ( in_RETIRE_VAL                  ,VAL);
      ALLOC1_VALACK_OUT(out_RETIRE_ACK                  ,ACK);
      ALLOC1_SIGNAL_IN ( in_RETIRE_FRONT_END_ID         ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id          );
      ALLOC1_SIGNAL_IN ( in_RETIRE_CONTEXT_ID           ,"context_id"           ,Tcontext_t        ,_param->_size_context_id            );
//    ALLOC1_SIGNAL_IN ( in_RETIRE_TYPE                 ,"type"                 ,Ttype_t           ,_param->_size_type                  );
//    ALLOC1_SIGNAL_IN ( in_RETIRE_OPERATION            ,"operation"            ,Toperation_t      ,_param->_size_operation             );
      ALLOC1_SIGNAL_IN ( in_RETIRE_USE_STORE_QUEUE      ,"use_store_queue"      ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RETIRE_USE_LOAD_QUEUE       ,"use_load_queue"       ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RETIRE_STORE_QUEUE_PTR_WRITE,"store_queue_ptr_write",Tlsq_ptr_t        ,_param->_size_store_queue_ptr       );
      ALLOC1_SIGNAL_IN ( in_RETIRE_LOAD_QUEUE_PTR_WRITE ,"load_queue_ptr_write" ,Tlsq_ptr_t        ,_param->_size_load_queue_ptr        );
//       ALLOC1_SIGNAL_IN ( in_RETIRE_READ_RA              ,"read_ra"              ,Tcontrol_t        ,1                                   );
//       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RA_PHY       ,"num_reg_ra_phy"       ,Tgeneral_address_t,_param->_size_general_register      );
//       ALLOC1_SIGNAL_IN ( in_RETIRE_READ_RB              ,"read_rb"              ,Tcontrol_t        ,1                                   );
//       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RB_PHY       ,"num_reg_rb_phy"       ,Tgeneral_address_t,_param->_size_general_register      );
//       ALLOC1_SIGNAL_IN ( in_RETIRE_READ_RC              ,"read_rc"              ,Tcontrol_t        ,1                                   );
//       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RC_PHY       ,"num_reg_rc_phy"       ,Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_IN ( in_RETIRE_WRITE_RD             ,"write_rd"             ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RD_LOG       ,"num_reg_rd_log"       ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RD_PHY_OLD   ,"num_reg_rd_phy_old"   ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RD_PHY_NEW   ,"num_reg_rd_phy_new"   ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_IN ( in_RETIRE_WRITE_RE             ,"write_re"             ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RE_LOG       ,"num_reg_re_log"       ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RE_PHY_OLD   ,"num_reg_re_phy_old"   ,Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RE_PHY_NEW   ,"num_reg_re_phy_new"   ,Tspecial_address_t,_param->_size_special_register      );

      ALLOC1_INTERFACE_END(_param->_nb_inst_retire);
    }

    // ~~~~~[ Interface : "retire_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("retire_event", IN,NORTH, _("Retire event"), _param->_nb_front_end, _param->_nb_context[it1]);

      _ALLOC2_VALACK_IN ( in_RETIRE_EVENT_VAL           ,VAL,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_VALACK_OUT(out_RETIRE_EVENT_ACK           ,ACK,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_RETIRE_EVENT_STATE         ,"state"                ,Tevent_state_t    ,_param->_size_event_state, _param->_nb_front_end, _param->_nb_context[it1]);
//       _ALLOC2_SIGNAL_IN ( in_RETIRE_EVENT_FLUSH         ,"flush"                ,Tcontrol_t        ,1                        , _param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_RETIRE_EVENT_STOP          ,"stop"                 ,Tcontrol_t        ,1                        , _param->_nb_front_end, _param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end, _param->_nb_context[it1]);
    }

    // ~~~~~[ Interface : "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("spr_read", IN,NORTH, _("Special register"), _param->_nb_front_end, _param->_nb_context[it1]);

      _ALLOC2_SIGNAL_IN (in_SPR_READ_SR                 ,"sr",Tspr_t            ,_param->_size_spr, _param->_nb_front_end, _param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end, _param->_nb_context[it1]);
    }

    // ~~~~~[ interface : "info" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#ifdef DEBUG_TEST
     {
       ALLOC0_INTERFACE_BEGIN("info",IN, NORTH, _("Information"));

       ALLOC0_SIGNAL_IN ( in_INFO_ROB_EMPTY  ,"rob_empty"  ,bool    ,1);

       ALLOC0_INTERFACE_END();
     }
#endif

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    std::string name;

    {
      name = _name+"_rename_select";
      log_printf(TRACE,Rename_unit,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_rename_select = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_select::Rename_select
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_rename_select
	 ,_usage);
      
      _component->set_component (_component_rename_select->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    {
      name = _name+"_register_translation_unit";
      log_printf(TRACE,Rename_unit,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_register_translation_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::Register_translation_unit
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_register_translation_unit
	 ,_usage);
      
      _component->set_component (_component_register_translation_unit->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    {
      name = _name+"_load_store_pointer_unit";
      log_printf(TRACE,Rename_unit,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_load_store_pointer_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::load_store_pointer_unit::Load_Store_pointer_unit
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_load_store_pointer_unit
	 ,_usage);
      
      _component->set_component (_component_load_store_pointer_unit->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    {
      name = _name+"_glue";
      log_printf(TRACE,Rename_unit,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_glue = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_unit_glue::Rename_unit_Glue
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_glue
	 ,_usage);
      
      _component->set_component (_component_glue->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }
    
    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    std::string src,dest;

    // ===================================================================
    // =====[ rename_select ]=============================================
    // ===================================================================
    {
      src = _name+"_rename_select";
      log_printf(TRACE,Rename_unit,FUNCTION,_("Instance : %s"),name.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      for (uint32_t i=0; i<_param->_nb_front_end; i++)
	for (uint32_t j=0; j<_param->_nb_inst_decod[i]; j++)
	  {
	    dest = _name;
#ifdef POSITION
	    _component->interface_map (src ,"rename_in_"+toString(i)+"_"+toString(j),
				       dest,"rename_in_"+toString(i)+"_"+toString(j));
#endif      

	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_VAL"          ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_VAL"          );
	    PORT_MAP(_component,src ,"out_RENAME_IN_"+toString(i)+"_"+toString(j)+"_ACK"          ,
		                dest,"out_RENAME_IN_"+toString(i)+"_"+toString(j)+"_ACK"          );
	    if (_param->_have_port_front_end_id)
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_FRONT_END_ID" ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_FRONT_END_ID" );
	    if (_param->_have_port_context_id)
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"   ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"   );
	    if (_param->_have_port_depth)
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_DEPTH"        ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_DEPTH"        );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_TYPE"         ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_TYPE"         );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_OPERATION"    ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_OPERATION"    );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_NO_EXECUTE"   ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_NO_EXECUTE"   );
// 	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_HAVE_EVENT"   ,
// 		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_HAVE_EVENT"   );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_LAST_EVENT"   ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_LAST_EVENT"   );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_IS_DELAY_SLOT",
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_IS_DELAY_SLOT");
#ifdef DEBUG
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_ADDRESS"      ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_ADDRESS"      );
#endif
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_ADDRESS_NEXT" ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_ADDRESS_NEXT" );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_HAS_IMMEDIAT" ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_HAS_IMMEDIAT" );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_IMMEDIAT"     ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_IMMEDIAT"     );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_READ_RA"      ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_READ_RA"      );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_NUM_REG_RA"   ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_NUM_REG_RA"   );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_READ_RB"      ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_READ_RB"      );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_NUM_REG_RB"   ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_NUM_REG_RB"   );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_READ_RC"      ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_READ_RC"      );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_NUM_REG_RC"   ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_NUM_REG_RC"   );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_WRITE_RD"     ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_WRITE_RD"     );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_NUM_REG_RD"   ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_NUM_REG_RD"   );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_WRITE_RE"     ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_WRITE_RE"     );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_NUM_REG_RE"   ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_NUM_REG_RE"   );
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_EXCEPTION_USE",
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_EXCEPTION_USE");
	    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_EXCEPTION"    ,
		                dest, "in_RENAME_IN_"+toString(i)+"_"+toString(j)+"_EXCEPTION"    );
	  }

      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"rename_out_"+toString(i),
				     dest,"insert_"    +toString(i));
#endif

	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_IS_DELAY_SLOT",
		              dest,"out_INSERT_"    +toString(i)+"_IS_DELAY_SLOT");
	  if (_param->_have_port_depth)
	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_DEPTH"       ,
		              dest,"out_INSERT_"    +toString(i)+"_DEPTH"       );
#ifdef DEBUG
	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_ADDRESS"     ,
		              dest,"out_INSERT_"    +toString(i)+"_ADDRESS"     );
#endif
	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_ADDRESS_NEXT",
		              dest,"out_INSERT_"    +toString(i)+"_ADDRESS_NEXT");
	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_HAS_IMMEDIAT",
		              dest,"out_INSERT_"    +toString(i)+"_HAS_IMMEDIAT");
	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_EXCEPTION_USE",
		              dest,"out_INSERT_"    +toString(i)+"_EXCEPTION_USE");
	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_LAST_EVENT",
		              dest,"out_INSERT_"    +toString(i)+"_LAST_EVENT");

	  dest = _name+"_register_translation_unit";

#ifdef POSITION
	  _component->interface_map (src ,"rename_out_"+toString(i),
				     dest,"rename_"    +toString(i));
#endif

	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_READ_RA"   ,
		                   dest, "in_RENAME_"    +toString(i)+"_READ_RA"   );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RA",
		                   dest, "in_RENAME_"    +toString(i)+"_NUM_REG_RA_LOG");
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_READ_RB"   ,
		                   dest, "in_RENAME_"    +toString(i)+"_READ_RB"   );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RB",
		                   dest, "in_RENAME_"    +toString(i)+"_NUM_REG_RB_LOG");
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_READ_RC"   ,
		                   dest, "in_RENAME_"    +toString(i)+"_READ_RC"   );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RC",
		                   dest, "in_RENAME_"    +toString(i)+"_NUM_REG_RC_LOG");
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_WRITE_RD"  ,
		                   dest, "in_RENAME_"    +toString(i)+"_WRITE_RD"  );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RD",
		                   dest, "in_RENAME_"    +toString(i)+"_NUM_REG_RD_LOG");
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_WRITE_RE"  ,
		                   dest, "in_RENAME_"    +toString(i)+"_WRITE_RE"  );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RE",
			           dest, "in_RENAME_"    +toString(i)+"_NUM_REG_RE_LOG");

	  dest = _name+"_glue";

#ifdef POSITION
	  _component->interface_map (src ,"rename_out_"+toString(i),
				     dest,"insert_"    +toString(i));
#endif
	  
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+              "_VAL"          ,
			           dest, "in_INSERT_"    +toString(i)+"_RENAME_SELECT_VAL"          );
	  COMPONENT_MAP(_component,src , "in_RENAME_OUT_"+toString(i)+              "_ACK"          ,
			           dest,"out_INSERT_"    +toString(i)+"_RENAME_SELECT_ACK"          );
	  if (_param->_have_port_front_end_id)
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+              "_FRONT_END_ID" ,
			           dest, "in_INSERT_"    +toString(i)+"_RENAME_SELECT_FRONT_END_ID" );
	  if (_param->_have_port_context_id)
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+              "_CONTEXT_ID"   ,
			           dest, "in_INSERT_"    +toString(i)+"_RENAME_SELECT_CONTEXT_ID"   );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+              "_TYPE"         ,
			           dest, "in_INSERT_"    +toString(i)+"_RENAME_SELECT_TYPE"         );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+              "_OPERATION"    ,
			           dest, "in_INSERT_"    +toString(i)+"_RENAME_SELECT_OPERATION"    );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+              "_IMMEDIAT"    ,
		                   dest, "in_INSERT_"    +toString(i)+"_RENAME_SELECT_IMMEDIAT"     );
// 	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+              "_EXCEPTION_USE",
// 			           dest, "in_INSERT_"    +toString(i)+"_RENAME_SELECT_EXCEPTION_USE");
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+              "_EXCEPTION"    ,
			           dest, "in_INSERT_"    +toString(i)+"_RENAME_SELECT_EXCEPTION"    );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+              "_NO_EXECUTE"   ,
			           dest, "in_INSERT_"    +toString(i)+"_RENAME_SELECT_NO_EXECUTE"   );
	}

      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_context[i]; j++)
          {
            dest = _name;
            
#ifdef POSITION
            _component->interface_map (src ,"retire_event_"+toString(i)+"_"+toString(j),
                                       dest,"retire_event_"+toString(i)+"_"+toString(j));
#endif     
// 	    PORT_MAP(_component,src , "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_FLUSH",
//                                 dest, "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_FLUSH");
	    PORT_MAP(_component,src , "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_STOP",
                                dest, "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_STOP");
          }
    }

    // ===================================================================
    // =====[ register_translation_unit ]=================================
    // ===================================================================
    {
      src = _name+"_register_translation_unit";
      log_printf(TRACE,Rename_unit,FUNCTION,_("Instance : %s"),name.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
 	  dest = _name+"_rename_select";

#ifdef POSITION
	  _component->interface_map (src ,"rename_"    +toString(i),
				     dest,"rename_out_"+toString(i));
#endif      

 	  dest = _name+"_glue";

#ifdef POSITION
	  _component->interface_map (src ,"rename_"+toString(i),
				     dest,"insert_"+toString(i));
#endif      

	  COMPONENT_MAP(_component,src , "in_RENAME_"+toString(i)+                     "_VAL"         ,
			           dest,"out_INSERT_"+toString(i)+"_REGISTER_TRANSLATION_VAL"         );
	  COMPONENT_MAP(_component,src ,"out_RENAME_"+toString(i)+                     "_ACK"         ,
			           dest, "in_INSERT_"+toString(i)+"_REGISTER_TRANSLATION_ACK"         );
	  if (_param->_have_port_front_end_id)
	  COMPONENT_MAP(_component,src , "in_RENAME_"+toString(i)+                     "_FRONT_END_ID",
			           dest,"out_INSERT_"+toString(i)+"_REGISTER_TRANSLATION_FRONT_END_ID");
	  if (_param->_have_port_context_id)
	  COMPONENT_MAP(_component,src , "in_RENAME_"+toString(i)+                     "_CONTEXT_ID"  ,
			           dest,"out_INSERT_"+toString(i)+"_REGISTER_TRANSLATION_CONTEXT_ID"  );

	  //  in_RENAME_READ_RA           - rename_select
	  //  in_RENAME_NUM_REG_RA_LOG    - rename_select
	  //  in_RENAME_READ_RB           - rename_select
	  //  in_RENAME_NUM_REG_RB_LOG    - rename_select
	  //  in_RENAME_READ_RC           - rename_select
	  //  in_RENAME_NUM_REG_RC_LOG    - rename_select
	  //  in_RENAME_WRITE_RD          - rename_select
	  //  in_RENAME_NUM_REG_RD_LOG    - rename_select
	  //  in_RENAME_WRITE_RE          - rename_select
	  //  in_RENAME_NUM_REG_RE_LOG    - rename_select

	}

      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"insert_"+toString(i),
				     dest,"insert_"+toString(i));
#endif      
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_VAL"               ,
		              dest,"out_INSERT_"+toString(i)+"_VAL"               );
	  PORT_MAP(_component,src , "in_INSERT_"+toString(i)+"_ACK"               ,
		              dest, "in_INSERT_"+toString(i)+"_ACK"               );
	  if (_param->_have_port_front_end_id)
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_FRONT_END_ID"      ,
		              dest,"out_INSERT_"+toString(i)+"_FRONT_END_ID"      );
	  if (_param->_have_port_context_id)
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_CONTEXT_ID"        ,
		              dest,"out_INSERT_"+toString(i)+"_CONTEXT_ID"        );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_READ_RA"           ,
		              dest,"out_INSERT_"+toString(i)+"_READ_RA"           );
#ifdef DEBUG
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RA_LOG"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RA_LOG"    );
#endif
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RA_PHY"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RA_PHY"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_READ_RB"           ,
		              dest,"out_INSERT_"+toString(i)+"_READ_RB"           );
#ifdef DEBUG
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RB_LOG"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RB_LOG"    );
#endif
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RB_PHY"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RB_PHY"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_READ_RC"           ,
		              dest,"out_INSERT_"+toString(i)+"_READ_RC"           );
#ifdef DEBUG
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RC_LOG"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RC_LOG"    );
#endif
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RC_PHY"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RC_PHY"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_WRITE_RD"          ,
		              dest,"out_INSERT_"+toString(i)+"_WRITE_RD"          );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RD_LOG"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RD_LOG"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RD_PHY_OLD",
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RD_PHY_OLD");
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RD_PHY_NEW",
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RD_PHY_NEW");
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_WRITE_RE"          ,
		              dest,"out_INSERT_"+toString(i)+"_WRITE_RE"          );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RE_LOG"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RE_LOG"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RE_PHY_OLD",
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RE_PHY_OLD");

	  // HACK : use the field num_reg_re to pass the SM and SUMRA flag.
	  // cf : rename_unit_glue and functionnal_unit/Operation
	  dest = _name+"_glue";

	  COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(i)+                     "_NUM_REG_RE_PHY_NEW",
			           dest, "in_INSERT_"+toString(i)+"_REGISTER_TRANSLATION_NUM_REG_RE_PHY_NEW");
	}

      for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	{
	  dest = _name;
	  
#ifdef POSITION
	  _component->interface_map (src ,"retire_"+toString(i),
				     dest,"retire_"+toString(i));
#endif      
	  
	  if (_param->_have_port_front_end_id)
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_FRONT_END_ID"      ,
		              dest, "in_RETIRE_"+toString(i)+"_FRONT_END_ID"      );
	  if (_param->_have_port_context_id)
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_CONTEXT_ID"        ,
		              dest, "in_RETIRE_"+toString(i)+"_CONTEXT_ID"        );
// 	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_READ_RA"           ,
// 		              dest, "in_RETIRE_"+toString(i)+"_READ_RA"           );
// 	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RA_PHY"    ,
// 		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RA_PHY"    );
// 	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_READ_RB"           ,
// 		              dest, "in_RETIRE_"+toString(i)+"_READ_RB"           );
// 	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RB_PHY"    ,
// 		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RB_PHY"    );
// 	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_READ_RC"           ,
// 		              dest, "in_RETIRE_"+toString(i)+"_READ_RC"           );
// 	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RC_PHY"    ,
// 		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RC_PHY"    );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_WRITE_RD"          ,
		              dest, "in_RETIRE_"+toString(i)+"_WRITE_RD"          );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RD_LOG"    ,
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RD_LOG"    );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RD_PHY_OLD",
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RD_PHY_OLD");
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RD_PHY_NEW",
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RD_PHY_NEW");
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_WRITE_RE"          ,
		              dest, "in_RETIRE_"+toString(i)+"_WRITE_RE"          );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RE_LOG"    ,
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RE_LOG"    );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RE_PHY_OLD",
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RE_PHY_OLD");
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RE_PHY_NEW",
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RE_PHY_NEW");

	  dest = _name+"_glue";
	  
#ifdef POSITION
	  _component->interface_map (src ,"retire_"+toString(i),
				     dest,"retire_"+toString(i));
#endif      

	  COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_VAL",dest,"out_RETIRE_"+toString(i)+"_REGISTER_TRANSLATION_VAL");
	  COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_ACK",dest, "in_RETIRE_"+toString(i)+"_REGISTER_TRANSLATION_ACK");
	}

      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_context[i]; j++)
          {
            dest = _name+"_glue";
            
#ifdef POSITION
            _component->interface_map (src ,"retire_event_"+toString(i)+"_"+toString(j),
                                       dest,"retire_event_"+toString(i)+"_"+toString(j));
#endif     
            COMPONENT_MAP(_component,src , "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+                     "_VAL"  ,
                                     dest,"out_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_REGISTER_TRANSLATION_VAL"  );
	    COMPONENT_MAP(_component,src ,"out_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+                     "_ACK"  ,
                                     dest, "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_REGISTER_TRANSLATION_ACK"  );

            dest = _name;

#ifdef POSITION
            _component->interface_map (src ,"retire_event_"+toString(i)+"_"+toString(j),
                                       dest,"retire_event_"+toString(i)+"_"+toString(j));
#endif     
	    PORT_MAP(_component,src , "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_STATE",
                                dest, "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_STATE");
          }


#ifdef DEBUG_TEST
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"info"
                                   dest,"info");
#endif
        
        PORT_MAP(_component,src , "in_INFO_ROB_EMPTY",
                            dest, "in_INFO_ROB_EMPTY");
      }
#endif
    }

    // ===================================================================
    // =====[ load_store_pointer_unit ]===================================
    // ===================================================================
    {
      src = _name+"_load_store_pointer_unit";
      log_printf(TRACE,Rename_unit,FUNCTION,_("Instance : %s"),name.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"insert_"+toString(i),
				     dest,"insert_"+toString(i));
#endif      

	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_STORE_QUEUE_PTR_WRITE",
		              dest,"out_INSERT_"+toString(i)+"_STORE_QUEUE_PTR_WRITE");
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_STORE_QUEUE_PTR_READ" ,
		              dest,"out_INSERT_"+toString(i)+"_STORE_QUEUE_PTR_READ" );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_STORE_QUEUE_EMPTY"    ,
		              dest,"out_INSERT_"+toString(i)+"_STORE_QUEUE_EMPTY"    );
	  if (_param->_have_port_load_queue_ptr)
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" ,
		              dest,"out_INSERT_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" );

	  dest = _name+"_glue";

#ifdef POSITION
	  _component->interface_map (src ,"insert_"+toString(i),
				     dest,"insert_"+toString(i));
#endif      
	  
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+                         "_VAL"         ,
			           dest,"out_INSERT_"+toString(i)+"_LOAD_STORE_QUEUE_POINTER_VAL"         );
	  COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(i)+                         "_ACK"         ,
			           dest, "in_INSERT_"+toString(i)+"_LOAD_STORE_QUEUE_POINTER_ACK"         );
	  if (_param->_have_port_front_end_id)
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+                         "_FRONT_END_ID",
			           dest,"out_INSERT_"+toString(i)+"_LOAD_STORE_QUEUE_POINTER_FRONT_END_ID");
	  if (_param->_have_port_context_id)
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+                         "_CONTEXT_ID"  ,
			           dest,"out_INSERT_"+toString(i)+"_LOAD_STORE_QUEUE_POINTER_CONTEXT_ID"  );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+                         "_TYPE"        ,
			           dest,"out_INSERT_"+toString(i)+"_LOAD_STORE_QUEUE_POINTER_TYPE"        );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+                         "_OPERATION"   ,
			           dest,"out_INSERT_"+toString(i)+"_LOAD_STORE_QUEUE_POINTER_OPERATION"   );
	}

      for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	{
	  dest = _name;
	  
#ifdef POSITION
	  _component->interface_map (src ,"retire_"+toString(i),
				     dest,"retire_"+toString(i));
#endif      

	  if (_param->_have_port_front_end_id)
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_FRONT_END_ID"         ,
		              dest, "in_RETIRE_"+toString(i)+"_FRONT_END_ID"         );
	  if (_param->_have_port_context_id)					     
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_CONTEXT_ID"           ,
		              dest, "in_RETIRE_"+toString(i)+"_CONTEXT_ID"           );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_USE_STORE_QUEUE"      ,      
		              dest, "in_RETIRE_"+toString(i)+"_USE_STORE_QUEUE"      );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_USE_LOAD_QUEUE"       ,      
		              dest, "in_RETIRE_"+toString(i)+"_USE_LOAD_QUEUE"       );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_STORE_QUEUE_PTR_WRITE",
		              dest, "in_RETIRE_"+toString(i)+"_STORE_QUEUE_PTR_WRITE");
	  if (_param->_have_port_load_queue_ptr)
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" ,
		              dest, "in_RETIRE_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" );

	  dest = _name+"_glue";

#ifdef POSITION
	  _component->interface_map (src ,"retire_"+toString(i),
				     dest,"retire_"+toString(i));
#endif      
	  
	  COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(i)+                         "_VAL"         ,
			           dest,"out_RETIRE_"+toString(i)+"_LOAD_STORE_QUEUE_POINTER_VAL"         );
	  COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+                         "_ACK"         ,
			           dest, "in_RETIRE_"+toString(i)+"_LOAD_STORE_QUEUE_POINTER_ACK"         );
	  //// in_RETIRE_TYPE         - glue
	  //// in_RETIRE_OPERATION    - glue
	}

      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_context[i]; j++)
          {
            dest = _name+"_glue";
           
#ifdef POSITION
            _component->interface_map (src ,"retire_event_"+toString(i)+"_"+toString(j),
                                       dest,"retire_event_"+toString(i)+"_"+toString(j));
#endif     
            COMPONENT_MAP(_component,src , "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+                         "_VAL"  ,
                                     dest,"out_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_LOAD_STORE_QUEUE_POINTER_VAL"  );
	    COMPONENT_MAP(_component,src ,"out_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+                         "_ACK"  ,
                                     dest, "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_LOAD_STORE_QUEUE_POINTER_ACK"  );

            dest = _name;
            
#ifdef POSITION
            _component->interface_map (src ,"retire_event_"+toString(i)+"_"+toString(j),
                                       dest,"retire_event_"+toString(i)+"_"+toString(j));
#endif     
	    PORT_MAP(_component,src , "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_STATE",
                                dest, "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_STATE");
          }
    }

    // ===================================================================
    // =====[ glue ]======================================================
    // ===================================================================
    {
      src = _name+"_glue";
      log_printf(TRACE,Rename_unit,FUNCTION,_("Instance : %s"),name.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"insert_"+toString(i),
				     dest,"insert_"+toString(i));
#endif      

	  // //out_INSERT_VAL
	  // // in_INSERT_ACK
	  if (_param->_have_port_front_end_id)
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_FRONT_END_ID" ,
		              dest,"out_INSERT_"+toString(i)+"_FRONT_END_ID" );
	  if (_param->_have_port_context_id)
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_CONTEXT_ID"   ,
		              dest,"out_INSERT_"+toString(i)+"_CONTEXT_ID"   );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_TYPE"         ,
		              dest,"out_INSERT_"+toString(i)+"_TYPE"         );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_OPERATION"    ,
		              dest,"out_INSERT_"+toString(i)+"_OPERATION"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_IMMEDIAT"     ,
		              dest,"out_INSERT_"+toString(i)+"_IMMEDIAT"     );
// 	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_EXCEPTION_USE",
// 		              dest,"out_INSERT_"+toString(i)+"_EXCEPTION_USE");
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_EXCEPTION"    ,
		              dest,"out_INSERT_"+toString(i)+"_EXCEPTION"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RE_PHY_NEW",
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RE_PHY_NEW");
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NO_EXECUTE"  ,
		              dest,"out_INSERT_"+toString(i)+"_NO_EXECUTE"  );
	  
	  //    in_INSERT_RENAME_SELECT_VAL                       - rename_select
	  //   out_INSERT_RENAME_SELECT_ACK                       - rename_select
	  //    in_INSERT_RENAME_SELECT_FRONT_END_ID              - rename_select
	  //    in_INSERT_RENAME_SELECT_CONTEXT_ID                - rename_select
	  //    in_INSERT_RENAME_SELECT_TYPE                      - rename_select
	  //    in_INSERT_RENAME_SELECT_OPERATION                 - rename_select
	  //    in_INSERT_RENAME_SELECT_IMMEDIAT                  - rename_select
// 	  //    in_INSERT_RENAME_SELECT_EXCEPTION_USE             - rename_select
	  //    in_INSERT_RENAME_SELECT_EXCEPTION                 - rename_select
	  							  
	  //   out_INSERT_REGISTER_TRANSLATION_VAL                - register_translation_unit
	  //    in_INSERT_REGISTER_TRANSLATION_ACK                - register_translation_unit
	  //   out_INSERT_REGISTER_TRANSLATION_FRONT_END_ID       - register_translation_unit
	  //   out_INSERT_REGISTER_TRANSLATION_CONTEXT_ID         - register_translation_unit
	  //   out_INSERT_REGISTER_TRANSLATION_NUM_REG_RE_PHY_NEW - register_translation_unit
	  
	  //   out_INSERT_LOAD_STORE_QUEUE_POINTER_VAL            - load_store_pointer_unit
	  //    in_INSERT_LOAD_STORE_QUEUE_POINTER_ACK            - load_store_pointer_unit
	  //   out_INSERT_LOAD_STORE_QUEUE_POINTER_FRONT_END_ID   - load_store_pointer_unit
	  //   out_INSERT_LOAD_STORE_QUEUE_POINTER_CONTEXT_ID     - load_store_pointer_unit
	  //   out_INSERT_LOAD_STORE_QUEUE_POINTER_TYPE           - load_store_pointer_unit
	  //   out_INSERT_LOAD_STORE_QUEUE_POINTER_OPERATION      - load_store_pointer_unit
	}

      for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"retire_"+toString(i),
				     dest,"retire_"+toString(i));
#endif      
	  
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_VAL",
		              dest, "in_RETIRE_"+toString(i)+"_VAL");
	  PORT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_ACK",
		              dest,"out_RETIRE_"+toString(i)+"_ACK");

	  //   out_RETIRE_LOAD_STORE_QUEUE_POINTER_VAL          - load_store_pointer_unit
	  //    in_RETIRE_LOAD_STORE_QUEUE_POINTER_ACK          - load_store_pointer_unit
	  // //out_RETIRE_LOAD_STORE_QUEUE_POINTER_TYPE         - load_store_pointer_unit
	  // //out_RETIRE_LOAD_STORE_QUEUE_POINTER_OPERATION    - load_store_pointer_unit
	  //   out_RETIRE_REGISTER_TRANSLATION_VAL              - register_translation_unit
	  //    in_RETIRE_REGISTER_TRANSLATION_ACK              - register_translation_unit
	}

      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_context[i]; j++)
          {
            dest = _name;
            
#ifdef POSITION
            _component->interface_map (src ,"retire_event_"+toString(i)+"_"+toString(j),
                                       dest,"retire_event_"+toString(i)+"_"+toString(j));
#endif      
            
            PORT_MAP(_component,src , "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_VAL",
		                dest, "in_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_VAL");
            PORT_MAP(_component,src ,"out_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_ACK",
		                dest,"out_RETIRE_EVENT_"+toString(i)+"_"+toString(j)+"_ACK");

            //   out_RETIRE_EVENT_LOAD_STORE_QUEUE_POINTER_VAL          - load_store_pointer_unit
            //    in_RETIRE_EVENT_LOAD_STORE_QUEUE_POINTER_ACK          - load_store_pointer_unit
            //   out_RETIRE_EVENT_REGISTER_TRANSLATION_VAL              - register_translation_unit
            //    in_RETIRE_EVENT_REGISTER_TRANSLATION_ACK              - register_translation_unit
          }


      for (uint32_t i=0; i<_param->_nb_front_end; i++)
	for (uint32_t j=0; j<_param->_nb_context[i]; j++)
	  {
	    dest = _name;
#ifdef POSITION
	    _component->interface_map (src ,"spr_read_"+toString(i)+"_"+toString(j),
				       dest,"spr_read_"+toString(i)+"_"+toString(j));
#endif      

	    PORT_MAP(_component,src , "in_SPR_READ_"+toString(i)+"_"+toString(j)+"_SR",
		                dest, "in_SPR_READ_"+toString(i)+"_"+toString(j)+"_SR");
	  }
    }

    // ~~~~~[ Others ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
#if DEBUG_Rename_unit == true
    _component->test_map();
#endif

#ifdef POSITION
     if (usage_is_set(_usage,USE_POSITION))
       _component->generate_file();
#endif

     log_end(Rename_unit,FUNCTION);
  };

}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
