#ifdef SYSTEMC
/*
 * $Id: Meta_Predictor_Glue_genMealy_predict.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace meta_predictor_glue {


#undef  FUNCTION
#define FUNCTION "Meta_Predictor_Glue::genMealy_predict"
  void Meta_Predictor_Glue::genMealy_predict (void)
  {
    log_begin(Meta_Predictor_Glue,FUNCTION);
    log_function(Meta_Predictor_Glue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    for (uint32_t i=0; i<_param->_nb_inst_predict; ++i)
      {
        Thistory_t history  ;
        Tcontrol_t direction;

        switch (_param->_nb_predictor)
          {
          case 1 :
            {
              history   = PORT_READ(in_PREDICT_PREDICTOR_HISTORY   [0][i]);
              direction = PORT_READ(in_PREDICT_PREDICTOR_DIRECTION [0][i]);

              if (_param->_predictor_update_on_prediction [0])
                {
                  PORT_WRITE(out_PREDICT_PREDICTOR_DIRECTION_VAL [0][i],true     );
                  PORT_WRITE(out_PREDICT_PREDICTOR_DIRECTION     [0][i],direction);
                }
              break;
            }
          case 3 :
            {
              Thistory_t history_0   = PORT_READ(in_PREDICT_PREDICTOR_HISTORY   [0][i]);
              Thistory_t history_1   = PORT_READ(in_PREDICT_PREDICTOR_HISTORY   [1][i]);
              Thistory_t history_2   = PORT_READ(in_PREDICT_PREDICTOR_HISTORY   [2][i]);
              Tcontrol_t direction_0 = PORT_READ(in_PREDICT_PREDICTOR_DIRECTION [0][i]);
              Tcontrol_t direction_1 = PORT_READ(in_PREDICT_PREDICTOR_DIRECTION [1][i]);
              Tcontrol_t direction_2 = PORT_READ(in_PREDICT_PREDICTOR_DIRECTION [2][i]);

              history   = ((history_0 <<_param->_predictor_history_shift [0]) |
                           (history_1 <<_param->_predictor_history_shift [1]) |
                           (history_2 <<_param->_predictor_history_shift [2]));

              direction = ((    direction_2 and direction_1) or
                           (not direction_2 and direction_0));
              
              if (_param->_predictor_update_on_prediction [0])
                {
                  PORT_WRITE(out_PREDICT_PREDICTOR_DIRECTION_VAL [0][i],direction_2 == 0);
                  PORT_WRITE(out_PREDICT_PREDICTOR_DIRECTION     [0][i],direction);
                }
              if (_param->_predictor_update_on_prediction [1])
                {
                  PORT_WRITE(out_PREDICT_PREDICTOR_DIRECTION_VAL [1][i],direction_2 == 1);
                  PORT_WRITE(out_PREDICT_PREDICTOR_DIRECTION     [1][i],direction);
                }
              if (_param->_predictor_update_on_prediction [2])
                {
                  PORT_WRITE(out_PREDICT_PREDICTOR_DIRECTION_VAL [2][i],true);
                  PORT_WRITE(out_PREDICT_PREDICTOR_DIRECTION     [2][i],direction_2);
                }
              
              break;
            }
          default :
            { 
              break;
            }
          }

        PORT_WRITE(out_PREDICT_HISTORY   [i],history  );
        PORT_WRITE(out_PREDICT_DIRECTION [i],direction);
      }
      }
//     else
//       {
//       }

    log_end(Meta_Predictor_Glue,FUNCTION);
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
