/*
 * $Id: Parameters_msg_error.cpp 124 2009-06-17 12:11:25Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace stat_list_unit {


#undef  FUNCTION
#define FUNCTION "Stat_List_unit::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_printf(FUNC,Stat_List_unit,FUNCTION,"Begin");

    Parameters_test test("Stat_List_unit");

    if (not is_multiple(_nb_bank, _nb_reg_free))
      test.error(_("nb_bank must be a multiple of nb_reg_free.\n"));

    if (_nb_general_register < _nb_gpr_use_init)
      test.error(toString(_("the number of physical general register is insuffisant. (you need less %d registers.\n"),_nb_gpr_use_init));

    if (_nb_special_register < _nb_spr_use_init)
      test.error(toString(_("the number of physical special register is insuffisant. (you need less %d registers.\n"),_nb_spr_use_init));
    
    if (not is_power2(_nb_general_register))
      test.error(_("the number of physical general register must be a power of 2.\n"));

    if (not is_power2(_nb_special_register))
      test.error(_("the number of physical special register must be a power of 2.\n"));

//     if (not is_multiple(_nb_general_register,_nb_bank))
//       test.error(_("nb_general_register must be a multiple of nb_bank.\n"));
//     if (not is_multiple(_nb_special_register,_nb_bank))
//       test.error(_("nb_special_register must be a multiple of nb_bank.\n"));

    if (not is_power2(_nb_bank))
      test.error(_("the number of bank must be a power of 2.\n"));

    return test;

    log_printf(FUNC,Stat_List_unit,FUNCTION,"End");
  };

}; // end namespace stat_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
