#!/bin/bash

#-----------------------------------------------------------
# $Id: execute_n.sh 124 2009-06-17 12:11:25Z rosiere $
#-----------------------------------------------------------

#-----[ my_date ]-------------------------------------------
function my_date ()
{
    date +"%F %T";
}

#-----[ nb_cpu ]--------------------------------------------
function nb_cpu ()
{
    local FILE_CPUINFO=/proc/cpuinfo;
    if test ! -f ${FILE_CPUINFO}; then
	echo "\"${FILE_CPUINFO}\" don't exist."
	usage;
    fi;

    #eval "${1}=`grep -c \"processor\" ${FILE_CPUINFO}`";
    grep -c "processor" ${FILE_CPUINFO};
}

#-----[ execute_n_usage ]-----------------------------------
function execute_n_usage ()
{
    echo "Usage     : ${0} path_word file [ nb_process ]";
    echo "Arguments : ";
    echo " * path_work  : directory to execute command";
    echo " * file       : list of command";
    echo " * nb_process : number of process (default (and maximum) is the number of processor)";
    echo "";
    echo "Note      : ";
    echo " * This script, for each command, create a directory : Task_X (X is the number of command), and execute the command in this directory.";
    echo " * Two file is generate : \"output\" is the output of the execution, and \"command\" is the command lunch.";
#   echo " * A command empty (no command on a line of file) is a synchronisation with all process"
    echo " * Don't forgot the final end of line (else the last command is not executed)";
    echo "";
    exit;
}

#-----[ execute_n_test_usage ]------------------------------
function execute_n_test_usage ()
{
    if test ${#} -ne 2 -a ${#} -ne 3; then
	execute_n_usage;
    fi;

    if test ! -d ${1}; then
        echo "Directory ${1} is invalid";
    fi;

    if test -z "${MORPHEO_SCRIPT}"; then
        echo "Environment variable MORPHEO_SCRIPT is not set";
        execute_n_usage;
    fi;

    if test ! -f ${2}; then
	echo "File \"${2}\" don't exist";
	execute_n_usage;
    fi;

    if test ! -s ${2}; then
	echo "File \"${2}\" is empty";
	execute_n_usage;
    fi;
}

#-----[ execute_n_main ]------------------------------------
function execute_n ()
{
    local -i NB_PROCESS=$(nb_cpu);
    local -i CPT;
    local    PATH_WORK=${1};
    local    FILE_CMD=${2};
    local    FILE_CPT;
    local    FILE_CPU;
    local    ID="cpu-${HOSTNAME}-$$"

    execute_n_test_usage ${*};

    if test ${#} -eq 3; then
	if test ${3} -lt ${NB_PROCESS}; then
	    NB_PROCESS=${3};
	fi;    
    fi;

    FILE_CPT="${PATH_WORK}/control-"$(basename ${FILE_CMD});
    FILE_CPU="${PATH_WORK}/${ID}";

    echo "  * {"$(my_date)"} <${HOSTNAME}> ${NB_PROCESS} process";

    local -i IT_NB_PROCESS=1;
    local -i PID=$$;

    echo "${NB_PROCESS}" > ${FILE_CPU};

    # create the same number of thread that processor
    while test ${IT_NB_PROCESS} -le ${NB_PROCESS}; do
	${MORPHEO_SCRIPT}/execute.sh ${PATH_WORK} ${FILE_CMD} ${FILE_CPT} ${FILE_CPU} "${HOSTNAME}-${IT_NB_PROCESS}" &
	IT_NB_PROCESS=$((${IT_NB_PROCESS}+1));

	if test "$$" -ne ${PID}; then
	    break;
	fi;
    done

    echo "  * {"$(my_date)"} <${HOSTNAME}> all process working";
}

#-----[ Corps ]---------------------------------------------
execute_n ${*};
