#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_execute_unit_execute_unit_load_store_unit_Parameters_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_execute_unit_execute_unit_load_store_unit_Parameters_h

/*
 * $Id: Parameters.h 124 2009-06-17 12:11:25Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Types.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include "Common/include/BitManipulation.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {

  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t            _size_store_queue             ;
  public : uint32_t            _size_load_queue              ;
  public : uint32_t            _size_speculative_access_queue;
  public : uint32_t            _nb_port_check                ;
  public : Tspeculative_load_t _speculative_load             ;
  public : uint32_t            _nb_bypass_memory             ;
  public : uint32_t            _nb_cache_port                ;
  public : uint32_t            _nb_inst_memory               ;
  public : uint32_t            _nb_context                   ;
  public : uint32_t            _nb_front_end                 ;
  public : uint32_t            _nb_ooo_engine                ;
  public : uint32_t            _nb_packet                    ;
//public : uint32_t            _size_general_data            ;
//public : uint32_t            _size_special_data            ;
  public : uint32_t            _nb_general_register          ;
  public : uint32_t            _nb_special_register          ;
  public : uint32_t            _nb_thread                    ;
  public : bool              * _num_thread_valid             ; //[nb_thread]

//public : uint32_t            _size_address_store_queue             ;
//public : uint32_t            _size_address_load_queue              ;
  public : uint32_t            _size_speculative_access_queue_ptr    ;
//public : uint32_t            _size_context_id                      ;
//public : uint32_t            _size_front_end_id                    ;
//public : uint32_t            _size_ooo_engine_id                   ;
//public : uint32_t            _size_packet_id                       ;
//public : uint32_t            _size_general_register                ;
//public : uint32_t            _size_special_register                ;
  public : uint32_t            _size_dcache_context_id               ;
  public : uint32_t            _size_dcache_packet_id                ;

//public : bool                _have_port_context_id                 ;
//public : bool                _have_port_front_end_id               ;
//public : bool                _have_port_ooo_engine_id              ;
//public : bool                _have_port_packet_id                  ;
  public : bool                _have_port_dcache_context_id          ;
//public : bool                _have_port_load_queue_ptr             ;

  public : Tdcache_address_t   _mask_address_lsb                     ;
  public : Tdcache_address_t   _mask_address_msb                     ;
  public : Tdcache_address_t   _mask_check_hit_byte                  ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t            size_store_queue       ,
			uint32_t            size_load_queue        ,
			uint32_t            size_speculative_access_queue,
			uint32_t            nb_port_check          ,
			Tspeculative_load_t speculative_load       ,
			uint32_t            nb_bypass_memory       ,
			uint32_t            nb_cache_port          ,
			uint32_t            nb_inst_memory         ,
			uint32_t            nb_context             ,
			uint32_t            nb_front_end           ,
			uint32_t            nb_ooo_engine          ,
			uint32_t            nb_packet              ,
			uint32_t            size_general_data      ,
			uint32_t            size_special_data      ,
			uint32_t            nb_general_register    ,
			uint32_t            nb_special_register    ,
                        uint32_t            nb_thread              ,
                        bool              * num_thread_valid       , //[nb_thread]
                        bool                is_toplevel=false);

//   public : Parameters  (Parameters & param) ;

  public : ~Parameters () ;

  public : void            copy      (void);

  public : Parameters_test msg_error (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Parameters & x);
  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
