#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#include "Behavioural/include/Version.h"
#include "Common/include/Environment.h"
#include "Common/include/Systemc.h"

namespace morpheo {
namespace behavioural {  

  void Stat::generate_file (void)
  {
    directory();

    std::string body = print(1);

    cycle_t _cycle_sum = simulation_cycle();

    morpheo::behavioural::XML * xml = new morpheo::behavioural::XML (_name_instance);

    xml->balise_open_begin("statistics");
    xml->attribut("nb_cycle_before_begin",toString(_nb_cycle_before_begin));
    xml->attribut("period",toString(_period));
    xml->attribut("nb_cycle_simulation",toString(_cycle_sum));
    xml->attribut("nb_cycle_statistics",toString(_cycle_sum-_nb_cycle_before_begin));
    xml->attribut("morpheo_version",MORPHEO_VERSION);
    xml->balise_open_end();

    xml->text (body);

    xml->balise_close();

    xml->filename_extension ("stat");
    xml->generate_file(MORPHEO_STATISTICS);

    delete xml;
  }
};  
};
#endif
