#ifndef ENVIRONMENT_COMMON_DEBUG_H
#define ENVIRONMENT_COMMON_DEBUG_H

#define DEBUG_true        true
#define DEBUG_ENVIRONMENT false
#define DEBUG_CACHE       false
#define DEBUG_DATA        false
#define DEBUG_ENDIANNESS  false
#define DEBUG_QUEUE       false
#define DEBUG_RAMLOCK     false
#define DEBUG_SIM2OS      false
#define DEBUG_TTY         false

#define MSG_ENVIRONMENT "[ENVIRONMENT]"

#define __cout(component,str...)                                        \
  do									\
    {									\
      if (DEBUG_ ## component == true )                                 \
	{								\
          fprintf(stdout,str);						\
        }                                                               \
    }                                                                   \
  while(0)

#define __cerr(str...)                                                  \
  do									\
    {									\
      fprintf(stderr,str);						\
    } 								        \
  while(0)

#define cout(str...)                                                    \
  do									\
    {									\
      fprintf(stdout,"%s ",MSG_ENVIRONMENT);                            \
      __cout(true,str);                                                 \
      fflush (stdout);                                                  \
    } 								        \
  while(0)

#define cerr(str...)                                                    \
  do									\
    {									\
      fprintf(stderr,"%s ",MSG_ENVIRONMENT);                            \
      __cerr(str);                                                      \
      fflush (stderr);                                                  \
    } 								        \
  while(0)

#define _cout(component, str...)					\
  do									\
    {									\
      if (DEBUG_ ## component == true )                                 \
	{								\
          cout(str);                                                    \
	}								\
    } 								        \
  while(0)

#define _cerr(str...) cerr(str)

#endif
