#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_branch_target_buffer_branch_target_buffer_glue_Branch_Target_Buffer_Glue_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_branch_target_buffer_branch_target_buffer_glue_Branch_Target_Buffer_Glue_h

/*
 * $Id: Branch_Target_Buffer_Glue.h 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Glue/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_glue {


  class Branch_Target_Buffer_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_VAL                    ; //[nb_inst_predict]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_ACK                    ; //[nb_inst_predict]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_HIT                    ; //[nb_inst_predict]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_PREDICT_ADDRESS_SRC            ; //[nb_inst_predict]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_PREDICT_ADDRESS_DEST           ; //[nb_inst_predict]
  public    : SC_OUT(Tbranch_condition_t)  ** out_PREDICT_CONDITION              ; //[nb_inst_predict]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_LAST_TAKE              ; //[nb_inst_predict]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_IS_ACCURATE            ; //[nb_inst_predict]

  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_REGISTER_VAL           ; //[nb_inst_predict]
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_REGISTER_ACK           ; //[nb_inst_predict]
  public    : SC_IN (Tcontrol_t         ) ***  in_PREDICT_REGISTER_HIT           ; //[nb_inst_predict][associativity]
  public    : SC_IN (Tgeneral_data_t    ) ***  in_PREDICT_REGISTER_ADDRESS_SRC   ; //[nb_inst_predict][associativity]
  public    : SC_IN (Tgeneral_data_t    ) ***  in_PREDICT_REGISTER_ADDRESS_DEST  ; //[nb_inst_predict][associativity]
  public    : SC_IN (Tbranch_condition_t) ***  in_PREDICT_REGISTER_CONDITION     ; //[nb_inst_predict][associativity]
  public    : SC_IN (Tcontrol_t         ) ***  in_PREDICT_REGISTER_LAST_TAKE     ; //[nb_inst_predict][associativity]
  public    : SC_IN (Tcontrol_t         ) ***  in_PREDICT_REGISTER_IS_ACCURATE   ; //[nb_inst_predict][associativity]

  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_SORT_VAL               ; //[nb_inst_predict]
  public    : SC_IN (Tptr_t             )  **  in_PREDICT_SORT_INDEX             ; //[nb_inst_predict]

  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_VICTIM_VAL             ; //[nb_inst_predict]
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_VICTIM_ACK             ; //[nb_inst_predict]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_VICTIM_HIT             ; //[nb_inst_predict]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_PREDICT_VICTIM_ADDRESS         ; //[nb_inst_predict]
  public    : SC_OUT(Tptr_t             )  ** out_PREDICT_VICTIM_INDEX           ; //[nb_inst_predict]
  public    : SC_IN (Tptr_t             )  **  in_PREDICT_VICTIM_VICTIM          ; //[nb_inst_predict]

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_VAL                      ; //[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_ACK                      ; //[nb_inst_decod]
  public    : SC_IN (Tgeneral_data_t    )  **  in_DECOD_ADDRESS_SRC              ; //[nb_inst_decod]

  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_REGISTER_VAL             ; //[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_REGISTER_ACK             ; //[nb_inst_decod]

  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_VICTIM_VAL               ; //[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_VICTIM_ACK               ; //[nb_inst_decod]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_DECOD_VICTIM_ADDRESS           ; //[nb_inst_decod]

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_VAL                     ; //[nb_inst_update]
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_ACK                     ; //[nb_inst_update]
  public    : SC_IN (Tgeneral_data_t    )  **  in_UPDATE_ADDRESS_SRC             ; //[nb_inst_update]

  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_REGISTER_VAL            ; //[nb_inst_update]
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_REGISTER_ACK            ; //[nb_inst_update]

  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_VICTIM_VAL              ; //[nb_inst_update]
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_VICTIM_ACK              ; //[nb_inst_update]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_UPDATE_VICTIM_ADDRESS          ; //[nb_inst_update]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Branch_Target_Buffer_Glue);
#endif
  public  :          Branch_Target_Buffer_Glue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Branch_Target_Buffer_Glue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif
  public  : void        genMealy_predict          (void);
  public  : void        genMealy_decod            (void);
  public  : void        genMealy_update           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace branch_target_buffer_glue
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
