/*
 * $Id: Register_unit_deallocation.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/include/Register_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {


#undef  FUNCTION
#define FUNCTION "Register_unit::deallocation"
  void Register_unit::deallocation (void)
  {
    log_printf(FUNC,Register_unit,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        delete     in_CLOCK ;
        delete     in_NRESET;

        DELETE1_SIGNAL( in_GPR_READ_VAL           ,_param->_nb_gpr_read,1);
        DELETE1_SIGNAL(out_GPR_READ_ACK           ,_param->_nb_gpr_read,1);
        DELETE1_SIGNAL( in_GPR_READ_OOO_ENGINE_ID ,_param->_nb_gpr_read,_param->_size_ooo_engine_id);
        DELETE1_SIGNAL( in_GPR_READ_NUM_REG       ,_param->_nb_gpr_read,_param->_size_gpr_address);
        DELETE1_SIGNAL(out_GPR_READ_DATA          ,_param->_nb_gpr_read,_param->_size_general_data);
        DELETE1_SIGNAL(out_GPR_READ_DATA_VAL      ,_param->_nb_gpr_read,1);
        
        DELETE1_SIGNAL( in_GPR_WRITE_VAL          ,_param->_nb_gpr_write,1);
        DELETE1_SIGNAL(out_GPR_WRITE_ACK          ,_param->_nb_gpr_write,1);
        DELETE1_SIGNAL( in_GPR_WRITE_OOO_ENGINE_ID,_param->_nb_gpr_write,_param->_size_ooo_engine_id);
        DELETE1_SIGNAL( in_GPR_WRITE_NUM_REG      ,_param->_nb_gpr_write,_param->_size_gpr_address);
        DELETE1_SIGNAL( in_GPR_WRITE_DATA         ,_param->_nb_gpr_write,_param->_size_general_data);

        DELETE1_SIGNAL( in_SPR_READ_VAL           ,_param->_nb_spr_read,1);
        DELETE1_SIGNAL(out_SPR_READ_ACK           ,_param->_nb_spr_read,1);
        DELETE1_SIGNAL( in_SPR_READ_OOO_ENGINE_ID ,_param->_nb_spr_read,_param->_size_ooo_engine_id);
        DELETE1_SIGNAL( in_SPR_READ_NUM_REG       ,_param->_nb_spr_read,_param->_size_spr_address);
        DELETE1_SIGNAL(out_SPR_READ_DATA          ,_param->_nb_spr_read,_param->_size_special_data);
        DELETE1_SIGNAL(out_SPR_READ_DATA_VAL      ,_param->_nb_spr_read,1);
        
        DELETE1_SIGNAL( in_SPR_WRITE_VAL          ,_param->_nb_spr_write,1);
        DELETE1_SIGNAL(out_SPR_WRITE_ACK          ,_param->_nb_spr_write,1);
        DELETE1_SIGNAL( in_SPR_WRITE_OOO_ENGINE_ID,_param->_nb_spr_write,_param->_size_ooo_engine_id);
        DELETE1_SIGNAL( in_SPR_WRITE_NUM_REG      ,_param->_nb_spr_write,_param->_size_spr_address);
        DELETE1_SIGNAL( in_SPR_WRITE_DATA         ,_param->_nb_spr_write,_param->_size_special_data);
                
        DELETE2_SIGNAL( in_INSERT_ROB_VAL         ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1],1);
        DELETE2_SIGNAL(out_INSERT_ROB_ACK         ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1],1);
        DELETE2_SIGNAL( in_INSERT_ROB_RD_USE      ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1],1);
        DELETE2_SIGNAL( in_INSERT_ROB_RD_NUM_REG  ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1],_param->_size_gpr_address);
        DELETE2_SIGNAL( in_INSERT_ROB_RE_USE      ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1],1);
        DELETE2_SIGNAL( in_INSERT_ROB_RE_NUM_REG  ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1],_param->_size_spr_address);

//     delete []  in_RETIRE_ROB_VAL               ;
//     delete [] out_RETIRE_ROB_ACK               ;
//     delete []  in_RETIRE_ROB_RD_OLD_USE        ;
//     delete []  in_RETIRE_ROB_RD_OLD_NUM_REG    ;
//     delete []  in_RETIRE_ROB_RD_NEW_USE        ;
//     delete []  in_RETIRE_ROB_RD_NEW_NUM_REG    ;
//     delete []  in_RETIRE_ROB_RE_OLD_USE        ; 
//     delete []  in_RETIRE_ROB_RE_OLD_NUM_REG    ;
//     delete []  in_RETIRE_ROB_RE_NEW_USE        ;
//     delete []  in_RETIRE_ROB_RE_NEW_NUM_REG    ;
      }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
      {
    delete    component_gpr        [i];
    delete    component_gpr_status [i];
    delete    component_spr        [i];
    delete    component_spr_status [i];
      }
    delete [] component_gpr       ;
    delete [] component_gpr_status;
    delete [] component_spr       ;
    delete [] component_spr_status;
    delete    component_glue      ; 

    delete _component;

    log_printf(FUNC,Register_unit,FUNCTION,"End");
  };

}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
