/*
 * $Id: test.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/BitManipulation.h"

class request_t
{
public : Tcontext_t         context_id   ;
public : Tcontext_t         front_end_id ;
public : Tpacket_t          packet_id    ;
public : Tcontrol_t         commit_wen   ;
public : Tcontrol_t         spr_access   ;
public : Tcontrol_t         spr_wen      ;
public : Tcontrol_t         spr_ren      ;
public : Tcontrol_t         reexecute    ;
public : Ttype_t            type         ;
public : Toperation_t       operation    ;
public : Tgeneral_data_t    num_group    ;
public : Tgeneral_data_t    num_reg      ;
public : Tgeneral_data_t    address      ;
public : Tgeneral_data_t    data         ;
public : Tcontrol_t         write_rd     ;
public : Tgeneral_address_t num_reg_rd   ;
public : Tspecial_data_t    flags        ;
public : Texception_t       exception    ;
public : Tcontrol_t         no_sequence  ;
  
public : void init (morpheo::behavioural::core::multi_ooo_engine::ooo_engine::reexecute_unit::Parameters * _param, Tpacket_t _packet_id)
  {
    context_id   = range<Tcontext_t        >(rand(),_param->_size_context_id         );
    front_end_id = range<Tcontext_t        >(rand(),_param->_size_front_end_id       );
    packet_id    = _packet_id;
    num_group    = (rand()%2)?GROUP_DCACHE:GROUP_POWER_MANAGEMENT;
    num_reg      = packet_id;
    data         = range<Tgeneral_data_t   >(rand(),_param->_size_general_data       );
    num_reg_rd   = range<Tspecial_address_t>(rand(),_param->_size_special_register   );
    flags        = range<Tspecial_data_t   >(rand(),_param->_size_special_data       );

    switch (rand()%4)
      {
      case 0  : exception = EXCEPTION_ALU_SPR_ACCESS_MUST_WRITE; break;
      case 1  : exception = EXCEPTION_ALU_SPR_ACCESS_MUST_READ ; break;
      default : exception = EXCEPTION_NONE;
      }

    no_sequence  = rand()%2;

    address      = (num_group << 11)+num_reg;
    

    spr_wen      = (exception ==  EXCEPTION_ALU_SPR_ACCESS_MUST_WRITE);
    spr_ren      = (exception ==  EXCEPTION_ALU_SPR_ACCESS_MUST_READ );
    spr_access   = spr_wen or spr_ren;

    reexecute    = spr_ren or (spr_wen and ((num_group == GROUP_DCACHE) and 
					    ((num_reg == SPR_DCBPR) or
					     (num_reg == SPR_DCBFR) or
					     (num_reg == SPR_DCBIR) or
					     (num_reg == SPR_DCBLR))));

    commit_wen   = not reexecute;

    if (not spr_access)
      {
	write_rd  = 0;
	type      = TYPE_SHIFT;
	operation = OPERATION_SHIFT_L_SRA;
      }
    else
      if (spr_ren)
	{
	  write_rd  = 1;
	  type      = TYPE_ALU;
	  operation = OPERATION_ALU_L_OR;
	}
      else
	{
	  write_rd = 0;
	  type     = TYPE_MEMORY;
	  switch (num_reg)
	    {
	    case SPR_DCBPR : {operation = OPERATION_MEMORY_PREFETCH  ; break;}
	    case SPR_DCBFR : {operation = OPERATION_MEMORY_FLUSH     ; break;}
	    case SPR_DCBIR : {operation = OPERATION_MEMORY_INVALIDATE; break;}
	    case SPR_DCBLR : {operation = OPERATION_MEMORY_LOCK      ; break;}
	    default        : break;
	    }
	}

  }
};


void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::reexecute_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Reexecute_unit * _Reexecute_unit = new Reexecute_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  sc_signal<Tcontrol_t         > ***  in_EXECUTE_LOOP_VAL                     ;
  sc_signal<Tcontrol_t         > *** out_EXECUTE_LOOP_ACK                     ;
  sc_signal<Tcontext_t         > ***  in_EXECUTE_LOOP_CONTEXT_ID              ;
  sc_signal<Tcontext_t         > ***  in_EXECUTE_LOOP_FRONT_END_ID            ;
  sc_signal<Tpacket_t          > ***  in_EXECUTE_LOOP_PACKET_ID               ;
//sc_signal<Toperation_t       > ***  in_EXECUTE_LOOP_OPERATION               ;
//sc_signal<Ttype_t            > ***  in_EXECUTE_LOOP_TYPE                    ;
  sc_signal<Tspecial_data_t    > ***  in_EXECUTE_LOOP_FLAGS                   ;
  sc_signal<Texception_t       > ***  in_EXECUTE_LOOP_EXCEPTION               ;
  sc_signal<Tcontrol_t         > ***  in_EXECUTE_LOOP_NO_SEQUENCE             ;
  sc_signal<Tgeneral_data_t    > ***  in_EXECUTE_LOOP_ADDRESS                 ;
  sc_signal<Tgeneral_data_t    > ***  in_EXECUTE_LOOP_DATA                    ;

  sc_signal<Tcontrol_t         >  ** out_COMMIT_VAL                           ;
  sc_signal<Tcontrol_t         >  **  in_COMMIT_ACK                           ;
  sc_signal<Tcontrol_t         >  ** out_COMMIT_WEN                           ;
  sc_signal<Tcontext_t         >  ** out_COMMIT_CONTEXT_ID                    ;
  sc_signal<Tcontext_t         >  ** out_COMMIT_FRONT_END_ID                  ;
  sc_signal<Tpacket_t          >  ** out_COMMIT_PACKET_ID                     ;
//sc_signal<Toperation_t       >  ** out_COMMIT_OPERATION                     ;
//sc_signal<Ttype_t            >  ** out_COMMIT_TYPE                          ;
  sc_signal<Tspecial_data_t    >  ** out_COMMIT_FLAGS                         ;
  sc_signal<Texception_t       >  ** out_COMMIT_EXCEPTION                     ;
  sc_signal<Tcontrol_t         >  ** out_COMMIT_NO_SEQUENCE                   ;
  sc_signal<Tgeneral_data_t    >  ** out_COMMIT_ADDRESS                       ;
  sc_signal<Tgeneral_address_t >  **  in_COMMIT_NUM_REG_RD                    ;

  sc_signal<Tcontrol_t         >  ** out_SPR_VAL                              ;
  sc_signal<Tcontrol_t         >  **  in_SPR_ACK                              ;
  sc_signal<Tcontrol_t         >  ** out_SPR_WEN                              ;
  sc_signal<Tcontext_t         >  ** out_SPR_CONTEXT_ID                       ;
  sc_signal<Tcontext_t         >  ** out_SPR_FRONT_END_ID                     ;
  sc_signal<Tspr_address_t     >  ** out_SPR_NUM_GROUP                        ;
  sc_signal<Tspr_address_t     >  ** out_SPR_NUM_REG                          ;
  sc_signal<Tspr_t             >  ** out_SPR_WDATA                            ;
  sc_signal<Tspr_t             >  **  in_SPR_RDATA                            ;
  sc_signal<Tcontrol_t         >  **  in_SPR_INVALID                          ;

  sc_signal<Tcontrol_t         >  **  in_REEXECUTE_ROB_VAL                    ;
  sc_signal<Tcontrol_t         >  ** out_REEXECUTE_ROB_ACK                    ;
  sc_signal<Tcontext_t         >  **  in_REEXECUTE_ROB_CONTEXT_ID             ;
  sc_signal<Tcontext_t         >  **  in_REEXECUTE_ROB_FRONT_END_ID           ;
  sc_signal<Tpacket_t          >  **  in_REEXECUTE_ROB_PACKET_ID              ;
  sc_signal<Toperation_t       >  **  in_REEXECUTE_ROB_OPERATION              ;
  sc_signal<Ttype_t            >  **  in_REEXECUTE_ROB_TYPE                   ;
  sc_signal<Tlsq_ptr_t         >  **  in_REEXECUTE_ROB_STORE_QUEUE_PTR_WRITE  ;

  sc_signal<Tcontrol_t         >  ** out_REEXECUTE_VAL                        ;
  sc_signal<Tcontrol_t         >  **  in_REEXECUTE_ACK                        ;
  sc_signal<Tcontext_t         >  ** out_REEXECUTE_CONTEXT_ID                 ;
  sc_signal<Tcontext_t         >  ** out_REEXECUTE_FRONT_END_ID               ;
  sc_signal<Tpacket_t          >  ** out_REEXECUTE_PACKET_ID                  ;
  sc_signal<Toperation_t       >  ** out_REEXECUTE_OPERATION                  ;
  sc_signal<Ttype_t            >  ** out_REEXECUTE_TYPE                       ;
  sc_signal<Tlsq_ptr_t         >  ** out_REEXECUTE_STORE_QUEUE_PTR_WRITE      ;
  sc_signal<Tlsq_ptr_t         >  ** out_REEXECUTE_STORE_QUEUE_PTR_READ       ;
  sc_signal<Tcontrol_t         >  ** out_REEXECUTE_STORE_QUEUE_EMPTY          ;
  sc_signal<Tlsq_ptr_t         >  ** out_REEXECUTE_LOAD_QUEUE_PTR_WRITE       ;
  sc_signal<Tcontrol_t         >  ** out_REEXECUTE_HAS_IMMEDIAT               ;
  sc_signal<Tgeneral_data_t    >  ** out_REEXECUTE_IMMEDIAT                   ;
  sc_signal<Tcontrol_t         >  ** out_REEXECUTE_READ_RA                    ;
  sc_signal<Tgeneral_address_t >  ** out_REEXECUTE_NUM_REG_RA                 ;
  sc_signal<Tcontrol_t         >  ** out_REEXECUTE_READ_RB                    ;
  sc_signal<Tgeneral_address_t >  ** out_REEXECUTE_NUM_REG_RB                 ;
  sc_signal<Tcontrol_t         >  ** out_REEXECUTE_READ_RC                    ;
  sc_signal<Tspecial_address_t >  ** out_REEXECUTE_NUM_REG_RC                 ;
  sc_signal<Tcontrol_t         >  ** out_REEXECUTE_WRITE_RD                   ;
  sc_signal<Tgeneral_address_t >  ** out_REEXECUTE_NUM_REG_RD                 ;
  sc_signal<Tcontrol_t         >  ** out_REEXECUTE_WRITE_RE                   ;
  sc_signal<Tspecial_address_t >  ** out_REEXECUTE_NUM_REG_RE                 ;

  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_VAL                     ," in_EXECUTE_LOOP_VAL                   ",Tcontrol_t         ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL(out_EXECUTE_LOOP_ACK                     ,"out_EXECUTE_LOOP_ACK                   ",Tcontrol_t         ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_CONTEXT_ID              ," in_EXECUTE_LOOP_CONTEXT_ID            ",Tcontext_t         ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_FRONT_END_ID            ," in_EXECUTE_LOOP_FRONT_END_ID          ",Tcontext_t         ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_PACKET_ID               ," in_EXECUTE_LOOP_PACKET_ID             ",Tpacket_t          ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_OPERATION               ," in_EXECUTE_LOOP_OPERATION             ",Toperation_t       ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_TYPE                    ," in_EXECUTE_LOOP_TYPE                  ",Ttype_t            ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_FLAGS                   ," in_EXECUTE_LOOP_FLAGS                 ",Tspecial_data_t    ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_EXCEPTION               ," in_EXECUTE_LOOP_EXCEPTION             ",Texception_t       ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_NO_SEQUENCE             ," in_EXECUTE_LOOP_NO_SEQUENCE           ",Tcontrol_t         ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_ADDRESS                 ," in_EXECUTE_LOOP_ADDRESS               ",Tgeneral_data_t    ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_DATA                    ," in_EXECUTE_LOOP_DATA                  ",Tgeneral_data_t    ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);

  ALLOC1_SC_SIGNAL(out_COMMIT_VAL                           ,"out_COMMIT_VAL                         ",Tcontrol_t         ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL( in_COMMIT_ACK                           ," in_COMMIT_ACK                         ",Tcontrol_t         ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL(out_COMMIT_WEN                           ,"out_COMMIT_WEN                         ",Tcontrol_t         ,_param->_nb_inst_commit);
//ALLOC1_SC_SIGNAL(out_COMMIT_CONTEXT_ID                    ,"out_COMMIT_CONTEXT_ID                  ",Tcontext_t         ,_param->_nb_inst_commit);
//ALLOC1_SC_SIGNAL(out_COMMIT_FRONT_END_ID                  ,"out_COMMIT_FRONT_END_ID                ",Tcontext_t         ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL(out_COMMIT_PACKET_ID                     ,"out_COMMIT_PACKET_ID                   ",Tpacket_t          ,_param->_nb_inst_commit);
//ALLOC1_SC_SIGNAL(out_COMMIT_OPERATION                     ,"out_COMMIT_OPERATION                   ",Toperation_t       ,_param->_nb_inst_commit);
//ALLOC1_SC_SIGNAL(out_COMMIT_TYPE                          ,"out_COMMIT_TYPE                        ",Ttype_t            ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL(out_COMMIT_FLAGS                         ,"out_COMMIT_FLAGS                       ",Tspecial_data_t    ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL(out_COMMIT_EXCEPTION                     ,"out_COMMIT_EXCEPTION                   ",Texception_t       ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL(out_COMMIT_NO_SEQUENCE                   ,"out_COMMIT_NO_SEQUENCE                 ",Tcontrol_t         ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL(out_COMMIT_ADDRESS                       ,"out_COMMIT_ADDRESS                     ",Tgeneral_data_t    ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL( in_COMMIT_NUM_REG_RD                    ," in_COMMIT_NUM_REG_RD                  ",Tgeneral_address_t ,_param->_nb_inst_commit);

  ALLOC1_SC_SIGNAL(out_SPR_VAL                              ,"out_SPR_VAL                            ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_SPR_ACK                              ," in_SPR_ACK                            ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_SPR_WEN                              ,"out_SPR_WEN                            ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_SPR_CONTEXT_ID                       ,"out_SPR_CONTEXT_ID                     ",Tcontext_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_SPR_FRONT_END_ID                     ,"out_SPR_FRONT_END_ID                   ",Tcontext_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_SPR_NUM_GROUP                        ,"out_SPR_NUM_GROUP                      ",Tspr_address_t     ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_SPR_NUM_REG                          ,"out_SPR_NUM_REG                        ",Tspr_address_t     ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_SPR_WDATA                            ,"out_SPR_WDATA                          ",Tspr_t             ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_SPR_RDATA                            ," in_SPR_RDATA                          ",Tspr_t             ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_SPR_INVALID                          ," in_SPR_INVALID                        ",Tcontrol_t         ,_param->_nb_inst_reexecute);

  ALLOC1_SC_SIGNAL( in_REEXECUTE_ROB_VAL                    ," in_REEXECUTE_ROB_VAL                  ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_ROB_ACK                    ,"out_REEXECUTE_ROB_ACK                  ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_ROB_CONTEXT_ID             ," in_REEXECUTE_ROB_CONTEXT_ID           ",Tcontext_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_ROB_FRONT_END_ID           ," in_REEXECUTE_ROB_FRONT_END_ID         ",Tcontext_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_ROB_PACKET_ID              ," in_REEXECUTE_ROB_PACKET_ID            ",Tpacket_t          ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_ROB_OPERATION              ," in_REEXECUTE_ROB_OPERATION            ",Toperation_t       ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_ROB_TYPE                   ," in_REEXECUTE_ROB_TYPE                 ",Ttype_t            ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_ROB_STORE_QUEUE_PTR_WRITE  ," in_REEXECUTE_ROB_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t         ,_param->_nb_inst_reexecute);

  ALLOC1_SC_SIGNAL(out_REEXECUTE_VAL                        ,"out_REEXECUTE_VAL                      ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_ACK                        ," in_REEXECUTE_ACK                      ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_CONTEXT_ID                 ,"out_REEXECUTE_CONTEXT_ID               ",Tcontext_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_FRONT_END_ID               ,"out_REEXECUTE_FRONT_END_ID             ",Tcontext_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_PACKET_ID                  ,"out_REEXECUTE_PACKET_ID                ",Tpacket_t          ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_OPERATION                  ,"out_REEXECUTE_OPERATION                ",Toperation_t       ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_TYPE                       ,"out_REEXECUTE_TYPE                     ",Ttype_t            ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_STORE_QUEUE_PTR_WRITE      ,"out_REEXECUTE_STORE_QUEUE_PTR_WRITE    ",Tlsq_ptr_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_STORE_QUEUE_PTR_READ       ,"out_REEXECUTE_STORE_QUEUE_PTR_READ     ",Tlsq_ptr_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_STORE_QUEUE_EMPTY          ,"out_REEXECUTE_STORE_QUEUE_EMPTY        ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_LOAD_QUEUE_PTR_WRITE       ,"out_REEXECUTE_LOAD_QUEUE_PTR_WRITE     ",Tlsq_ptr_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_HAS_IMMEDIAT               ,"out_REEXECUTE_HAS_IMMEDIAT             ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_IMMEDIAT                   ,"out_REEXECUTE_IMMEDIAT                 ",Tgeneral_data_t    ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_READ_RA                    ,"out_REEXECUTE_READ_RA                  ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_NUM_REG_RA                 ,"out_REEXECUTE_NUM_REG_RA               ",Tgeneral_address_t ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_READ_RB                    ,"out_REEXECUTE_READ_RB                  ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_NUM_REG_RB                 ,"out_REEXECUTE_NUM_REG_RB               ",Tgeneral_address_t ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_READ_RC                    ,"out_REEXECUTE_READ_RC                  ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_NUM_REG_RC                 ,"out_REEXECUTE_NUM_REG_RC               ",Tspecial_address_t ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_WRITE_RD                   ,"out_REEXECUTE_WRITE_RD                 ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_NUM_REG_RD                 ,"out_REEXECUTE_NUM_REG_RD               ",Tgeneral_address_t ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_WRITE_RE                   ,"out_REEXECUTE_WRITE_RE                 ",Tcontrol_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_NUM_REG_RE                 ,"out_REEXECUTE_NUM_REG_RE               ",Tspecial_address_t ,_param->_nb_inst_reexecute);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Reexecute_unit.\n"),name.c_str());

  (*(_Reexecute_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Reexecute_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE2_SC_SIGNAL(_Reexecute_unit, in_EXECUTE_LOOP_VAL                     ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  INSTANCE2_SC_SIGNAL(_Reexecute_unit,out_EXECUTE_LOOP_ACK                     ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Reexecute_unit, in_EXECUTE_LOOP_CONTEXT_ID              ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_Reexecute_unit, in_EXECUTE_LOOP_FRONT_END_ID            ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  if (_param->_have_port_rob_ptr  )
  INSTANCE2_SC_SIGNAL(_Reexecute_unit, in_EXECUTE_LOOP_PACKET_ID               ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//INSTANCE2_SC_SIGNAL(_Reexecute_unit, in_EXECUTE_LOOP_OPERATION               ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//INSTANCE2_SC_SIGNAL(_Reexecute_unit, in_EXECUTE_LOOP_TYPE                    ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  INSTANCE2_SC_SIGNAL(_Reexecute_unit, in_EXECUTE_LOOP_FLAGS                   ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  INSTANCE2_SC_SIGNAL(_Reexecute_unit, in_EXECUTE_LOOP_EXCEPTION               ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  INSTANCE2_SC_SIGNAL(_Reexecute_unit, in_EXECUTE_LOOP_NO_SEQUENCE             ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  INSTANCE2_SC_SIGNAL(_Reexecute_unit, in_EXECUTE_LOOP_ADDRESS                 ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  INSTANCE2_SC_SIGNAL(_Reexecute_unit, in_EXECUTE_LOOP_DATA                    ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);

  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_COMMIT_VAL                           ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_COMMIT_ACK                           ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_COMMIT_WEN                           ,_param->_nb_inst_commit);
//if (_param->_have_port_context_id)
//INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_COMMIT_CONTEXT_ID                    ,_param->_nb_inst_commit);
//if (_param->_have_port_front_end_id)
//INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_COMMIT_FRONT_END_ID                  ,_param->_nb_inst_commit);
  if (_param->_have_port_rob_ptr  )
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_COMMIT_PACKET_ID                     ,_param->_nb_inst_commit);
//INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_COMMIT_OPERATION                     ,_param->_nb_inst_commit);
//INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_COMMIT_TYPE                          ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_COMMIT_FLAGS                         ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_COMMIT_EXCEPTION                     ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_COMMIT_NO_SEQUENCE                   ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_COMMIT_ADDRESS                       ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_COMMIT_NUM_REG_RD                    ,_param->_nb_inst_commit);

  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_SPR_VAL                              ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_SPR_ACK                              ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_SPR_WEN                              ,_param->_nb_inst_reexecute);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_SPR_CONTEXT_ID                       ,_param->_nb_inst_reexecute);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_SPR_FRONT_END_ID                     ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_SPR_NUM_GROUP                        ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_SPR_NUM_REG                          ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_SPR_WDATA                            ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_SPR_RDATA                            ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_SPR_INVALID                          ,_param->_nb_inst_reexecute);

  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_REEXECUTE_ROB_VAL                    ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_ROB_ACK                    ,_param->_nb_inst_reexecute);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_REEXECUTE_ROB_CONTEXT_ID             ,_param->_nb_inst_reexecute);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_REEXECUTE_ROB_FRONT_END_ID           ,_param->_nb_inst_reexecute);
  if (_param->_have_port_rob_ptr  )
  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_REEXECUTE_ROB_PACKET_ID              ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_REEXECUTE_ROB_OPERATION              ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_REEXECUTE_ROB_TYPE                   ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_REEXECUTE_ROB_STORE_QUEUE_PTR_WRITE  ,_param->_nb_inst_reexecute);

  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_VAL                        ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit, in_REEXECUTE_ACK                        ,_param->_nb_inst_reexecute);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_CONTEXT_ID                 ,_param->_nb_inst_reexecute);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_FRONT_END_ID               ,_param->_nb_inst_reexecute);
  if (_param->_have_port_rob_ptr  )
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_PACKET_ID                  ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_OPERATION                  ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_TYPE                       ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_STORE_QUEUE_PTR_WRITE      ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_STORE_QUEUE_PTR_READ       ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_STORE_QUEUE_EMPTY          ,_param->_nb_inst_reexecute);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_LOAD_QUEUE_PTR_WRITE       ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_HAS_IMMEDIAT               ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_IMMEDIAT                   ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_READ_RA                    ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_NUM_REG_RA                 ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_READ_RB                    ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_NUM_REG_RB                 ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_READ_RC                    ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_NUM_REG_RC                 ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_WRITE_RD                   ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_NUM_REG_RD                 ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_WRITE_RE                   ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Reexecute_unit,out_REEXECUTE_NUM_REG_RE                 ,_param->_nb_inst_reexecute);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_execute_loop = 75;
  const  int32_t percent_transaction_commit       = 75;
  const  int32_t percent_transaction_spr          = 75;
  const  int32_t percent_transaction_reexecute    = 75;


  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);
      
      uint32_t nb_request     = 1<<_param->_size_rob_ptr;
      uint32_t nb_request_in  = 0;
      uint32_t nb_request_out = 0;

      request_t request [nb_request];

      uint32_t tab_request_in  [_param->_nb_execute_loop][_param->_max_nb_inst_execute];
      bool     tab_request_out [nb_request];
      for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
	for (uint32_t j=0; j<_param->_nb_inst_execute [i]; ++j)
	  tab_request_in [i][j] = (nb_request_in < nb_request)?(nb_request_in++):nb_request;
      for (uint32_t i=0; i<nb_request; i++)
	{
	  tab_request_out [i] = true;
	  request [i].init(_param, i);
	}
      
      while (nb_request_out < nb_request)
	{
	  for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
	    for (uint32_t j=0; j<_param->_nb_inst_execute [i]; ++j)
	      {
		uint32_t x=tab_request_in [i][j];

		in_EXECUTE_LOOP_VAL          [i][j]->write(((rand()%100)<percent_transaction_execute_loop) and (x<nb_request));
		in_EXECUTE_LOOP_CONTEXT_ID   [i][j]->write(request[x].context_id  );
		in_EXECUTE_LOOP_FRONT_END_ID [i][j]->write(request[x].front_end_id);
		in_EXECUTE_LOOP_PACKET_ID    [i][j]->write(x);
	      //in_EXECUTE_LOOP_OPERATION    [i][j]->write(0);
	      //in_EXECUTE_LOOP_TYPE         [i][j]->write(0);
		in_EXECUTE_LOOP_FLAGS        [i][j]->write(request[x].flags       );
		in_EXECUTE_LOOP_EXCEPTION    [i][j]->write(request[x].exception   );
		in_EXECUTE_LOOP_NO_SEQUENCE  [i][j]->write(request[x].no_sequence );
		uint32_t num_group = request[x].num_group;
		uint32_t num_reg   = request[x].num_reg  ;
		in_EXECUTE_LOOP_ADDRESS      [i][j]->write((num_group << 11) | num_reg);
		in_EXECUTE_LOOP_DATA         [i][j]->write(request[x].data        );
	      }
	  
	  SC_START(0);
	  for (uint32_t i=0; i<_param->_nb_inst_commit; ++i)
	    {
	      in_COMMIT_ACK        [i]->write((rand()%100)<percent_transaction_commit);

	      Tpacket_t packet = (_param->_have_port_rob_ptr  )?PORT_READ(out_COMMIT_PACKET_ID [i]):0;
	      in_COMMIT_NUM_REG_RD [i]->write(request[packet].num_reg_rd);
	    }

	  for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
	    {
	      in_SPR_ACK     [i]->write((rand()%100)<percent_transaction_spr);
	      in_SPR_RDATA   [i]->write(~out_SPR_WDATA [i]->read());
	      in_SPR_INVALID [i]->write(0);
	    }

	  for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
	    in_REEXECUTE_ACK   [i]->write((rand()%100)<percent_transaction_reexecute);

	  SC_START(0);

	  for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
	    for (uint32_t j=0; j<_param->_nb_inst_execute [i]; ++j)
	      if (in_EXECUTE_LOOP_VAL [i][j]->read() and out_EXECUTE_LOOP_ACK [i][j]->read())
		{
		  LABEL("EXECUTE_LOOP [%d][%d] : Transaction accepted",i,j);
		  
		  tab_request_in [i][j] = (nb_request_in < nb_request)?(nb_request_in++):nb_request;
		}
	  
	  for (uint32_t i=0; i<_param->_nb_inst_commit; ++i)
	    if (out_COMMIT_VAL [i]->read() and in_COMMIT_ACK [i]->read())
		{
		  LABEL("COMMIT       [%d] : Transaction accepted",i);
		  
		  Tpacket_t packet = (_param->_have_port_rob_ptr  )?PORT_READ(out_COMMIT_PACKET_ID [i]):0;

		  LABEL(" * packet : %d",packet);

		  TEST(bool, tab_request_out [packet], true);

		  TEST(Tcontrol_t     ,out_COMMIT_WEN          [i]->read(),request[packet].commit_wen  );
// 		  if (_param->_have_port_context_id)
// 		  TEST(Tcontext_t     ,out_COMMIT_CONTEXT_ID   [i]->read(),request[packet].context_id  );
// 		  if (_param->_have_port_front_end_id)
// 		  TEST(Tcontext_t     ,out_COMMIT_FRONT_END_ID [i]->read(),request[packet].front_end_id);
// 		  TEST(Toperation_t   ,out_COMMIT_OPERATION    [i]->read(),request[packet].operation   );
// 		  TEST(Ttype_t        ,out_COMMIT_TYPE         [i]->read(),request[packet].type        );
		  TEST(Tspecial_data_t,out_COMMIT_FLAGS        [i]->read(),request[packet].flags       );
		  TEST(Texception_t   ,out_COMMIT_EXCEPTION    [i]->read(),request[packet].exception   );
		  TEST(Tcontrol_t     ,out_COMMIT_NO_SEQUENCE  [i]->read(),request[packet].no_sequence );
		  TEST(Tgeneral_data_t,out_COMMIT_ADDRESS      [i]->read(),request[packet].address     );

		  tab_request_out [packet] = false;
		  if (not request[packet].spr_access)
		    nb_request_out++;
		}
	  
	  for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
	    if (out_SPR_VAL[i]->read() and in_SPR_ACK[i]->read())
	      {
		LABEL("SPR          [%d] : Transaction accepted",i);
		
		Tspr_address_t num_reg = out_SPR_NUM_REG [i]->read();
		TEST(Tcontrol_t    ,out_SPR_WEN          [i]->read(), request[num_reg].spr_wen);
		if (_param->_have_port_context_id)
		TEST(Tcontext_t    ,out_SPR_CONTEXT_ID   [i]->read(), request[num_reg].context_id);
		if (_param->_have_port_front_end_id)
		TEST(Tcontext_t    ,out_SPR_FRONT_END_ID [i]->read(), request[num_reg].front_end_id);
		TEST(Tspr_address_t,out_SPR_NUM_GROUP    [i]->read(), request[num_reg].num_group);
		TEST(Tspr_t        ,out_SPR_WDATA        [i]->read(), request[num_reg].data);

		if (request[num_reg].spr_ren)
		  request[num_reg].data = ~request[num_reg].data;

		if (not request[num_reg].reexecute)
		  nb_request_out++;
	      }

	  for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
	    if (out_REEXECUTE_VAL[i]->read() and in_REEXECUTE_ACK[i]->read())
	      {
		LABEL("REEXECUTE    [%d] : Transaction accepted",i);

		Tpacket_t packet = (_param->_have_port_rob_ptr  )?PORT_READ(out_REEXECUTE_PACKET_ID [i]):0;
		
		LABEL(" * packet : %d",packet);
		TEST(Tcontrol_t        ,request [packet].reexecute, true);
		
		if (_param->_have_port_context_id)
		TEST(Tcontext_t        ,out_REEXECUTE_CONTEXT_ID            [i]->read(), request[packet].context_id  );
		if (_param->_have_port_front_end_id)
		TEST(Tcontext_t        ,out_REEXECUTE_FRONT_END_ID          [i]->read(), request[packet].front_end_id);
		TEST(Tgeneral_data_t   ,out_REEXECUTE_IMMEDIAT              [i]->read(), request[packet].data        );
		TEST(Tcontrol_t        ,out_REEXECUTE_WRITE_RD              [i]->read(), request[packet].write_rd    );
		TEST(Tgeneral_address_t,out_REEXECUTE_NUM_REG_RD            [i]->read(), request[packet].num_reg_rd  );

		TEST(Ttype_t           ,out_REEXECUTE_TYPE                  [i]->read(), request[packet].type        );
		TEST(Toperation_t      ,out_REEXECUTE_OPERATION             [i]->read(), request[packet].operation   );

		TEST(Tcontrol_t        ,out_REEXECUTE_HAS_IMMEDIAT          [i]->read(), 1);
		TEST(Tlsq_ptr_t        ,out_REEXECUTE_STORE_QUEUE_PTR_WRITE [i]->read(), 0);
		TEST(Tlsq_ptr_t        ,out_REEXECUTE_STORE_QUEUE_PTR_READ  [i]->read(), 0);
		TEST(Tlsq_ptr_t        ,out_REEXECUTE_STORE_QUEUE_EMPTY     [i]->read(), 0);
		TEST(Tlsq_ptr_t        ,out_REEXECUTE_LOAD_QUEUE_PTR_WRITE  [i]->read(), 0);
		TEST(Tcontrol_t        ,out_REEXECUTE_READ_RA               [i]->read(), 0);
		TEST(Tgeneral_address_t,out_REEXECUTE_NUM_REG_RA            [i]->read(), 0);
		TEST(Tcontrol_t        ,out_REEXECUTE_READ_RB               [i]->read(), 0);
		TEST(Tgeneral_address_t,out_REEXECUTE_NUM_REG_RB            [i]->read(), 0);
		TEST(Tcontrol_t        ,out_REEXECUTE_READ_RC               [i]->read(), 0);
		TEST(Tspecial_address_t,out_REEXECUTE_NUM_REG_RC            [i]->read(), 0);
		TEST(Tcontrol_t        ,out_REEXECUTE_WRITE_RE              [i]->read(), 0);
		TEST(Tspecial_address_t,out_REEXECUTE_NUM_REG_RE            [i]->read(), 0);

		nb_request_out++;
	      }

	  SC_START(1);
	}


      TEST(uint32_t, nb_request_in  ,nb_request);
      TEST(uint32_t, nb_request_out ,nb_request);

//       for (uint32_t i=0; i<nb_request; i++)
// 	TEST(bool,tab_request_out [i],false);

      SC_START(1);
    }
  
  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_VAL                     ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL(out_EXECUTE_LOOP_ACK                     ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_CONTEXT_ID              ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_FRONT_END_ID            ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_PACKET_ID               ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_OPERATION               ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_TYPE                    ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_FLAGS                   ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_EXCEPTION               ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_NO_SEQUENCE             ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_ADDRESS                 ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_DATA                    ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);

  DELETE1_SC_SIGNAL(out_COMMIT_VAL                           ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL( in_COMMIT_ACK                           ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL(out_COMMIT_WEN                           ,_param->_nb_inst_commit);
//DELETE1_SC_SIGNAL(out_COMMIT_CONTEXT_ID                    ,_param->_nb_inst_commit);
//DELETE1_SC_SIGNAL(out_COMMIT_FRONT_END_ID                  ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL(out_COMMIT_PACKET_ID                     ,_param->_nb_inst_commit);
//DELETE1_SC_SIGNAL(out_COMMIT_OPERATION                     ,_param->_nb_inst_commit);
//DELETE1_SC_SIGNAL(out_COMMIT_TYPE                          ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL(out_COMMIT_FLAGS                         ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL(out_COMMIT_EXCEPTION                     ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL(out_COMMIT_NO_SEQUENCE                   ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL(out_COMMIT_ADDRESS                       ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL( in_COMMIT_NUM_REG_RD                    ,_param->_nb_inst_commit);

  DELETE1_SC_SIGNAL(out_SPR_VAL                              ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_SPR_ACK                              ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_SPR_WEN                              ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_SPR_CONTEXT_ID                       ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_SPR_FRONT_END_ID                     ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_SPR_NUM_GROUP                        ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_SPR_NUM_REG                          ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_SPR_WDATA                            ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_SPR_RDATA                            ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_SPR_INVALID                          ,_param->_nb_inst_reexecute);

  DELETE1_SC_SIGNAL( in_REEXECUTE_ROB_VAL                    ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_ROB_ACK                    ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_ROB_CONTEXT_ID             ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_ROB_FRONT_END_ID           ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_ROB_PACKET_ID              ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_ROB_OPERATION              ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_ROB_TYPE                   ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_ROB_STORE_QUEUE_PTR_WRITE  ,_param->_nb_inst_reexecute);

  DELETE1_SC_SIGNAL(out_REEXECUTE_VAL                        ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_ACK                        ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_CONTEXT_ID                 ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_FRONT_END_ID               ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_PACKET_ID                  ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_OPERATION                  ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_TYPE                       ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_STORE_QUEUE_PTR_WRITE      ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_STORE_QUEUE_PTR_READ       ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_STORE_QUEUE_EMPTY          ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_LOAD_QUEUE_PTR_WRITE       ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_HAS_IMMEDIAT               ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_IMMEDIAT                   ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_READ_RA                    ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_NUM_REG_RA                 ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_READ_RB                    ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_NUM_REG_RB                 ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_READ_RC                    ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_NUM_REG_RC                 ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_WRITE_RD                   ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_NUM_REG_RD                 ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_WRITE_RE                   ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_NUM_REG_RE                 ,_param->_nb_inst_reexecute);
    }
#endif

  delete _Reexecute_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
