/*
 * $Id: Victim_deallocation.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Victim/include/Victim.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace victim {


#undef  FUNCTION
#define FUNCTION "Victim::deallocation"
  void Victim::deallocation (void)
  {
    log_printf(FUNC,Victim,FUNCTION,"Begin");

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    switch (_param->_victim_scheme)
      {
//    case VICTIM_RANDOM      : delete _component_victim_random     ; break;
//    case VICTIM_ROUND_ROBIN : delete _component_victim_round_robin; break;
//    case VICTIM_NLU         : delete _component_victim_nlu        ; break;
      case VICTIM_PSEUDO_LRU  : delete _component_victim_pseudo_lru ; break;
//    case VICTIM_LRU         : delete _component_victim_lru        ; break;
//    case VICTIM_FIFO        : delete _component_victim_fifo       ; break;
      default : break;
      }
    
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        for (uint32_t i=0; i<_param->_nb_access; ++i)
          {
	delete     in_ACCESS_VAL    [i];
	delete    out_ACCESS_ACK    [i];
	if (_param->_have_port_address)
	delete     in_ACCESS_ADDRESS[i];
	delete     in_ACCESS_HIT    [i];
	delete     in_ACCESS_ENTITY [i];
	delete    out_ACCESS_VICTIM [i];
          }

	delete []  in_ACCESS_VAL    ;
	delete [] out_ACCESS_ACK    ;
	if (_param->_have_port_address)
	delete []  in_ACCESS_ADDRESS;
	delete []  in_ACCESS_HIT    ;
	delete []  in_ACCESS_ENTITY ;
	delete [] out_ACCESS_VICTIM ;
      }

    log_printf(FUNC,Victim,FUNCTION,"End");
  };

}; // end namespace victim
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
