/*
 * $Id: Meta_Predictor_deallocation.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/include/Meta_Predictor.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {


#undef  FUNCTION
#define FUNCTION "Meta_Predictor::deallocation"
  void Meta_Predictor::deallocation (void)
  {
    log_begin(Meta_Predictor,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL( in_PREDICT_VAL          ,_param->_nb_inst_predict,1                    );
        DELETE1_SIGNAL(out_PREDICT_ACK          ,_param->_nb_inst_predict,1                    );
        DELETE1_SIGNAL( in_PREDICT_ADDRESS      ,_param->_nb_inst_predict,_param->_size_address);
        DELETE1_SIGNAL(out_PREDICT_DIRECTION    ,_param->_nb_inst_predict,1                    );
        DELETE1_SIGNAL(out_PREDICT_HISTORY      ,_param->_nb_inst_predict,_param->_size_history);
        
        DELETE1_SIGNAL( in_UPDATE_VAL           ,_param->_nb_inst_update,1                    );
        DELETE1_SIGNAL(out_UPDATE_ACK           ,_param->_nb_inst_update,1                    );
        DELETE1_SIGNAL( in_UPDATE_ADDRESS       ,_param->_nb_inst_update,_param->_size_address);
        DELETE1_SIGNAL( in_UPDATE_HISTORY       ,_param->_nb_inst_update,_param->_size_history);
        DELETE1_SIGNAL( in_UPDATE_HISTORY_VAL   ,_param->_nb_inst_update,1                    );
        DELETE1_SIGNAL( in_UPDATE_DIRECTION     ,_param->_nb_inst_update,1                    );
      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete    _component_glue;
    for (uint32_t i=0; i<_param->_nb_predictor; ++i)
    delete    _component_two_level_branch_predictor [i];
    delete [] _component_two_level_branch_predictor;

    delete _component;


    log_end(Meta_Predictor,FUNCTION);
  };

}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
