#ifdef SYSTEMC
/*
 * $Id: Issue_queue_function_in_order_transition.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Issue_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::function_in_order_transition"
  void Issue_queue::function_in_order_transition (void)
  {
    log_begin(Issue_queue,FUNCTION);
    log_function(Issue_queue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET) == 0)
      {
// 	_priority_in ->reset();
// 	_priority_out->reset();
// 	_priority_reg->reset();
	
	for (uint32_t i=0; i<_param->_nb_bank; i++)
	  _issue_queue [i].clear();

        reg_NUM_BANK_HEAD = 0;
        reg_NUM_BANK_TAIL = 0;
      }
    else
      {
// 	_priority_in ->transition();
// 	_priority_out->transition();
// 	_priority_reg->transition();

	// ===================================================================
	// =====[ ISSUE_IN ]==================================================
	// ===================================================================
        {
          for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
            for (uint32_t j=0; j<_param->_nb_inst_rename[i]; j++)
              if (PORT_READ(in_ISSUE_IN_VAL[i][j]) and internal_ISSUE_IN_ACK [i][j])
                {
                  uint32_t num_bank = reg_NUM_BANK_TAIL;
                  
                  log_printf(TRACE,Issue_queue,FUNCTION,"  * ISSUE_IN [%d][%d] - Transaction with bank [%d]",i,j,num_bank);
                      
#ifdef STATISTICS
                  if (usage_is_set(_usage,USE_STATISTICS))
                    (*_stat_nb_inst_issue_in [i]) ++;
#endif
                  entry_t * entry = new entry_t
                    (
                     (_param->_have_port_context_id    )?PORT_READ(in_ISSUE_IN_CONTEXT_ID            [i][j]):0,
                     (_param->_have_port_front_end_id  )?PORT_READ(in_ISSUE_IN_FRONT_END_ID          [i][j]):0,
                     (_param->_have_port_rob_ptr       )?PORT_READ(in_ISSUE_IN_PACKET_ID             [i][j]):0,
		                                         PORT_READ(in_ISSUE_IN_OPERATION             [i][j]),
		                                         PORT_READ(in_ISSUE_IN_TYPE                  [i][j]),
		                                         PORT_READ(in_ISSUE_IN_STORE_QUEUE_PTR_WRITE [i][j]),
		                                         PORT_READ(in_ISSUE_IN_STORE_QUEUE_PTR_READ  [i][j]),
		                                         PORT_READ(in_ISSUE_IN_STORE_QUEUE_EMPTY     [i][j]),
                     (_param->_have_port_load_queue_ptr)?PORT_READ(in_ISSUE_IN_LOAD_QUEUE_PTR_WRITE  [i][j]):0,
		                                         PORT_READ(in_ISSUE_IN_HAS_IMMEDIAT          [i][j]),
		                                         PORT_READ(in_ISSUE_IN_IMMEDIAT              [i][j]),
		                                         PORT_READ(in_ISSUE_IN_READ_RA               [i][j]),
		                                         PORT_READ(in_ISSUE_IN_NUM_REG_RA            [i][j]),
		                                         PORT_READ(in_ISSUE_IN_READ_RB               [i][j]),
		                                         PORT_READ(in_ISSUE_IN_NUM_REG_RB            [i][j]),
		                                         PORT_READ(in_ISSUE_IN_READ_RC               [i][j]),
		                                         PORT_READ(in_ISSUE_IN_NUM_REG_RC            [i][j]),
		                                         PORT_READ(in_ISSUE_IN_WRITE_RD              [i][j]),
		                                         PORT_READ(in_ISSUE_IN_NUM_REG_RD            [i][j]),
		                                         PORT_READ(in_ISSUE_IN_WRITE_RE              [i][j]),
		                                         PORT_READ(in_ISSUE_IN_NUM_REG_RE            [i][j])
                     );
                    
                  _issue_queue [num_bank].push_back(entry);
                  
                  // Update pointer
                  reg_NUM_BANK_TAIL = (reg_NUM_BANK_TAIL+1)%_param->_nb_bank;
                }
        }

	// ===================================================================
	// =====[ ISSUE_OUT ]=================================================
	// ===================================================================

        for (uint32_t i=0; i<_param->_nb_inst_issue; ++i)
          if (internal_ISSUE_OUT_VAL [i] and PORT_READ(in_ISSUE_OUT_ACK [i]))
            if (not internal_ISSUE_OUT_FROM_REEXECUTE [i])
              {
                entry_t * entry = internal_ISSUE_OUT_ENTRY    [i];
                
                // front ...
                uint32_t  num_bank = internal_ISSUE_OUT_NUM_BANK [i];
                
                log_printf(TRACE,Issue_queue,FUNCTION,"  * ISSUE_OUT [%d] - From issue_queue [%d]",i,num_bank);
                
                delete entry;
                
                _issue_queue [num_bank].remove(entry);

                reg_NUM_BANK_HEAD = (reg_NUM_BANK_HEAD+1)%_param->_nb_bank;
              } 

      }

    log_end(Issue_queue,FUNCTION);
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
