/*
 * $Id: Core_deallocation.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/include/Core.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {


#undef  FUNCTION
#define FUNCTION "Core::deallocation"
  void Core::deallocation (void)
  {
    log_begin(Core,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL(out_ICACHE_REQ_VAL         ,_param->_nb_icache_port,1);
        DELETE1_SIGNAL( in_ICACHE_REQ_ACK         ,_param->_nb_icache_port,1);
        DELETE1_SIGNAL(out_ICACHE_REQ_THREAD_ID   ,_param->_nb_icache_port,_param->_size_icache_thread_id);
        DELETE1_SIGNAL(out_ICACHE_REQ_PACKET_ID   ,_param->_nb_icache_port,_param->_size_icache_packet_id);
        DELETE1_SIGNAL(out_ICACHE_REQ_ADDRESS     ,_param->_nb_icache_port,_param->_size_icache_address);
        DELETE1_SIGNAL(out_ICACHE_REQ_TYPE        ,_param->_nb_icache_port,_param->_size_icache_type);
  
        DELETE1_SIGNAL( in_ICACHE_RSP_VAL         ,_param->_nb_icache_port,1);
        DELETE1_SIGNAL(out_ICACHE_RSP_ACK         ,_param->_nb_icache_port,1);
        DELETE1_SIGNAL( in_ICACHE_RSP_THREAD_ID   ,_param->_nb_icache_port,_param->_size_icache_thread_id);
        DELETE1_SIGNAL( in_ICACHE_RSP_PACKET_ID   ,_param->_nb_icache_port,_param->_size_icache_packet_id);
        DELETE1_SIGNAL( in_ICACHE_RSP_ERROR       ,_param->_nb_icache_port,_param->_size_icache_error);
        DELETE2_SIGNAL( in_ICACHE_RSP_INSTRUCTION ,_param->_nb_icache_port,_param->_icache_nb_instruction[it1],_param->_size_instruction);
  
        DELETE1_SIGNAL(out_DCACHE_REQ_VAL         ,_param->_nb_dcache_port,1);
        DELETE1_SIGNAL( in_DCACHE_REQ_ACK         ,_param->_nb_dcache_port,1);
        DELETE1_SIGNAL(out_DCACHE_REQ_THREAD_ID   ,_param->_nb_dcache_port,_param->_size_dcache_thread_id);
        DELETE1_SIGNAL(out_DCACHE_REQ_PACKET_ID   ,_param->_nb_dcache_port,_param->_size_dcache_packet_id);
        DELETE1_SIGNAL(out_DCACHE_REQ_ADDRESS     ,_param->_nb_dcache_port,_param->_size_dcache_address);
        DELETE1_SIGNAL(out_DCACHE_REQ_WDATA       ,_param->_nb_dcache_port,_param->_size_dcache_data);
        DELETE1_SIGNAL(out_DCACHE_REQ_TYPE        ,_param->_nb_dcache_port,_param->_size_dcache_type);
  
        DELETE1_SIGNAL( in_DCACHE_RSP_VAL         ,_param->_nb_dcache_port,1);
        DELETE1_SIGNAL(out_DCACHE_RSP_ACK         ,_param->_nb_dcache_port,1);
        DELETE1_SIGNAL( in_DCACHE_RSP_THREAD_ID   ,_param->_nb_dcache_port,_param->_size_dcache_thread_id);
        DELETE1_SIGNAL( in_DCACHE_RSP_PACKET_ID   ,_param->_nb_dcache_port,_param->_size_dcache_packet_id);
        DELETE1_SIGNAL( in_DCACHE_RSP_RDATA       ,_param->_nb_dcache_port,_param->_size_dcache_data);
        DELETE1_SIGNAL( in_DCACHE_RSP_ERROR       ,_param->_nb_dcache_port,_param->_size_dcache_error);
  
        DELETE1_SIGNAL( in_INTERRUPT_ENABLE       ,_param->_nb_thread,1);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    delete    _component_glue;
    delete    _component_dcache_access;
    delete    _component_icache_access;
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
    delete    _component_execute_loop [i];
    delete [] _component_execute_loop;
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
    delete    _component_ooo_engine [i];
    delete [] _component_ooo_engine;
    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
    delete    _component_front_end [i];
    delete [] _component_front_end;

    log_end(Core,FUNCTION);
  };

}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
