#ifndef morpheo_behavioural_Debug_signal_h
#define morpheo_behavioural_Debug_signal_h

/*
 * $Id: Debug_signal.h 129 2009-06-29 16:38:40Z rosiere $
 *
 * [ Description ]
 * 
 */

# ifdef DEBUG_SIGNAL

#include <set>
#include "Common/include/Message.h"

namespace morpheo {
namespace behavioural {

  extern std::set<void *> _debug_signal;
  
#  define DEBUG_SIGNAL_ADD(signal)                                      \
  do                                                                    \
    {                                                                   \
      morpheo::behavioural::_debug_signal.insert(static_cast<void *>( signal)); \
    } while(0)
  
#  define DEBUG_SIGNAL_ACCESS(signal)                                   \
  do                                                                    \
    {                                                                   \
      if (morpheo::behavioural::_debug_signal.find(static_cast<void *>(signal)) == morpheo::behavioural::_debug_signal.end()) \
        msgError("At file %s, in line %d, invalid signal.\n",__FILE__,__LINE__); \
    } while(0)
  
}; // end namespace behavioural          
}; // end namespace morpheo              
# else
#  define DEBUG_SIGNAL_ADD(signal)    do {} while (0)
#  define DEBUG_SIGNAL_ACCESS(signal) do {} while (0)
# endif


#endif
