#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_commit_unit_Commit_unit_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_commit_unit_Commit_unit_h

/*
 * $Id: Commit_unit.h 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Generic/Priority/include/Priority.h"

#include <iostream>
#include <fstream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace commit_unit {


  class Commit_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
  public    : counter_t                     ** _stat_nb_inst_insert               ;//[nb_rename_unit]
  public    : counter_t                     ** _stat_nb_inst_retire               ;//[nb_rename_unit]
  public    : counter_t                      * _stat_nb_inst_commit               ;
  public    : counter_t                      * _stat_nb_inst_commit_conflit_access;
  public    : counter_t                     ** _stat_nb_inst_retire_ok            ;//[nb_thread]
  public    : counter_t                     ** _stat_nb_inst_retire_ko            ;//[nb_thread]
  public    : counter_t                     ** _stat_nb_inst_type                 ;//[nb_type]
  public    : counter_t                     ** _stat_bank_nb_inst                 ;//[nb_bank]

  public    : counter_t                     ** _stat_nb_cycle_state_no_event      ;//[nb_thread]     
  public    : counter_t                     ** _stat_nb_cycle_state_not_yet_event ;//[nb_thread]
  public    : counter_t                     ** _stat_nb_cycle_state_event         ;//[nb_thread]
  public    : counter_t                     ** _stat_nb_cycle_state_wait_end      ;//[nb_thread]
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_VAL                       ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t         ) *** out_INSERT_ACK                       ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontext_t         ) ***  in_INSERT_FRONT_END_ID              ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontext_t         ) ***  in_INSERT_CONTEXT_ID                ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_OUT(Tpacket_t          ) *** out_INSERT_PACKET_ID                 ;//[nb_rename_unit][nb_inst_insert]
//public    : SC_IN (Tcontext_t         ) ***  in_INSERT_RENAME_UNIT_ID            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tdepth_t           ) ***  in_INSERT_DEPTH                     ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Ttype_t            ) ***  in_INSERT_TYPE                      ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Toperation_t       ) ***  in_INSERT_OPERATION                 ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_NO_EXECUTE                ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_LAST_EVENT                ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_IS_DELAY_SLOT             ;//[nb_rename_unit][nb_inst_insert]
#ifdef DEBUG
  public    : SC_IN (Taddress_t         ) ***  in_INSERT_ADDRESS                   ;//[nb_rename_unit][nb_inst_insert]
#endif
  public    : SC_IN (Taddress_t         ) ***  in_INSERT_ADDRESS_NEXT              ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Texception_t       ) ***  in_INSERT_EXCEPTION                 ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Texception_t       ) ***  in_INSERT_EXCEPTION_USE             ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tlsq_ptr_t         ) ***  in_INSERT_STORE_QUEUE_PTR_WRITE     ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tlsq_ptr_t         ) ***  in_INSERT_LOAD_QUEUE_PTR_WRITE      ;//[nb_rename_unit][nb_inst_insert]
#ifdef DEBUG
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_READ_RA                   ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t ) ***  in_INSERT_NUM_REG_RA_LOG            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t ) ***  in_INSERT_NUM_REG_RA_PHY            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_READ_RB                   ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t ) ***  in_INSERT_NUM_REG_RB_LOG            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t ) ***  in_INSERT_NUM_REG_RB_PHY            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_READ_RC                   ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tspecial_address_t ) ***  in_INSERT_NUM_REG_RC_LOG            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tspecial_address_t ) ***  in_INSERT_NUM_REG_RC_PHY            ;//[nb_rename_unit][nb_inst_insert]
#endif
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_WRITE_RD                  ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t ) ***  in_INSERT_NUM_REG_RD_LOG            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t ) ***  in_INSERT_NUM_REG_RD_PHY_OLD        ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t ) ***  in_INSERT_NUM_REG_RD_PHY_NEW        ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tcontrol_t         ) ***  in_INSERT_WRITE_RE                  ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tspecial_address_t ) ***  in_INSERT_NUM_REG_RE_LOG            ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tspecial_address_t ) ***  in_INSERT_NUM_REG_RE_PHY_OLD        ;//[nb_rename_unit][nb_inst_insert]
  public    : SC_IN (Tspecial_address_t ) ***  in_INSERT_NUM_REG_RE_PHY_NEW        ;//[nb_rename_unit][nb_inst_insert]
										   
    // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
  public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_VAL                       ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_IN (Tcontrol_t         ) ***  in_RETIRE_ACK                       ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tcontext_t         ) *** out_RETIRE_FRONT_END_ID              ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tcontext_t         ) *** out_RETIRE_CONTEXT_ID                ;//[nb_rename_unit][nb_inst_retire]
//public    : SC_OUT(Tcontext_t         ) *** out_RETIRE_RENAME_UNIT_ID            ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_USE_STORE_QUEUE           ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_USE_LOAD_QUEUE            ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tlsq_ptr_t         ) *** out_RETIRE_STORE_QUEUE_PTR_WRITE     ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tlsq_ptr_t         ) *** out_RETIRE_LOAD_QUEUE_PTR_WRITE      ;//[nb_rename_unit][nb_inst_retire]
//public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_READ_RA                   ;//[nb_rename_unit][nb_inst_retire]
//public    : SC_OUT(Tgeneral_address_t ) *** out_RETIRE_NUM_REG_RA_PHY            ;//[nb_rename_unit][nb_inst_retire]
//public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_READ_RB                   ;//[nb_rename_unit][nb_inst_retire]
//public    : SC_OUT(Tgeneral_address_t ) *** out_RETIRE_NUM_REG_RB_PHY            ;//[nb_rename_unit][nb_inst_retire]
//public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_READ_RC                   ;//[nb_rename_unit][nb_inst_retire]
//public    : SC_OUT(Tspecial_address_t ) *** out_RETIRE_NUM_REG_RC_PHY            ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_WRITE_RD                  ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tgeneral_address_t ) *** out_RETIRE_NUM_REG_RD_LOG            ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tgeneral_address_t ) *** out_RETIRE_NUM_REG_RD_PHY_OLD        ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tgeneral_address_t ) *** out_RETIRE_NUM_REG_RD_PHY_NEW        ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_WRITE_RE                  ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tspecial_address_t ) *** out_RETIRE_NUM_REG_RE_LOG            ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tspecial_address_t ) *** out_RETIRE_NUM_REG_RE_PHY_OLD        ;//[nb_rename_unit][nb_inst_retire]
  public    : SC_OUT(Tspecial_address_t ) *** out_RETIRE_NUM_REG_RE_PHY_NEW        ;//[nb_rename_unit][nb_inst_retire]

    // ~~~~~[ Interface : "commit" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
  public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_EVENT_VAL                 ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t         ) ***  in_RETIRE_EVENT_ACK                 ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tevent_state_t     ) *** out_RETIRE_EVENT_STATE               ;//[nb_front_end][nb_context]
//public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_EVENT_FLUSH               ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t         ) *** out_RETIRE_EVENT_STOP                ;//[nb_front_end][nb_context]
										   
    // ~~~~~[ Interface : "commit" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
  public    : SC_IN (Tcontrol_t         )  **  in_COMMIT_VAL                       ;//[nb_inst_commit]
  public    : SC_OUT(Tcontrol_t         )  ** out_COMMIT_ACK                       ;//[nb_inst_commit]
  public    : SC_IN (Tcontrol_t         )  **  in_COMMIT_WEN                       ;//[nb_inst_commit]
  public    : SC_IN (Tpacket_t          )  **  in_COMMIT_PACKET_ID                 ;//[nb_inst_commit]
//public    : SC_IN (Toperation_t       )  **  in_COMMIT_OPERATION                 ;//[nb_inst_commit]
//public    : SC_IN (Ttype_t            )  **  in_COMMIT_TYPE                      ;//[nb_inst_commit]
  public    : SC_IN (Tspecial_data_t    )  **  in_COMMIT_FLAGS                     ;//[nb_inst_commit]
  public    : SC_IN (Texception_t       )  **  in_COMMIT_EXCEPTION                 ;//[nb_inst_commit]
  public    : SC_IN (Tcontrol_t         )  **  in_COMMIT_NO_SEQUENCE               ;//[nb_inst_commit]
  public    : SC_IN (Taddress_t         )  **  in_COMMIT_ADDRESS                   ;//[nb_inst_commit]
  public    : SC_OUT(Tgeneral_address_t )  ** out_COMMIT_NUM_REG_RD                ;//[nb_inst_commit]
										   
    // ~~~~~[ Interface : "reexecute" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
  public    : SC_OUT(Tcontrol_t         )  ** out_REEXECUTE_VAL                    ;//[nb_inst_reexecute]
  public    : SC_IN (Tcontrol_t         )  **  in_REEXECUTE_ACK                    ;//[nb_inst_reexecute]
  public    : SC_OUT(Tcontext_t         )  ** out_REEXECUTE_CONTEXT_ID             ;//[nb_inst_reexecute]
  public    : SC_OUT(Tcontext_t         )  ** out_REEXECUTE_FRONT_END_ID           ;//[nb_inst_reexecute]
  public    : SC_OUT(Tpacket_t          )  ** out_REEXECUTE_PACKET_ID              ;//[nb_inst_reexecute]
  public    : SC_OUT(Toperation_t       )  ** out_REEXECUTE_OPERATION              ;//[nb_inst_reexecute]
  public    : SC_OUT(Ttype_t            )  ** out_REEXECUTE_TYPE                   ;//[nb_inst_reexecute]
  public    : SC_OUT(Tlsq_ptr_t         )  ** out_REEXECUTE_STORE_QUEUE_PTR_WRITE  ;//[nb_inst_reexecute]
    										   
    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
  public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_COMPLETE_VAL              ;//[nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_COMPLETE_ACK              ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tcontext_t         )  ** out_BRANCH_COMPLETE_CONTEXT_ID       ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tcontext_t         )  ** out_BRANCH_COMPLETE_FRONT_END_ID     ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tdepth_t           )  ** out_BRANCH_COMPLETE_DEPTH            ;//[nb_inst_branch_complete]
  public    : SC_OUT(Taddress_t         )  ** out_BRANCH_COMPLETE_ADDRESS          ;//[nb_inst_branch_complete]
//public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_COMPLETE_FLAG             ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_COMPLETE_NO_SEQUENCE      ;//[nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_COMPLETE_MISS_PREDICTION  ;//[nb_inst_branch_complete]
										   
    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )   * out_UPDATE_VAL                       ;
  public    : SC_IN (Tcontrol_t         )   *  in_UPDATE_ACK                       ;
  public    : SC_OUT(Tcontext_t         )   * out_UPDATE_CONTEXT_ID                ;
  public    : SC_OUT(Tcontext_t         )   * out_UPDATE_FRONT_END_ID              ;
  public    : SC_OUT(Tdepth_t           )   * out_UPDATE_DEPTH                     ;
  public    : SC_OUT(Tevent_type_t      )   * out_UPDATE_TYPE                      ;
  public    : SC_OUT(Tcontrol_t         )   * out_UPDATE_IS_DELAY_SLOT             ;
  public    : SC_OUT(Taddress_t         )   * out_UPDATE_ADDRESS                   ;
  public    : SC_OUT(Tcontrol_t         )   * out_UPDATE_ADDRESS_EPCR_VAL          ;
  public    : SC_OUT(Taddress_t         )   * out_UPDATE_ADDRESS_EPCR              ;
  public    : SC_OUT(Tcontrol_t         )   * out_UPDATE_ADDRESS_EEAR_VAL          ;
  public    : SC_OUT(Tgeneral_data_t    )   * out_UPDATE_ADDRESS_EEAR              ;

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_EVENT_VAL                        ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t        )  *** out_EVENT_ACK                        ;//[nb_front_end][nb_context]
  public    : SC_IN (Taddress_t        )  ***  in_EVENT_ADDRESS                    ;//[nb_front_end][nb_context]
  public    : SC_IN (Taddress_t        )  ***  in_EVENT_ADDRESS_NEXT               ;//[nb_front_end][nb_context] 
  public    : SC_IN (Tcontrol_t        )  ***  in_EVENT_ADDRESS_NEXT_VAL           ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t        )  ***  in_EVENT_IS_DS_TAKE                 ;//[nb_front_end][nb_context]

    // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
  public    : SC_OUT(Tcounter_t         ) *** out_NB_INST_COMMIT_ALL               ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcounter_t         ) *** out_NB_INST_COMMIT_MEM               ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcounter_t         ) ***  in_NB_INST_DECOD_ALL                ;//[nb_front_end][nb_context]
										   
    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
  public    : SC_IN (Tdepth_t           ) ***  in_DEPTH_MIN                        ;//[nb_front_end][nb_context]
  public    : SC_IN (Tdepth_t           ) ***  in_DEPTH_MAX                        ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t         ) ***  in_DEPTH_FULL                       ;//[nb_front_end][nb_context]

    // ~~~~~[ Interface : "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         ) ***  in_SPR_READ_SR_OVE                  ;//[nb_front_end][nb_context]

    // ~~~~~[ Interface : "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         ) *** out_SPR_WRITE_VAL                    ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t         ) ***  in_SPR_WRITE_ACK                    ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t         ) *** out_SPR_WRITE_SR_F_VAL               ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t         ) *** out_SPR_WRITE_SR_F                   ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t         ) *** out_SPR_WRITE_SR_CY_VAL              ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t         ) *** out_SPR_WRITE_SR_CY                  ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t         ) *** out_SPR_WRITE_SR_OV_VAL              ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t         ) *** out_SPR_WRITE_SR_OV                  ;//[nb_front_end][nb_context]

    // ~~~~~[ interface : "info" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#ifdef DEBUG_TEST
  public    : SC_OUT(bool               )   * out_INFO_ROB_EMPTY                   ;
#endif

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    	   
  private   : generic::priority::Priority   * _priority_insert                     ;
										   
    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    	   
  private   : double                       ** _nb_cycle_idle;

  private   : std::list<entry_t*>           * _rob                                 ;//[nb_bank]
										   
  private   : uint32_t                        reg_NUM_BANK_HEAD                    ;
  private   : uint32_t                        reg_NUM_BANK_TAIL                    ;
  private   : uint32_t                        reg_NUM_PTR_TAIL                     ;
  private   : uint32_t                      * reg_BANK_PTR                         ;//[nb_bank]

  private   : Tcounter_t                   ** reg_NB_INST_COMMIT_ALL               ;//[nb_front_end][nb_context]
  private   : Tcounter_t                   ** reg_NB_INST_COMMIT_MEM               ;//[nb_front_end][nb_context]

  private   : Tcommit_event_state_t        ** reg_EVENT_STATE                      ;//[nb_front_end][nb_context]
//private   : bool                         ** reg_EVENT_FLUSH                      ;//[nb_front_end][nb_context]
//private   : bool                         ** reg_EVENT_STOP                       ;//[nb_front_end][nb_context]
  private   : uint32_t                     ** reg_EVENT_NUM_BANK                   ;//[nb_front_end][nb_context]
  private   : uint32_t                     ** reg_EVENT_NUM_PTR                    ;//[nb_front_end][nb_context]
//private   : bool                         ** reg_EVENT_CAN_RESTART                ;//[nb_front_end][nb_context]
  private   : uint32_t                     ** reg_EVENT_PACKET                     ;//[nb_front_end][nb_context]
  private   : uint32_t                     ** reg_EVENT_NB_INST                    ;//[nb_front_end][nb_context]
  private   : bool                         ** reg_EVENT_LAST                       ;//[nb_front_end][nb_context]
  private   : uint32_t                     ** reg_EVENT_LAST_NUM_BANK              ;//[nb_front_end][nb_context]
  private   : uint32_t                     ** reg_EVENT_LAST_NUM_PTR               ;//[nb_front_end][nb_context]

  private   : bool                         ** reg_EVENT_NEXT_STOP                  ;//[nb_front_end][nb_context]
  private   : uint32_t                     ** reg_EVENT_NEXT_PACKET                ;//[nb_front_end][nb_context]

//private   : Taddress_t                   ** reg_PC_PREVIOUS                      ;//[nb_front_end][nb_context]
  private   : Taddress_t                   ** reg_PC_CURRENT                       ;//[nb_front_end][nb_context]
  private   : Taddress_t                   ** reg_PC_CURRENT_IS_DS                 ;//[nb_front_end][nb_context]
  private   : Taddress_t                   ** reg_PC_CURRENT_IS_DS_TAKE            ;//[nb_front_end][nb_context]
  private   : Taddress_t                   ** reg_PC_NEXT                          ;//[nb_front_end][nb_context]
										   
    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
  private   : Tcontrol_t                    * internal_BANK_INSERT_VAL             ;//[nb_bank]
  private   : uint32_t                      * internal_BANK_INSERT_NUM_RENAME_UNIT ;//[nb_bank]
  private   : uint32_t                      * internal_BANK_INSERT_NUM_INST        ;//[nb_bank]

#ifdef STATISTICS
  private   : uint32_t                        internal_BANK_COMMIT_CONFLIT_ACCESS  ;
#endif
  private   : Tcontrol_t                   ** internal_BANK_COMMIT_VAL             ;//[nb_bank][nb_bank_access_commit]
  private   : uint32_t                     ** internal_BANK_COMMIT_NUM_INST        ;//[nb_bank][nb_bank_access_commit]
  private   : entry_t *                    ** internal_BANK_COMMIT_ENTRY           ;//[nb_bank][nb_bank_access_commit]

  private   : uint32_t                        internal_BANK_RETIRE_HEAD            ;
  private   : Tcontrol_t                    * internal_BANK_RETIRE_VAL             ;//[nb_bank]
  private   : uint32_t                      * internal_BANK_RETIRE_NUM_RENAME_UNIT ;//[nb_bank]
  private   : uint32_t                      * internal_BANK_RETIRE_NUM_INST        ;//[nb_bank]

  private   : Tcontrol_t                    * internal_REEXECUTE_VAL               ;//[nb_inst_reexecute]
  private   : uint32_t                      * internal_REEXECUTE_NUM_BANK          ;//[nb_inst_reexecute]

  private   : Tcontrol_t                    * internal_BRANCH_COMPLETE_VAL         ;//[nb_inst_branch_complete]
  private   : uint32_t                      * internal_BRANCH_COMPLETE_NUM_BANK    ;//[nb_inst_branch_complete]

  private   : Tcontrol_t                      internal_UPDATE_VAL                  ;
  private   : uint32_t                        internal_UPDATE_NUM_BANK             ;

  private   : Tcontrol_t                   ** internal_EVENT_ACK                   ;//[nb_front_end][nb_context]

  private   : Tcontrol_t                   ** internal_RETIRE_EVENT_VAL            ;//[nb_front_end][nb_context]
#endif

#if defined(DEBUG) and defined(DEBUG_Commit_unit) and (DEBUG_Commit_unit == true)
  private   : std::ofstream                 * instruction_log_file;
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Commit_unit);
#endif
  public  :          Commit_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Commit_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        constant                  (void);
  public  : void        transition                (void);
  public  : void        genMoore                  (void);
  public  : void        genMealy_insert           (void);
  public  : void        genMealy_retire           (void);
  public  : void        genMealy_commit           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace commit_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
