/*
 * $Id: Front_end_Glue.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Front_end_Glue/include/Front_end_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace front_end_glue {


#undef  FUNCTION
#define FUNCTION "Front_end_Glue::Front_end_Glue"
  Front_end_Glue::Front_end_Glue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::front_end_glue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Front_end_Glue,FUNCTION);

    usage_environment(_usage);

// #if DEBUG_Front_end_Glue == true
//     log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
#ifdef SYSTEMCASS_SPECIFIC
        constant();
#else
	log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> : Method - constant"),_name.c_str());

	SC_METHOD (constant);
// 	dont_initialize ();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
#endif

	log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

// 	log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> : Method - genMoore"),_name.c_str());

// 	SC_METHOD (genMoore);
// 	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information
// # endif    

        if (_param->_have_port_context_id)
          {
	log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> : Method - genMealy_decod"),_name.c_str());

	SC_METHOD (genMealy_decod);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
        for (uint32_t i=0; i<_param->_nb_decod_unit; ++i)
          for (uint32_t j=0; j<_param->_nb_inst_decod[i]; ++j)
            sensitive << (*( in_DECOD_DECOD_UNIT_CONTEXT_ID [i][j]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
          }

	log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> : Method - genMealy_branch_complete"),_name.c_str());

	SC_METHOD (genMealy_branch_complete);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
        for (uint32_t i=0; i<_param->_nb_inst_branch_complete; ++i)
          sensitive << (*( in_BRANCH_COMPLETE_VAL                             [i]))
                    << (*( in_BRANCH_COMPLETE_PREDICTION_UNIT_ACK             [i]))
                    << (*( in_BRANCH_COMPLETE_PREDICTION_UNIT_MISS_PREDICTION [i]))
                    << (*( in_BRANCH_COMPLETE_CONTEXT_STATE_ACK               [i]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> : Method - genMealy_event"),_name.c_str());

	SC_METHOD (genMealy_event);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
        for (uint32_t i=0; i<_param->_nb_context; ++i)
          {
            sensitive << (*( in_EVENT_ACK                            [i]))
                      << (*( in_EVENT_IFETCH_UNIT_ACK                [i]))
                      << (*( in_EVENT_PREDICTION_UNIT_ACK            [i]))
                      << (*( in_EVENT_CONTEXT_STATE_VAL              [i]))
                      << (*( in_EVENT_CONTEXT_STATE_ADDRESS          [i]))
                      << (*( in_EVENT_CONTEXT_STATE_ADDRESS_NEXT     [i]))
                      << (*( in_EVENT_CONTEXT_STATE_ADDRESS_NEXT_VAL [i]))
                      << (*( in_EVENT_CONTEXT_STATE_IS_DS_TAKE       [i]))
                      << (*( in_EVENT_CONTEXT_STATE_TYPE             [i]))
                      << (*( in_EVENT_CONTEXT_STATE_FLUSH_ONLY       [i]))
              ;
            if (_param->_have_port_depth)
            sensitive << (*( in_EVENT_CONTEXT_STATE_DEPTH            [i]));
          }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif     

	log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> : Method - genMealy_depth"),_name.c_str());

	SC_METHOD (genMealy_depth);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
        for (uint32_t i=0; i<_param->_nb_context; ++i)
          {
            if (_param->_have_port_depth)
            sensitive << (*( in_DEPTH_PREDICTION_UNIT_CURRENT [i]))
                      << (*( in_DEPTH_PREDICTION_UNIT_MIN     [i])) 
                      << (*( in_DEPTH_PREDICTION_UNIT_MAX     [i]));

            sensitive << (*( in_DEPTH_PREDICTION_UNIT_VAL     [i]))
                      << (*( in_DEPTH_PREDICTION_UNIT_FULL    [i]));
          }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif     
      
	log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> : Method - genMealy_nb_inst"),_name.c_str());

	SC_METHOD (genMealy_nb_inst);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
        for (uint32_t i=0; i<_param->_nb_context; ++i)
            sensitive << (*( in_NB_INST_DECOD_UNIT_DECOD_ALL [i]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_end(Front_end_Glue,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Front_end_Glue::~Front_end_Glue"
  Front_end_Glue::~Front_end_Glue (void)
  {
    log_begin(Front_end_Glue,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Front_end_Glue,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Front_end_Glue,FUNCTION);
  };

}; // end namespace front_end_glue
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
