/*
 * $Id: Ifetch_unit_allocation.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/include/Ifetch_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {



#undef  FUNCTION
#define FUNCTION "Ifetch_unit::allocation"
  void Ifetch_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Ifetch_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Ifetch_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();
    
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface "icache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("icache_req",OUT, WEST, _("Instruction cache request."));

      ALLOC0_VALACK_OUT(out_ICACHE_REQ_VAL      ,VAL);
      ALLOC0_VALACK_IN ( in_ICACHE_REQ_ACK      ,ACK);
    //ALLOC0_SIGNAL_OUT(out_ICACHE_REQ_THREAD_ID,"thread_id",Tcontext_t           ,_param->_size_context_id );
      ALLOC0_SIGNAL_OUT(out_ICACHE_REQ_PACKET_ID,"packet_id",Tpacket_t            ,_param->_size_ifetch_queue_ptr  );
      ALLOC0_SIGNAL_OUT(out_ICACHE_REQ_ADDRESS  ,"address"  ,Ticache_instruction_t,_param->_size_instruction_address    );
      ALLOC0_SIGNAL_OUT(out_ICACHE_REQ_TYPE     ,"type"     ,Ticache_type_t       ,_param->_size_icache_type);

      ALLOC0_INTERFACE_END();
    }

    // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("icache_rsp",IN , WEST, _("Instruction cache respons."));

      ALLOC0_VALACK_IN  ( in_ICACHE_RSP_VAL        ,VAL);
      ALLOC0_VALACK_OUT (out_ICACHE_RSP_ACK        ,ACK);
    //ALLOC0_SIGNAL_IN  ( in_ICACHE_RSP_THREAD_ID  ,"thread_id"  ,Tcontext_t           ,_param->_size_context_id  );
      ALLOC0_SIGNAL_IN  ( in_ICACHE_RSP_PACKET_ID  ,"packet_id"  ,Tpacket_t            ,_param->_size_ifetch_queue_ptr   );
      ALLOC0_SIGNAL_IN  ( in_ICACHE_RSP_ERROR      ,"error"      ,Ticache_error_t      ,_param->_size_icache_error);

      ALLOC0_INTERFACE_END();
    }
    {
      ALLOC1_INTERFACE_BEGIN("icache_rsp",IN , WEST, _("Instruction cache respons."),_param->_nb_instruction);

      ALLOC1_SIGNAL_IN ( in_ICACHE_RSP_INSTRUCTION,"instruction",Ticache_instruction_t,_param->_size_instruction );

      ALLOC1_INTERFACE_END(_param->_nb_instruction);
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("predict",OUT, NORTH, _("Predict the next pc."));

      ALLOC0_VALACK_OUT (out_PREDICT_VAL                        ,VAL);
      ALLOC0_VALACK_IN  ( in_PREDICT_ACK                        ,ACK);
      ALLOC0_SIGNAL_OUT (out_PREDICT_PC_PREVIOUS                ,"pc_previous"                ,Tgeneral_address_t,_param->_size_instruction_address);
      ALLOC0_SIGNAL_OUT (out_PREDICT_PC_CURRENT                 ,"pc_current"                 ,Tgeneral_address_t,_param->_size_instruction_address);
      ALLOC0_SIGNAL_OUT (out_PREDICT_PC_CURRENT_IS_DS_TAKE      ,"pc_current_is_ds_take"      ,Tcontrol_t        ,1);
      ALLOC0_SIGNAL_IN  ( in_PREDICT_PC_NEXT                    ,"pc_next"                    ,Tgeneral_address_t,_param->_size_instruction_address);
      ALLOC0_SIGNAL_IN  ( in_PREDICT_PC_NEXT_IS_DS_TAKE         ,"pc_next_is_ds_take"         ,Tcontrol_t        ,1);
      ALLOC0_SIGNAL_IN  ( in_PREDICT_INST_IFETCH_PTR            ,"inst_ifetch_ptr"            ,Tinst_ifetch_ptr_t,_param->_size_inst_ifetch_ptr);
      ALLOC0_SIGNAL_IN  ( in_PREDICT_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t   ,_param->_size_branch_state);
      ALLOC0_SIGNAL_IN  ( in_PREDICT_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t ,_param->_size_depth);

      ALLOC0_INTERFACE_END();
    }
    {
      ALLOC1_INTERFACE_BEGIN("predict",IN , NORTH, _("Predict the next pc."),_param->_nb_instruction);

      ALLOC1_SIGNAL_IN ( in_PREDICT_INSTRUCTION_ENABLE         ,"instruction_enable"         ,Tcontrol_t        ,1);

      ALLOC1_INTERFACE_END(_param->_nb_instruction);
    }

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("decod",OUT , EAST, _("Send bundle to the decod unit."));

    //ALLOC0_SIGNAL_OUT (out_DECOD_CONTEXT_ID                 ,"context_id"                 ,Tcontext_t        ,_param->_size_context_id);
      ALLOC0_SIGNAL_OUT (out_DECOD_ADDRESS                    ,"address"                    ,Tgeneral_address_t,_param->_size_instruction_address);
      ALLOC0_SIGNAL_OUT (out_DECOD_INST_IFETCH_PTR            ,"inst_ifetch_ptr"            ,Tinst_ifetch_ptr_t,_param->_size_inst_ifetch_ptr);
      ALLOC0_SIGNAL_OUT (out_DECOD_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t   ,_param->_size_branch_state);
      ALLOC0_SIGNAL_OUT (out_DECOD_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t ,_param->_size_depth);
      ALLOC0_SIGNAL_OUT (out_DECOD_EXCEPTION                  ,"exception"                  ,Texception_t      ,_param->_size_exception_ifetch);

      ALLOC0_INTERFACE_END();
    }
    {
      ALLOC1_INTERFACE_BEGIN("decod",OUT , EAST, _("Send bundle to the decod unit."),_param->_nb_instruction);

      ALLOC1_VALACK_OUT(out_DECOD_VAL                        ,VAL);
      ALLOC1_VALACK_IN ( in_DECOD_ACK                        ,ACK);
      ALLOC1_SIGNAL_OUT(out_DECOD_INSTRUCTION                ,"instruction"                ,Tinstruction_t    ,_param->_size_instruction);

      ALLOC1_INTERFACE_END(_param->_nb_instruction);
    }

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("event",IN , NORTH, _("Event interface."));

      ALLOC0_VALACK_IN ( in_EVENT_VAL              ,VAL);
      ALLOC0_VALACK_OUT(out_EVENT_ACK              ,ACK);
      ALLOC0_SIGNAL_IN ( in_EVENT_ADDRESS          ,"address"         ,Tgeneral_address_t,_param->_size_instruction_address);
      ALLOC0_SIGNAL_IN ( in_EVENT_ADDRESS_NEXT     ,"address_next"    ,Tgeneral_address_t,_param->_size_instruction_address);
      ALLOC0_SIGNAL_IN ( in_EVENT_ADDRESS_NEXT_VAL ,"address_next_val",Tcontrol_t,1);
      ALLOC0_SIGNAL_IN ( in_EVENT_IS_DS_TAKE       ,"is_ds_take"      ,Tcontrol_t,1);
 
      ALLOC0_INTERFACE_END();
    }
    
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    std::string name;

    {
      name = _name+"_address_management";
      log_printf(INFO,Ifetch_unit,FUNCTION,_("Create   : %s"),name.c_str());
    
      _component_address_management = new morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::address_management::Address_management
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_address_management
	 ,_usage);

      _component->set_component (_component_address_management->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    {
      name = _name+"_ifetch_queue";
      log_printf(INFO,Ifetch_unit,FUNCTION,_("Create   : %s"),name.c_str());

      _component_ifetch_queue = new morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::Ifetch_queue
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_ifetch_queue
	 ,_usage);

      _component->set_component (_component_ifetch_queue->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }
    
    {
      name = _name+"_ifetch_unit_glue";
      log_printf(INFO,Ifetch_unit,FUNCTION,_("Create   : %s"),name.c_str());

      _component_ifetch_unit_glue = new morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_unit_glue::Ifetch_unit_Glue
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_ifetch_unit_glue
	 ,_usage);

      _component->set_component (_component_ifetch_unit_glue->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }
    
    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    std::string src,dest;

    // ===================================================================
    // =====[ address_management ]========================================
    // ===================================================================
    {
      src = _name+"_address_management";
      log_printf(INFO,Ifetch_unit,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      {
	dest = _name+"_ifetch_queue";

	for (uint32_t i=0; i<_param->_nb_instruction; i++)
	  {
#ifdef POSITION
	    _component->interface_map (src ,"address_"+toString(i),
				       dest,"address_"+toString(i));
#endif
	    COMPONENT_MAP(_component,src ,"out_ADDRESS_"+toString(i)+"_INSTRUCTION_ENABLE",
		                     dest, "in_ADDRESS_"+toString(i)+"_INSTRUCTION_ENABLE");
	  }

	if (_param->_have_port_inst_ifetch_ptr)
	COMPONENT_MAP(_component,src ,"out_ADDRESS_INST_IFETCH_PTR"            ,
		                 dest, "in_ADDRESS_INST_IFETCH_PTR"            );
	COMPONENT_MAP(_component,src ,"out_ADDRESS_BRANCH_STATE"               ,
		                 dest, "in_ADDRESS_BRANCH_STATE"               );
	if (_param->_have_port_depth)
	COMPONENT_MAP(_component,src ,"out_ADDRESS_BRANCH_UPDATE_PREDICTION_ID",
		                 dest, "in_ADDRESS_BRANCH_UPDATE_PREDICTION_ID");

	dest = _name+"_ifetch_unit_glue";

#ifdef POSITION
	_component->interface_map (src ,"address",
				   dest,"address");
#endif

	COMPONENT_MAP(_component,src ,"out_ADDRESS_VAL"           ,
		                 dest, "in_ICACHE_REQ_ADDRESS_VAL");
	COMPONENT_MAP(_component,src , "in_ADDRESS_ACK"           ,
		                 dest,"out_ICACHE_REQ_ADDRESS_ACK");
	COMPONENT_MAP(_component,src ,"out_ADDRESS_INSTRUCTION_ADDRESS",
		                 dest, "in_ICACHE_REQ_ADDRESS_ADDRESS");
      }

      {
	dest = _name;

#ifdef POSITION
	_component->interface_map (src ,"predict",
				   dest,"predict");
#endif

	for (uint32_t i=0; i<_param->_nb_instruction; i++)
	  {
#ifdef POSITION
	    _component->interface_map (src ,"predict_"+toString(i),
				       dest,"predict_"+toString(i));
#endif	    
	    PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_INSTRUCTION_ENABLE"         
		               ,dest, "in_PREDICT_"+toString(i)+"_INSTRUCTION_ENABLE"         );
	  }

	PORT_MAP(_component,src ,"out_PREDICT_VAL"                        
		           ,dest,"out_PREDICT_VAL"                        );
	PORT_MAP(_component,src , "in_PREDICT_ACK"                        
		           ,dest, "in_PREDICT_ACK"                        );
	PORT_MAP(_component,src ,"out_PREDICT_PC_PREVIOUS"                
		           ,dest,"out_PREDICT_PC_PREVIOUS"                );
	PORT_MAP(_component,src ,"out_PREDICT_PC_CURRENT"                 
		           ,dest,"out_PREDICT_PC_CURRENT"                 );
	PORT_MAP(_component,src ,"out_PREDICT_PC_CURRENT_IS_DS_TAKE"      
		           ,dest,"out_PREDICT_PC_CURRENT_IS_DS_TAKE"      );
	PORT_MAP(_component,src , "in_PREDICT_PC_NEXT"                    
		           ,dest, "in_PREDICT_PC_NEXT"                    );
	PORT_MAP(_component,src , "in_PREDICT_PC_NEXT_IS_DS_TAKE"         
		           ,dest, "in_PREDICT_PC_NEXT_IS_DS_TAKE"         );
	if (_param->_have_port_inst_ifetch_ptr)
	PORT_MAP(_component,src , "in_PREDICT_INST_IFETCH_PTR"            
		           ,dest, "in_PREDICT_INST_IFETCH_PTR"            );
	PORT_MAP(_component,src , "in_PREDICT_BRANCH_STATE"               
		           ,dest, "in_PREDICT_BRANCH_STATE"               );
	if (_param->_have_port_depth)
	PORT_MAP(_component,src , "in_PREDICT_BRANCH_UPDATE_PREDICTION_ID"
		           ,dest, "in_PREDICT_BRANCH_UPDATE_PREDICTION_ID");
      }

      {
	dest = _name+"_ifetch_unit_glue";
	
#ifdef POSITION
	_component->interface_map (src ,"event",
				   dest,"event");
	_component->interface_map (src ,"event",
				   _name,"event");
#endif

	COMPONENT_MAP(_component,src , "in_EVENT_VAL"    ,dest ,"out_EVENT_ADDRESS_VAL");
	COMPONENT_MAP(_component,src ,"out_EVENT_ACK"    ,dest , "in_EVENT_ADDRESS_ACK");


	dest = _name;
	PORT_MAP(_component,src , "in_EVENT_ADDRESS"         ,dest , "in_EVENT_ADDRESS"          );
	PORT_MAP(_component,src , "in_EVENT_ADDRESS_NEXT"    ,dest , "in_EVENT_ADDRESS_NEXT"     );
	PORT_MAP(_component,src , "in_EVENT_ADDRESS_NEXT_VAL",dest , "in_EVENT_ADDRESS_NEXT_VAL" );
	PORT_MAP(_component,src , "in_EVENT_IS_DS_TAKE"      ,dest , "in_EVENT_IS_DS_TAKE"       );
      }
    }

    // ===================================================================
    // =====[ ifetch_queue ]==============================================
    // ===================================================================
    {
      src = _name+"_ifetch_queue";
      log_printf(INFO,Ifetch_unit,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      {
	dest = _name;

#ifdef POSITION
	_component->interface_map (src ,"address",
				   dest,"address");
#endif

	if (_param->_have_port_ifetch_queue_ptr)
	PORT_MAP(_component,src ,"out_ADDRESS_IFETCH_QUEUE_ID"            ,
		            dest,"out_ICACHE_REQ_PACKET_ID"               );

	for (uint32_t i=0; i<_param->_nb_instruction; i++)
	  {
#ifdef POSITION
	    _component->interface_map (src                       ,"address_"+toString(i),
				       dest+"_address_management","address_"+toString(i));
#endif

	    //out_ADDRESS_INSTRUCTION_ENABLE - address_management
	  }

	dest = _name+"_ifetch_unit_glue";

	COMPONENT_MAP(_component,src , "in_ADDRESS_VAL"         ,
		                 dest,"out_ICACHE_REQ_QUEUE_VAL");
	COMPONENT_MAP(_component,src ,"out_ADDRESS_ACK"         ,
		                 dest, "in_ICACHE_REQ_QUEUE_ACK");
	COMPONENT_MAP(_component,src , "in_ADDRESS_INSTRUCTION_ADDRESS",
		                 dest,"out_ICACHE_REQ_QUEUE_ADDRESS");
	// in_ADDRESS_INST_IFETCH_PTR             - address_management
	// in_ADDRESS_BRANCH_STATE                - address_management
	// in_ADDRESS_BRANCH_UPDATE_PREDICTION_ID - address_management
      }

      {
	dest = _name;

#ifdef POSITION
	_component->interface_map (src ,"icache_rsp",
				   dest,"icache_rsp");
#endif

	for (uint32_t i=0; i<_param->_nb_instruction; i++)
	  {
#ifdef POSITION
	    _component->interface_map (src ,"icache_rsp_"+toString(i),
				       dest,"icache_rsp_"+toString(i));
#endif

	    PORT_MAP(_component,src ,"out_DECOD_"+toString(i)+"_VAL"                        ,
		                dest,"out_DECOD_"+toString(i)+"_VAL"                        );
	    PORT_MAP(_component,src , "in_DECOD_"+toString(i)+"_ACK"                        ,
		                dest, "in_DECOD_"+toString(i)+"_ACK"                        );
	    PORT_MAP(_component,src ,"out_DECOD_"+toString(i)+"_INSTRUCTION"                ,
		                dest,"out_DECOD_"+toString(i)+"_INSTRUCTION"                );
	  }

	PORT_MAP(_component,src ,"out_DECOD_ADDRESS"                    ,dest,"out_DECOD_ADDRESS"                    );
	if (_param->_have_port_inst_ifetch_ptr)
	PORT_MAP(_component,src ,"out_DECOD_INST_IFETCH_PTR"            ,dest,"out_DECOD_INST_IFETCH_PTR"            );
	PORT_MAP(_component,src ,"out_DECOD_BRANCH_STATE"               ,dest,"out_DECOD_BRANCH_STATE"               );
	if (_param->_have_port_depth)
	PORT_MAP(_component,src ,"out_DECOD_BRANCH_UPDATE_PREDICTION_ID",dest,"out_DECOD_BRANCH_UPDATE_PREDICTION_ID");
	PORT_MAP(_component,src ,"out_DECOD_EXCEPTION"                  ,dest,"out_DECOD_EXCEPTION"                  );
      }

      {
	dest = _name;

#ifdef POSITION
	_component->interface_map (src ,"icache_rsp",
				   dest,"icache_rsp");
#endif

	PORT_MAP(_component,src , "in_ICACHE_RSP_VAL"      ,dest, "in_ICACHE_RSP_VAL"      );
	PORT_MAP(_component,src ,"out_ICACHE_RSP_ACK"      ,dest,"out_ICACHE_RSP_ACK"      );
	if (_param->_have_port_ifetch_queue_ptr)
	PORT_MAP(_component,src , "in_ICACHE_RSP_PACKET_ID",dest, "in_ICACHE_RSP_PACKET_ID");
	PORT_MAP(_component,src , "in_ICACHE_RSP_ERROR"    ,dest, "in_ICACHE_RSP_ERROR"    );

	for (uint32_t i=0; i<_param->_nb_instruction; i++)
	  {
#ifdef POSITION
	    _component->interface_map (src ,"icache_rsp_"+toString(i),
				       dest,"icache_rsp_"+toString(i));
#endif
	    PORT_MAP(_component,src , "in_ICACHE_RSP_"+toString(i)+"_INSTRUCTION",
		                dest, "in_ICACHE_RSP_"+toString(i)+"_INSTRUCTION");
	  }
      }

      {
	dest = _name+"_ifetch_unit_glue";
	
#ifdef POSITION
	_component->interface_map (src ,"event_reset",
				   dest,"event");
#endif

	COMPONENT_MAP(_component,src , "in_EVENT_RESET_VAL",dest,"out_EVENT_QUEUE_VAL");
	COMPONENT_MAP(_component,src ,"out_EVENT_RESET_ACK",dest, "in_EVENT_QUEUE_ACK");
      }
    }

    // ===================================================================
    // =====[ ifetch_unit_glue ]==========================================
    // ===================================================================
    {
      src = _name+"_ifetch_unit_glue";
      log_printf(INFO,Ifetch_unit,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      {
	dest = _name;

#ifdef POSITION
	_component->interface_map (src ,"icache_req",
				   dest,"icache_req");
#endif
	
	PORT_MAP(_component,src ,"out_ICACHE_REQ_VAL"    ,dest,"out_ICACHE_REQ_VAL");
	PORT_MAP(_component,src , "in_ICACHE_REQ_ACK"    ,dest, "in_ICACHE_REQ_ACK");
	PORT_MAP(_component,src ,"out_ICACHE_REQ_TYPE"   ,dest,"out_ICACHE_REQ_TYPE");
	PORT_MAP(_component,src ,"out_ICACHE_REQ_ADDRESS",dest,"out_ICACHE_REQ_ADDRESS");

	// in_ICACHE_REQ_ADDRESS_VAL     - address_management
	//out_ICACHE_REQ_QUEUE_VAL       - ifetch_queue      
	//out_ICACHE_REQ_ADDRESS_ACK     - address_management
	// in_ICACHE_REQ_QUEUE_ACK       - ifetch_queue      
	// in_ICACHE_REQ_ADDRESS_ADDRESS - address_management
	//out_ICACHE_REQ_QUEUE_ADDRESS   - ifetch_queue      

      }

      {
	dest = _name;

#ifdef POSITION
	_component->interface_map (src ,"event",
				   dest,"event");
#endif

	PORT_MAP(_component,src , "in_EVENT_VAL"        ,dest                      , "in_EVENT_VAL"        );
	PORT_MAP(_component,src ,"out_EVENT_ACK"        ,dest                      ,"out_EVENT_ACK"        );

	//out_EVENT_ADDRESS_VAL - address_management
	//out_EVENT_QUEUE_VAL   - ifetch_queue      
	// in_EVENT_ADDRESS_ACK - address_management
	// in_EVENT_QUEUE_ACK   - ifetch_queue      
      }
    }

    // ~~~~~[ Others ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
#if DEBUG_Ifetch_unit == true
    _component->test_map();
#endif
    
#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Ifetch_unit,FUNCTION,"End");
  };

}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
