/*
 * $Id: RegisterFile_Monolithic.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

  RegisterFile_Monolithic::RegisterFile_Monolithic 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   std::string name        ,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics            * param_statistics,
#endif
   morpheo::behavioural::generic::registerfile::registerfile_monolithic::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name  (name),
    _param (param),
    _usage (usage)
  {
    log_printf(FUNC,RegisterFile_Monolithic,"RegisterFile_Monolithic","Begin");

// #if DEBUG_RegisterFile_Monolithic == true
//     log_printf(INFO,RegisterFile_Monolithic,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,RegisterFile_Monolithic,"RegisterFile_Monolithic","Allocation");
    allocation ();

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      statistics_declaration(param_statistics);
#endif

#ifdef VHDL
    // generate the vhdl
    if (usage_is_set(_usage,USE_VHDL))
      vhdl();
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {

# ifdef SYSTEMCASS_SPECIFIC
        constant();
#else
	SC_METHOD (constant);
// 	dont_initialize ();
#endif

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();

	SC_METHOD (genMealy_read);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg();
	for (uint32_t i=0; i<_param->_nb_port_read; i++)
	  {
	    sensitive << *(in_READ_VAL     [i]);
	    if (_param->_have_port_address)
	      sensitive << *(in_READ_ADDRESS [i]);
	  }
	for (uint32_t i=0; i<_param->_nb_port_read_write; i++)
	  {
	    sensitive << *(in_READ_WRITE_VAL     [i])
		      << *(in_READ_WRITE_RW      [i]);
	    if (_param->_have_port_address)
	      sensitive << *(in_READ_WRITE_ADDRESS [i]);
	  }
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_port_read; i++)
	  {
	    (*(out_READ_DATA  [i])) (*( in_READ_VAL     [i]));
	    if (_param->_have_port_address)
	      (*(out_READ_DATA  [i])) (*( in_READ_ADDRESS [i]));
	  }
	for (uint32_t i=0; i<_param->_nb_port_read_write; i++)
	  {  
	    (*(out_READ_WRITE_RDATA [i])) (*( in_READ_WRITE_VAL     [i]));
	    (*(out_READ_WRITE_RDATA [i])) (*( in_READ_WRITE_RW      [i]));
	    if (_param->_have_port_address)
	      (*(out_READ_WRITE_RDATA [i])) (*( in_READ_WRITE_ADDRESS [i]));
	  }
# endif    
      }
#endif
    
    log_printf(FUNC,RegisterFile_Monolithic,"RegisterFile_Monolithic","End");
  };
  
  RegisterFile_Monolithic::~RegisterFile_Monolithic (void)
  {
#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      delete _stat;
#endif

    deallocation ();
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
