#ifdef SYSTEMC
/*
 * $Id: Return_Address_Stack_constant.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack/include/Return_Address_Stack.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace return_address_stack {


#undef  FUNCTION
#define FUNCTION "Return_Address_Stack::constant"
  void Return_Address_Stack::constant (void)
  {
    log_begin(Return_Address_Stack,FUNCTION);
    log_function(Return_Address_Stack,FUNCTION,_name.c_str());

    	for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	  {
	    internal_PREDICT_ACK [i] = 1;
	    PORT_WRITE(out_PREDICT_ACK [i], internal_PREDICT_ACK [i]);
	  }
    	for (uint32_t i=0; i<_param->_nb_inst_decod  ; i++)
	  {
	    internal_DECOD_ACK   [i] = 1;
	    PORT_WRITE(out_DECOD_ACK   [i], internal_DECOD_ACK   [i]);
	  }
    	for (uint32_t i=0; i<_param->_nb_inst_update ; i++)
	  {
	    internal_UPDATE_ACK  [i] = 1;
	    PORT_WRITE(out_UPDATE_ACK  [i], internal_UPDATE_ACK  [i]);
	  }

    log_end(Return_Address_Stack,FUNCTION);
  };

}; // end namespace return_address_stack
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
