/*
 * $Id: test.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Front_end * _Front_end = new Front_end 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  sc_signal<Tcontrol_t           >  ** out_ICACHE_REQ_VAL                 ;
  sc_signal<Tcontrol_t           >  **  in_ICACHE_REQ_ACK                 ;
//sc_signal<Tcontext_t           >  ** out_ICACHE_REQ_THREAD_ID           ;
  sc_signal<Tpacket_t            >  ** out_ICACHE_REQ_PACKET_ID           ;
  sc_signal<Ticache_instruction_t>  ** out_ICACHE_REQ_ADDRESS             ;
  sc_signal<Ticache_type_t       >  ** out_ICACHE_REQ_TYPE                ;
  sc_signal<Tcontrol_t           >  **  in_ICACHE_RSP_VAL                 ;
  sc_signal<Tcontrol_t           >  ** out_ICACHE_RSP_ACK                 ;
//sc_signal<Tcontext_t           >  **  in_ICACHE_RSP_THREAD_ID           ;
  sc_signal<Tpacket_t            >  **  in_ICACHE_RSP_PACKET_ID           ;
  sc_signal<Ticache_instruction_t> ***  in_ICACHE_RSP_INSTRUCTION         ;
  sc_signal<Ticache_error_t      >  **  in_ICACHE_RSP_ERROR               ;
  sc_signal<Tcontrol_t           >  ** out_DECOD_VAL                      ;
  sc_signal<Tcontrol_t           >  **  in_DECOD_ACK                      ;
  sc_signal<Tcontext_t           >  ** out_DECOD_CONTEXT_ID               ;
  sc_signal<Tdepth_t             >  ** out_DECOD_DEPTH                    ;
  sc_signal<Ttype_t              >  ** out_DECOD_TYPE                     ;
  sc_signal<Toperation_t         >  ** out_DECOD_OPERATION                ;
  sc_signal<Tcontrol_t           >  ** out_DECOD_NO_EXECUTE               ;
  sc_signal<Tcontrol_t           >  ** out_DECOD_LAST_EVENT               ;
  sc_signal<Tcontrol_t           >  ** out_DECOD_IS_DELAY_SLOT            ;
  sc_signal<Tgeneral_data_t      >  ** out_DECOD_ADDRESS                  ;
  sc_signal<Tgeneral_data_t      >  ** out_DECOD_ADDRESS_NEXT             ;
  sc_signal<Tcontrol_t           >  ** out_DECOD_HAS_IMMEDIAT             ;
  sc_signal<Tgeneral_data_t      >  ** out_DECOD_IMMEDIAT                 ;
  sc_signal<Tcontrol_t           >  ** out_DECOD_READ_RA                  ;
  sc_signal<Tgeneral_address_t   >  ** out_DECOD_NUM_REG_RA               ;
  sc_signal<Tcontrol_t           >  ** out_DECOD_READ_RB                  ;
  sc_signal<Tgeneral_address_t   >  ** out_DECOD_NUM_REG_RB               ;
  sc_signal<Tcontrol_t           >  ** out_DECOD_READ_RC                  ;
  sc_signal<Tspecial_address_t   >  ** out_DECOD_NUM_REG_RC               ;
  sc_signal<Tcontrol_t           >  ** out_DECOD_WRITE_RD                 ;
  sc_signal<Tgeneral_address_t   >  ** out_DECOD_NUM_REG_RD               ;
  sc_signal<Tcontrol_t           >  ** out_DECOD_WRITE_RE                 ;
  sc_signal<Tspecial_address_t   >  ** out_DECOD_NUM_REG_RE               ;
  sc_signal<Texception_t         >  ** out_DECOD_EXCEPTION_USE            ;
  sc_signal<Texception_t         >  ** out_DECOD_EXCEPTION                ;
  sc_signal<Tcontrol_t           >  **  in_BRANCH_COMPLETE_VAL            ;
  sc_signal<Tcontrol_t           >  ** out_BRANCH_COMPLETE_ACK            ;
  sc_signal<Tcontext_t           >  **  in_BRANCH_COMPLETE_CONTEXT_ID     ;
  sc_signal<Tdepth_t             >  **  in_BRANCH_COMPLETE_DEPTH          ;
  sc_signal<Taddress_t           >  **  in_BRANCH_COMPLETE_ADDRESS        ;
  sc_signal<Tcontrol_t           >  **  in_BRANCH_COMPLETE_NO_SEQUENCE    ;
  sc_signal<Tcontrol_t           >  ** out_BRANCH_COMPLETE_MISS_PREDICTION;
  sc_signal<Tcontrol_t           >   *  in_COMMIT_EVENT_VAL               ;
  sc_signal<Tcontrol_t           >   * out_COMMIT_EVENT_ACK               ;
  sc_signal<Tcontext_t           >   *  in_COMMIT_EVENT_CONTEXT_ID        ;
  sc_signal<Tdepth_t             >   *  in_COMMIT_EVENT_DEPTH             ;
  sc_signal<Tevent_type_t        >   *  in_COMMIT_EVENT_TYPE              ;
  sc_signal<Tcontrol_t           >   *  in_COMMIT_EVENT_IS_DELAY_SLOT     ;
  sc_signal<Taddress_t           >   *  in_COMMIT_EVENT_ADDRESS           ;
  sc_signal<Tcontrol_t           >   *  in_COMMIT_EVENT_ADDRESS_EPCR_VAL  ;
  sc_signal<Taddress_t           >   *  in_COMMIT_EVENT_ADDRESS_EPCR      ;
  sc_signal<Tcontrol_t           >   *  in_COMMIT_EVENT_ADDRESS_EEAR_VAL  ;
  sc_signal<Tgeneral_data_t      >   *  in_COMMIT_EVENT_ADDRESS_EEAR      ;
  sc_signal<Tcontrol_t           >  ** out_EVENT_VAL                      ;
  sc_signal<Tcontrol_t           >  **  in_EVENT_ACK                      ;
  sc_signal<Taddress_t           >  ** out_EVENT_ADDRESS                  ;
  sc_signal<Taddress_t           >  ** out_EVENT_ADDRESS_NEXT             ;
  sc_signal<Tcontrol_t           >  ** out_EVENT_ADDRESS_NEXT_VAL         ;
  sc_signal<Tcontrol_t           >  ** out_EVENT_IS_DS_TAKE               ;
  sc_signal<Tcontrol_t           >  ** out_SPR_EVENT_VAL                  ;
  sc_signal<Tcontrol_t           >  **  in_SPR_EVENT_ACK                  ;
  sc_signal<Tspr_t               >  ** out_SPR_EVENT_EPCR                 ;
  sc_signal<Tcontrol_t           >  ** out_SPR_EVENT_EEAR_WEN             ;
  sc_signal<Tspr_t               >  ** out_SPR_EVENT_EEAR                 ;
  sc_signal<Tcontrol_t           >  ** out_SPR_EVENT_SR_DSX               ;
  sc_signal<Tcontrol_t           >  ** out_SPR_EVENT_SR_TO_ESR            ;
  sc_signal<Tcounter_t           >  **  in_NB_INST_COMMIT_ALL             ;
  sc_signal<Tcounter_t           >  **  in_NB_INST_COMMIT_MEM             ;
  sc_signal<Tcounter_t           >  ** out_NB_INST_DECOD_ALL              ;
  sc_signal<Tdepth_t             >  ** out_DEPTH_MIN                      ;
  sc_signal<Tdepth_t             >  ** out_DEPTH_MAX                      ;
  sc_signal<Tcontrol_t           >  ** out_DEPTH_FULL                     ;
  sc_signal<Tcontrol_t           >  **  in_SPR_SR_IEE                     ;
  sc_signal<Tcontrol_t           >  **  in_SPR_SR_EPH                     ;
  sc_signal<Tcontrol_t           >  **  in_INTERRUPT_ENABLE               ;

  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_VAL                 ,"out_ICACHE_REQ_VAL                 ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_ICACHE_REQ_ACK                 ," in_ICACHE_REQ_ACK                 ",Tcontrol_t           ,_param->_nb_context);
//ALLOC1_SC_SIGNAL(out_ICACHE_REQ_THREAD_ID           ,"out_ICACHE_REQ_THREAD_ID           ",Tcontext_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_PACKET_ID           ,"out_ICACHE_REQ_PACKET_ID           ",Tpacket_t            ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_ADDRESS             ,"out_ICACHE_REQ_ADDRESS             ",Ticache_instruction_t,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_TYPE                ,"out_ICACHE_REQ_TYPE                ",Ticache_type_t       ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_VAL                 ," in_ICACHE_RSP_VAL                 ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_ICACHE_RSP_ACK                 ,"out_ICACHE_RSP_ACK                 ",Tcontrol_t           ,_param->_nb_context);
//ALLOC1_SC_SIGNAL( in_ICACHE_RSP_THREAD_ID           ," in_ICACHE_RSP_THREAD_ID           ",Tcontext_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_PACKET_ID           ," in_ICACHE_RSP_PACKET_ID           ",Tpacket_t            ,_param->_nb_context);
  ALLOC2_SC_SIGNAL( in_ICACHE_RSP_INSTRUCTION         ," in_ICACHE_RSP_INSTRUCTION         ",Ticache_instruction_t,_param->_nb_context,_param->_nb_inst_fetch[it1]);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_ERROR               ," in_ICACHE_RSP_ERROR               ",Ticache_error_t      ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DECOD_VAL                      ,"out_DECOD_VAL                      ",Tcontrol_t           ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_ACK                      ," in_DECOD_ACK                      ",Tcontrol_t           ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_CONTEXT_ID               ,"out_DECOD_CONTEXT_ID               ",Tcontext_t           ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_DEPTH                    ,"out_DECOD_DEPTH                    ",Tdepth_t             ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_TYPE                     ,"out_DECOD_TYPE                     ",Ttype_t              ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_OPERATION                ,"out_DECOD_OPERATION                ",Toperation_t         ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NO_EXECUTE               ,"out_DECOD_NO_EXECUTE               ",Tcontrol_t           ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_LAST_EVENT               ,"out_DECOD_LAST_EVENT               ",Tcontrol_t           ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_IS_DELAY_SLOT            ,"out_DECOD_IS_DELAY_SLOT            ",Tcontrol_t           ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_ADDRESS                  ,"out_DECOD_ADDRESS                  ",Tgeneral_data_t      ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_ADDRESS_NEXT             ,"out_DECOD_ADDRESS_NEXT             ",Tgeneral_data_t      ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_HAS_IMMEDIAT             ,"out_DECOD_HAS_IMMEDIAT             ",Tcontrol_t           ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_IMMEDIAT                 ,"out_DECOD_IMMEDIAT                 ",Tgeneral_data_t      ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_READ_RA                  ,"out_DECOD_READ_RA                  ",Tcontrol_t           ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RA               ,"out_DECOD_NUM_REG_RA               ",Tgeneral_address_t   ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_READ_RB                  ,"out_DECOD_READ_RB                  ",Tcontrol_t           ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RB               ,"out_DECOD_NUM_REG_RB               ",Tgeneral_address_t   ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_READ_RC                  ,"out_DECOD_READ_RC                  ",Tcontrol_t           ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RC               ,"out_DECOD_NUM_REG_RC               ",Tspecial_address_t   ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_WRITE_RD                 ,"out_DECOD_WRITE_RD                 ",Tcontrol_t           ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RD               ,"out_DECOD_NUM_REG_RD               ",Tgeneral_address_t   ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_WRITE_RE                 ,"out_DECOD_WRITE_RE                 ",Tcontrol_t           ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_NUM_REG_RE               ,"out_DECOD_NUM_REG_RE               ",Tspecial_address_t   ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_EXCEPTION_USE            ,"out_DECOD_EXCEPTION_USE            ",Texception_t         ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_EXCEPTION                ,"out_DECOD_EXCEPTION                ",Texception_t         ,_param->_sum_inst_decod);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_VAL            ," in_BRANCH_COMPLETE_VAL            ",Tcontrol_t           ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ACK            ,"out_BRANCH_COMPLETE_ACK            ",Tcontrol_t           ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_ID     ," in_BRANCH_COMPLETE_CONTEXT_ID     ",Tcontext_t           ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_DEPTH          ," in_BRANCH_COMPLETE_DEPTH          ",Tdepth_t             ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_ADDRESS        ," in_BRANCH_COMPLETE_ADDRESS        ",Taddress_t           ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_NO_SEQUENCE    ," in_BRANCH_COMPLETE_NO_SEQUENCE    ",Tcontrol_t           ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_MISS_PREDICTION,"out_BRANCH_COMPLETE_MISS_PREDICTION",Tcontrol_t           ,_param->_nb_inst_branch_complete);
  ALLOC0_SC_SIGNAL( in_COMMIT_EVENT_VAL               ," in_COMMIT_EVENT_VAL               ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL(out_COMMIT_EVENT_ACK               ,"out_COMMIT_EVENT_ACK               ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL( in_COMMIT_EVENT_CONTEXT_ID        ," in_COMMIT_EVENT_CONTEXT_ID        ",Tcontext_t           );
  ALLOC0_SC_SIGNAL( in_COMMIT_EVENT_DEPTH             ," in_COMMIT_EVENT_DEPTH             ",Tdepth_t             );
  ALLOC0_SC_SIGNAL( in_COMMIT_EVENT_TYPE              ," in_COMMIT_EVENT_TYPE              ",Tevent_type_t        );
  ALLOC0_SC_SIGNAL( in_COMMIT_EVENT_IS_DELAY_SLOT     ," in_COMMIT_EVENT_IS_DELAY_SLOT     ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL( in_COMMIT_EVENT_ADDRESS           ," in_COMMIT_EVENT_ADDRESS           ",Taddress_t           );
  ALLOC0_SC_SIGNAL( in_COMMIT_EVENT_ADDRESS_EPCR_VAL  ," in_COMMIT_EVENT_ADDRESS_EPCR_VAL  ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL( in_COMMIT_EVENT_ADDRESS_EPCR      ," in_COMMIT_EVENT_ADDRESS_EPCR      ",Taddress_t           );
  ALLOC0_SC_SIGNAL( in_COMMIT_EVENT_ADDRESS_EEAR_VAL  ," in_COMMIT_EVENT_ADDRESS_EEAR_VAL  ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL( in_COMMIT_EVENT_ADDRESS_EEAR      ," in_COMMIT_EVENT_ADDRESS_EEAR      ",Tgeneral_data_t      );
  ALLOC1_SC_SIGNAL(out_EVENT_VAL                      ,"out_EVENT_VAL                      ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_EVENT_ACK                      ," in_EVENT_ACK                      ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_ADDRESS                  ,"out_EVENT_ADDRESS                  ",Taddress_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_ADDRESS_NEXT             ,"out_EVENT_ADDRESS_NEXT             ",Taddress_t           ,_param->_nb_context); 
  ALLOC1_SC_SIGNAL(out_EVENT_ADDRESS_NEXT_VAL         ,"out_EVENT_ADDRESS_NEXT_VAL         ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_EVENT_IS_DS_TAKE               ,"out_EVENT_IS_DS_TAKE               ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_SPR_EVENT_VAL                  ,"out_SPR_EVENT_VAL                  ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_SPR_EVENT_ACK                  ," in_SPR_EVENT_ACK                  ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_SPR_EVENT_EPCR                 ,"out_SPR_EVENT_EPCR                 ",Tspr_t               ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_SPR_EVENT_EEAR_WEN             ,"out_SPR_EVENT_EEAR_WEN             ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_SPR_EVENT_EEAR                 ,"out_SPR_EVENT_EEAR                 ",Tspr_t               ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_SPR_EVENT_SR_DSX               ,"out_SPR_EVENT_SR_DSX               ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_SPR_EVENT_SR_TO_ESR            ,"out_SPR_EVENT_SR_TO_ESR            ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_NB_INST_COMMIT_ALL             ," in_NB_INST_COMMIT_ALL             ",Tcounter_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_NB_INST_COMMIT_MEM             ," in_NB_INST_COMMIT_MEM             ",Tcounter_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_NB_INST_DECOD_ALL              ,"out_NB_INST_DECOD_ALL              ",Tcounter_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DEPTH_MIN                      ,"out_DEPTH_MIN                      ",Tdepth_t             ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DEPTH_MAX                      ,"out_DEPTH_MAX                      ",Tdepth_t             ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DEPTH_FULL                     ,"out_DEPTH_FULL                     ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_SPR_SR_IEE                     ," in_SPR_SR_IEE                     ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_SPR_SR_EPH                     ," in_SPR_SR_EPH                     ",Tcontrol_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_INTERRUPT_ENABLE               ," in_INTERRUPT_ENABLE               ",Tcontrol_t           ,_param->_nb_context);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Front_end.\n"),name.c_str());

  (*(_Front_end->in_CLOCK))        (*(in_CLOCK));
  (*(_Front_end->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Front_end,out_ICACHE_REQ_VAL                 ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end, in_ICACHE_REQ_ACK                 ,_param->_nb_context);
//INSTANCE1_SC_SIGNAL(_Front_end,out_ICACHE_REQ_THREAD_ID           ,_param->_nb_context);
  if (_param->_have_port_ifetch_queue_ptr)
  INSTANCE1_SC_SIGNAL(_Front_end,out_ICACHE_REQ_PACKET_ID           ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_ICACHE_REQ_ADDRESS             ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_ICACHE_REQ_TYPE                ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end, in_ICACHE_RSP_VAL                 ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_ICACHE_RSP_ACK                 ,_param->_nb_context);
//INSTANCE1_SC_SIGNAL(_Front_end, in_ICACHE_RSP_THREAD_ID           ,_param->_nb_context);
  if (_param->_have_port_ifetch_queue_ptr)
  INSTANCE1_SC_SIGNAL(_Front_end, in_ICACHE_RSP_PACKET_ID           ,_param->_nb_context);
  INSTANCE2_SC_SIGNAL(_Front_end, in_ICACHE_RSP_INSTRUCTION         ,_param->_nb_context,_param->_nb_inst_fetch[it1]);
  INSTANCE1_SC_SIGNAL(_Front_end, in_ICACHE_RSP_ERROR               ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_VAL                      ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end, in_DECOD_ACK                      ,_param->_sum_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_CONTEXT_ID               ,_param->_sum_inst_decod);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_DEPTH                    ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_TYPE                     ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_OPERATION                ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_NO_EXECUTE               ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_LAST_EVENT               ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_IS_DELAY_SLOT            ,_param->_sum_inst_decod);
#ifdef DEBUG
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_ADDRESS                  ,_param->_sum_inst_decod);
#endif
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_ADDRESS_NEXT             ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_HAS_IMMEDIAT             ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_IMMEDIAT                 ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_READ_RA                  ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_NUM_REG_RA               ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_READ_RB                  ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_NUM_REG_RB               ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_READ_RC                  ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_NUM_REG_RC               ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_WRITE_RD                 ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_NUM_REG_RD               ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_WRITE_RE                 ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_NUM_REG_RE               ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_EXCEPTION_USE            ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DECOD_EXCEPTION                ,_param->_sum_inst_decod);
  INSTANCE1_SC_SIGNAL(_Front_end, in_BRANCH_COMPLETE_VAL            ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Front_end,out_BRANCH_COMPLETE_ACK            ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Front_end, in_BRANCH_COMPLETE_CONTEXT_ID     ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Front_end, in_BRANCH_COMPLETE_DEPTH          ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Front_end, in_BRANCH_COMPLETE_ADDRESS        ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Front_end, in_BRANCH_COMPLETE_NO_SEQUENCE    ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Front_end,out_BRANCH_COMPLETE_MISS_PREDICTION,_param->_nb_inst_branch_complete);
  INSTANCE0_SC_SIGNAL(_Front_end, in_COMMIT_EVENT_VAL               );
  INSTANCE0_SC_SIGNAL(_Front_end,out_COMMIT_EVENT_ACK               );
  if (_param->_have_port_context_id)
  INSTANCE0_SC_SIGNAL(_Front_end, in_COMMIT_EVENT_CONTEXT_ID        );
  if (_param->_have_port_depth)
  INSTANCE0_SC_SIGNAL(_Front_end, in_COMMIT_EVENT_DEPTH             );
  INSTANCE0_SC_SIGNAL(_Front_end, in_COMMIT_EVENT_TYPE              );
  INSTANCE0_SC_SIGNAL(_Front_end, in_COMMIT_EVENT_IS_DELAY_SLOT     );
  INSTANCE0_SC_SIGNAL(_Front_end, in_COMMIT_EVENT_ADDRESS           );
  INSTANCE0_SC_SIGNAL(_Front_end, in_COMMIT_EVENT_ADDRESS_EPCR_VAL  );
  INSTANCE0_SC_SIGNAL(_Front_end, in_COMMIT_EVENT_ADDRESS_EPCR      );
  INSTANCE0_SC_SIGNAL(_Front_end, in_COMMIT_EVENT_ADDRESS_EEAR_VAL  );
  INSTANCE0_SC_SIGNAL(_Front_end, in_COMMIT_EVENT_ADDRESS_EEAR      );
  INSTANCE1_SC_SIGNAL(_Front_end,out_EVENT_VAL                      ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end, in_EVENT_ACK                      ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_EVENT_ADDRESS                  ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_EVENT_ADDRESS_NEXT             ,_param->_nb_context); 
  INSTANCE1_SC_SIGNAL(_Front_end,out_EVENT_ADDRESS_NEXT_VAL         ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_EVENT_IS_DS_TAKE               ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_SPR_EVENT_VAL                  ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end, in_SPR_EVENT_ACK                  ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_SPR_EVENT_EPCR                 ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_SPR_EVENT_EEAR_WEN             ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_SPR_EVENT_EEAR                 ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_SPR_EVENT_SR_DSX               ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_SPR_EVENT_SR_TO_ESR            ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end, in_NB_INST_COMMIT_ALL             ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end, in_NB_INST_COMMIT_MEM             ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_NB_INST_DECOD_ALL              ,_param->_nb_context);
  if (_param->_have_port_depth)
    {
  INSTANCE1_SC_SIGNAL(_Front_end,out_DEPTH_MIN                      ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end,out_DEPTH_MAX                      ,_param->_nb_context);
    }
  INSTANCE1_SC_SIGNAL(_Front_end,out_DEPTH_FULL                     ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end, in_SPR_SR_IEE                     ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end, in_SPR_SR_EPH                     ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Front_end, in_INTERRUPT_ENABLE               ,_param->_nb_context);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

//   for (uint32_t i=0; i<_param->_nb_context; ++i)
//     {
//       in_ICACHE_REQ_ACK     [i]->write(0);
//       in_ICACHE_RSP_VAL     [i]->write(0);
//       in_EVENT_ACK          [i]->write(0);
//       in_SPR_EVENT_ACK      [i]->write(0);
//       in_NB_INST_COMMIT_ALL [i]->write(0); // no inst
//       in_NB_INST_COMMIT_MEM [i]->write(0); // no inst
//       in_SPR_SR_IEE         [i]->write(0); // interrupt disable
//       in_SPR_SR_EPH         [i]->write(0); // exception msb = 0
//       in_INTERRUPT_ENABLE   [i]->write(0); // no interrupt
//     }
//   for (uint32_t i=0; i<_param->_sum_inst_decod; ++i)
//     in_DECOD_ACK [i]->write(0);
//   for (uint32_t i=0; i<_param->_nb_inst_branch_complete; ++i)
//     in_BRANCH_COMPLETE_VAL [i]->write(0);
//   in_COMMIT_EVENT_VAL->write(0);


//   for (uint32_t i=0; i<_param->_nb_context; ++i)
//     {
//       TEST(Tcontrol_t,out_ICACHE_REQ_VAL      [i]->read(),0);
//       TEST(Tcontrol_t,out_ICACHE_RSP_ACK      [i]->read(),1); // Can accept a respons
//       TEST(Tcontrol_t,out_EVENT_VAL           [i]->read(),0); 
//       TEST(Tcontrol_t,out_SPR_EVENT_VAL       [i]->read(),0);
//       TEST(Tdepth_t  ,out_DEPTH_MIN           [i]->read(),0); // no branch speculated
//       TEST(Tdepth_t  ,out_DEPTH_MAX           [i]->read(),0); // no branch speculated
//       TEST(Tdepth_t  ,out_DEPTH_FULL          [i]->read(),0); // no branch speculated
//     }
//   for (uint32_t i=0; i<_param->_sum_inst_decod; ++i)
//   TEST(Tcontrol_t,out_DECOD_VAL           [i]->read(),0);
//   for (uint32_t i=0; i<_param->_nb_inst_branch_complete; ++i)
//   TEST(Tcontrol_t,out_BRANCH_COMPLETE_ACK [i]->read(),0); // can't accept (interactive)
//   TEST(Tcontrol_t,out_COMMIT_EVENT_ACK       ->read(),1); // can accept

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration< NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL(out_ICACHE_REQ_VAL                 ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_ICACHE_REQ_ACK                 ,_param->_nb_context);
//DELETE1_SC_SIGNAL(out_ICACHE_REQ_THREAD_ID           ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_PACKET_ID           ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_ADDRESS             ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_TYPE                ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_VAL                 ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_ICACHE_RSP_ACK                 ,_param->_nb_context);
//DELETE1_SC_SIGNAL( in_ICACHE_RSP_THREAD_ID           ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_PACKET_ID           ,_param->_nb_context);
  DELETE2_SC_SIGNAL( in_ICACHE_RSP_INSTRUCTION         ,_param->_nb_context,_param->_nb_inst_fetch[it1]);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_ERROR               ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_DECOD_VAL                      ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL( in_DECOD_ACK                      ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_CONTEXT_ID               ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_DEPTH                    ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_TYPE                     ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_OPERATION                ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NO_EXECUTE               ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_LAST_EVENT               ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_IS_DELAY_SLOT            ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_ADDRESS                  ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_ADDRESS_NEXT             ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_HAS_IMMEDIAT             ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_IMMEDIAT                 ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_READ_RA                  ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RA               ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_READ_RB                  ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RB               ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_READ_RC                  ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RC               ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_WRITE_RD                 ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RD               ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_WRITE_RE                 ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_NUM_REG_RE               ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_EXCEPTION_USE            ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL(out_DECOD_EXCEPTION                ,_param->_sum_inst_decod);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_VAL            ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_ACK            ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_ID     ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_DEPTH          ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_ADDRESS        ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_NO_SEQUENCE    ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_MISS_PREDICTION,_param->_nb_inst_branch_complete);
  DELETE0_SC_SIGNAL( in_COMMIT_EVENT_VAL               );
  DELETE0_SC_SIGNAL(out_COMMIT_EVENT_ACK               );
  DELETE0_SC_SIGNAL( in_COMMIT_EVENT_CONTEXT_ID        );
  DELETE0_SC_SIGNAL( in_COMMIT_EVENT_DEPTH             );
  DELETE0_SC_SIGNAL( in_COMMIT_EVENT_TYPE              );
  DELETE0_SC_SIGNAL( in_COMMIT_EVENT_IS_DELAY_SLOT     );
  DELETE0_SC_SIGNAL( in_COMMIT_EVENT_ADDRESS           );
  DELETE0_SC_SIGNAL( in_COMMIT_EVENT_ADDRESS_EPCR_VAL  );
  DELETE0_SC_SIGNAL( in_COMMIT_EVENT_ADDRESS_EPCR      );
  DELETE0_SC_SIGNAL( in_COMMIT_EVENT_ADDRESS_EEAR_VAL  );
  DELETE0_SC_SIGNAL( in_COMMIT_EVENT_ADDRESS_EEAR      );
  DELETE1_SC_SIGNAL(out_EVENT_VAL                      ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_EVENT_ACK                      ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_ADDRESS                  ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_ADDRESS_NEXT             ,_param->_nb_context); 
  DELETE1_SC_SIGNAL(out_EVENT_ADDRESS_NEXT_VAL         ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_EVENT_IS_DS_TAKE               ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_SPR_EVENT_VAL                  ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_SPR_EVENT_ACK                  ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_SPR_EVENT_EPCR                 ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_SPR_EVENT_EEAR_WEN             ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_SPR_EVENT_EEAR                 ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_SPR_EVENT_SR_DSX               ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_SPR_EVENT_SR_TO_ESR            ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_NB_INST_COMMIT_ALL             ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_NB_INST_COMMIT_MEM             ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_NB_INST_DECOD_ALL              ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_DEPTH_MIN                      ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_DEPTH_MAX                      ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_DEPTH_FULL                     ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_SPR_SR_IEE                     ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_SPR_SR_EPH                     ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_INTERRUPT_ENABLE               ,_param->_nb_context);
    }
#endif

  delete _Front_end;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
