#ifndef Morpheo_systemc_h
#define Morpheo_systemc_h

/*
 * $Id: Systemc.h 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 * Macro / function to test
 */

#ifdef SYSTEMC
#include <systemc.h>

namespace morpheo {

  // Modelsim to sc_start
#ifdef MTI_SYSTEMC
# define TIME_PERIOD 10.
#else
# define TIME_PERIOD 1.
#endif

# ifndef TIME_UNIT_PREFIX
#  ifdef MTI_SYSTEMC
#   define TIME_UNIT_PREFIX
#  else
#   define TIME_UNIT_PREFIX sc_core::
#  endif
# endif
# define TIME_UNIT TIME_UNIT_PREFIX SC_NS

# define VHDL_TIME_PERIOD TIME_PERIOD
# define VHDL_TIME_UNIT               "ns"
// #endif

#ifdef MTI_SYSTEMC
#  define simulation_run(x) do{ if (x>0) wait(TIME_PERIOD*x,TIME_UNIT); else for (int i=0; i<1000; ++i) wait(SC_ZERO_TIME); } while(0)
#else
# ifdef SYSTEMCASS_SPECIFIC
#  define simulation_run(x) do{ sc_time t (x,TIME_UNIT); sc_start(t); } while(0)
# else // systemc
#  define simulation_run(x) do{ if(x==0) {sc_start(SC_ZERO_TIME);} else {sc_time t (x,TIME_UNIT); sc_start(t);}} while(0)
# endif
#endif

#define simulation_cycle() sc_simulation_time()/TIME_PERIOD
// #define simulation_cycle() sc_time_stamp()/TIME_PERIOD
};
#endif
#endif

