/*
 * $Id: Register_unit_Glue.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/Register_unit_Glue/include/Register_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {
namespace register_unit_glue {


#undef  FUNCTION
#define FUNCTION "Register_unit_Glue::Register_unit_Glue"
  Register_unit_Glue::Register_unit_Glue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   std::string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::register_unit_glue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Register_unit_Glue,FUNCTION,"Begin");

// #if DEBUG_Register_unit_Glue == true
//     log_printf(INFO,Register_unit_Glue,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Allocation");
    allocation ();

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
        log_printf(INFO,Register_unit_Glue,FUNCTION,"Allocation of statistics");
        
        // Allocation of statistics
        statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
        // generate the vhdl
        log_printf(INFO,Register_unit_Glue,FUNCTION,"Generate the vhdl");
        
        vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
#ifdef SYSTEMCASS_SPECIFIC
        constant();
#else
    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - constant");

    SC_METHOD (constant);
//     dont_initialize ();

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    
#endif

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - transition");

    SC_METHOD (transition);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).pos();

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_gpr_read");

    SC_METHOD (genMealy_gpr_read);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t j=0; j<_param->_nb_gpr_read; j++)
      {
	if (_param->_have_port_ooo_engine_id == true)
	  sensitive << *(in_GPR_READ_OOO_ENGINE_ID [j]);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  sensitive << *(in_GPR_READ_REGISTERFILE_ACK  [i][j])
		    << *(in_GPR_READ_REGISTERFILE_DATA [i][j])
		    << *(in_GPR_READ_STATUS_ACK        [i][j])
		    << *(in_GPR_READ_STATUS_DATA_VAL   [i][j]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t j=0; j<_param->_nb_gpr_read; j++)
      {
	if (_param->_have_port_ooo_engine_id == true)
	  {
	    (*(out_GPR_READ_ACK                  [j])) (*( in_GPR_READ_OOO_ENGINE_ID        [j]));
	    (*(out_GPR_READ_DATA_VAL             [j])) (*( in_GPR_READ_OOO_ENGINE_ID        [j]));
	    (*(out_GPR_READ_DATA                 [j])) (*( in_GPR_READ_OOO_ENGINE_ID        [j]));
	  }
	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    (*(out_GPR_READ_ACK                  [j])) (*( in_GPR_READ_REGISTERFILE_ACK  [i][j]));
	    (*(out_GPR_READ_ACK                  [j])) (*( in_GPR_READ_STATUS_ACK        [i][j]));
	    (*(out_GPR_READ_DATA                 [j])) (*( in_GPR_READ_REGISTERFILE_DATA [i][j]));
	    (*(out_GPR_READ_DATA_VAL             [j])) (*( in_GPR_READ_STATUS_DATA_VAL   [i][j]));	
	  }
      }
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_gpr_read_status");

    SC_METHOD (genMealy_gpr_read_status);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t j=0; j<_param->_nb_gpr_read; j++)
      {
	sensitive << *(in_GPR_READ_VAL           [j]);
	if (_param->_have_port_ooo_engine_id == true)
	  sensitive << *(in_GPR_READ_OOO_ENGINE_ID [j]);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  sensitive << *(in_GPR_READ_REGISTERFILE_ACK  [i][j]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t j=0; j<_param->_nb_gpr_read; j++)
      {
	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    (*(out_GPR_READ_STATUS_VAL        [i][j])) (*( in_GPR_READ_VAL                  [j]));
	    (*(out_GPR_READ_STATUS_VAL        [i][j])) (*( in_GPR_READ_REGISTERFILE_ACK  [i][j]));
	    if (_param->_have_port_ooo_engine_id == true)
	    (*(out_GPR_READ_STATUS_VAL        [i][j])) (*( in_GPR_READ_OOO_ENGINE_ID        [j]));
	  }
      }
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_gpr_read_registerfile");

    SC_METHOD (genMealy_gpr_read_registerfile);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t j=0; j<_param->_nb_gpr_read; j++)
      {
	sensitive << *(in_GPR_READ_VAL           [j]);
	if (_param->_have_port_ooo_engine_id == true)
	  sensitive << *(in_GPR_READ_OOO_ENGINE_ID [j]);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  sensitive << *(in_GPR_READ_STATUS_ACK        [i][j]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t j=0; j<_param->_nb_gpr_read; j++)
      {
	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    (*(out_GPR_READ_REGISTERFILE_VAL  [i][j])) (*( in_GPR_READ_VAL                  [j]));
	    (*(out_GPR_READ_REGISTERFILE_VAL  [i][j])) (*( in_GPR_READ_STATUS_ACK        [i][j]));
	    if (_param->_have_port_ooo_engine_id == true)
	    (*(out_GPR_READ_REGISTERFILE_VAL  [i][j])) (*( in_GPR_READ_OOO_ENGINE_ID        [j]));
	  }
      }
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_gpr_write");

    SC_METHOD (genMealy_gpr_write);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t j=0; j<_param->_nb_gpr_write; j++)
      {
	if (_param->_have_port_ooo_engine_id == true)
	  sensitive << *(in_GPR_WRITE_OOO_ENGINE_ID [j]);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  sensitive << *(in_GPR_WRITE_REGISTERFILE_ACK  [i][j])
		    << *(in_GPR_WRITE_STATUS_ACK        [i][j]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t j=0; j<_param->_nb_gpr_write; j++)
      {
	if (_param->_have_port_ooo_engine_id == true)
	(*(out_GPR_WRITE_ACK                  [j])) (*( in_GPR_WRITE_OOO_ENGINE_ID        [j]));
		    
	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    (*(out_GPR_WRITE_ACK                  [j])) (*( in_GPR_WRITE_REGISTERFILE_ACK  [i][j]));
	    (*(out_GPR_WRITE_ACK                  [j])) (*( in_GPR_WRITE_STATUS_ACK        [i][j]));
	  }
      }
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_gpr_write_status");

    SC_METHOD (genMealy_gpr_write_status);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t j=0; j<_param->_nb_gpr_write; j++)
      {
	sensitive << *(in_GPR_WRITE_VAL           [j]);
	if (_param->_have_port_ooo_engine_id == true)
	  sensitive << *(in_GPR_WRITE_OOO_ENGINE_ID [j]);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  sensitive << *(in_GPR_WRITE_REGISTERFILE_ACK  [i][j]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t j=0; j<_param->_nb_gpr_write; j++)
      {
	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    (*(out_GPR_WRITE_STATUS_VAL        [i][j])) (*( in_GPR_WRITE_VAL                  [j]));
	    (*(out_GPR_WRITE_STATUS_VAL        [i][j])) (*( in_GPR_WRITE_REGISTERFILE_ACK  [i][j]));
	    if (_param->_have_port_ooo_engine_id == true)
	    (*(out_GPR_WRITE_STATUS_VAL        [i][j])) (*( in_GPR_WRITE_OOO_ENGINE_ID        [j]));
	  }
      }
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_gpr_write_registerfile");

    SC_METHOD (genMealy_gpr_write_registerfile);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t j=0; j<_param->_nb_gpr_write; j++)
      {
	sensitive << *(in_GPR_WRITE_VAL           [j]);
	if (_param->_have_port_ooo_engine_id == true)
	  sensitive << *(in_GPR_WRITE_OOO_ENGINE_ID [j]);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  sensitive << *(in_GPR_WRITE_STATUS_ACK        [i][j]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t j=0; j<_param->_nb_gpr_write; j++)
      {
	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    (*(out_GPR_WRITE_REGISTERFILE_VAL  [i][j])) (*( in_GPR_WRITE_VAL                  [j]));
	    (*(out_GPR_WRITE_REGISTERFILE_VAL  [i][j])) (*( in_GPR_WRITE_STATUS_ACK        [i][j]));
	    if (_param->_have_port_ooo_engine_id == true)
	    (*(out_GPR_WRITE_REGISTERFILE_VAL  [i][j])) (*( in_GPR_WRITE_OOO_ENGINE_ID        [j]));
	  }
      }
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_spr_read");

    SC_METHOD (genMealy_spr_read);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t j=0; j<_param->_nb_spr_read; j++)
      {
	if (_param->_have_port_ooo_engine_id == true)
	  sensitive << *(in_SPR_READ_OOO_ENGINE_ID [j]);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  sensitive << *(in_SPR_READ_REGISTERFILE_ACK  [i][j])
		    << *(in_SPR_READ_REGISTERFILE_DATA [i][j])
		    << *(in_SPR_READ_STATUS_ACK        [i][j])
		    << *(in_SPR_READ_STATUS_DATA_VAL   [i][j]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t j=0; j<_param->_nb_spr_read; j++)
      {
	if (_param->_have_port_ooo_engine_id == true)
	  {
	    (*(out_SPR_READ_ACK                  [j])) (*( in_SPR_READ_OOO_ENGINE_ID        [j]));
	    (*(out_SPR_READ_DATA_VAL             [j])) (*( in_SPR_READ_OOO_ENGINE_ID        [j]));
	    (*(out_SPR_READ_DATA                 [j])) (*( in_SPR_READ_OOO_ENGINE_ID        [j]));
	  }
	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    (*(out_SPR_READ_ACK                  [j])) (*( in_SPR_READ_REGISTERFILE_ACK  [i][j]));
	    (*(out_SPR_READ_ACK                  [j])) (*( in_SPR_READ_STATUS_ACK        [i][j]));
	    (*(out_SPR_READ_DATA                 [j])) (*( in_SPR_READ_REGISTERFILE_DATA [i][j]));
	    (*(out_SPR_READ_DATA_VAL             [j])) (*( in_SPR_READ_STATUS_DATA_VAL   [i][j]));	
	  }
      }
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_spr_read_status");

    SC_METHOD (genMealy_spr_read_status);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t j=0; j<_param->_nb_spr_read; j++)
      {
	sensitive << *(in_SPR_READ_VAL           [j]);
	if (_param->_have_port_ooo_engine_id == true)
	  sensitive << *(in_SPR_READ_OOO_ENGINE_ID [j]);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  sensitive << *(in_SPR_READ_REGISTERFILE_ACK  [i][j]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t j=0; j<_param->_nb_spr_read; j++)
      {
	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    (*(out_SPR_READ_STATUS_VAL        [i][j])) (*( in_SPR_READ_VAL                  [j]));
	    (*(out_SPR_READ_STATUS_VAL        [i][j])) (*( in_SPR_READ_REGISTERFILE_ACK  [i][j]));
	    if (_param->_have_port_ooo_engine_id == true)
	    (*(out_SPR_READ_STATUS_VAL        [i][j])) (*( in_SPR_READ_OOO_ENGINE_ID        [j]));
	  }
      }
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_spr_read_registerfile");

    SC_METHOD (genMealy_spr_read_registerfile);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t j=0; j<_param->_nb_spr_read; j++)
      {
	sensitive << *(in_SPR_READ_VAL           [j]);
	if (_param->_have_port_ooo_engine_id == true)
	  sensitive << *(in_SPR_READ_OOO_ENGINE_ID [j]);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  sensitive << *(in_SPR_READ_STATUS_ACK        [i][j]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t j=0; j<_param->_nb_spr_read; j++)
      {
	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    (*(out_SPR_READ_REGISTERFILE_VAL  [i][j])) (*( in_SPR_READ_VAL                  [j]));
	    (*(out_SPR_READ_REGISTERFILE_VAL  [i][j])) (*( in_SPR_READ_STATUS_ACK        [i][j]));
	    if (_param->_have_port_ooo_engine_id == true)
	    (*(out_SPR_READ_REGISTERFILE_VAL  [i][j])) (*( in_SPR_READ_OOO_ENGINE_ID        [j]));
	  }
      }
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_spr_write");

    SC_METHOD (genMealy_spr_write);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t j=0; j<_param->_nb_spr_write; j++)
      {
	if (_param->_have_port_ooo_engine_id == true)
	  sensitive << *(in_SPR_WRITE_OOO_ENGINE_ID [j]);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  sensitive << *(in_SPR_WRITE_REGISTERFILE_ACK  [i][j])
		    << *(in_SPR_WRITE_STATUS_ACK        [i][j]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t j=0; j<_param->_nb_spr_write; j++)
      {
	if (_param->_have_port_ooo_engine_id == true)
	(*(out_SPR_WRITE_ACK                  [j])) (*( in_SPR_WRITE_OOO_ENGINE_ID        [j]));
		    
	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    (*(out_SPR_WRITE_ACK                  [j])) (*( in_SPR_WRITE_REGISTERFILE_ACK  [i][j]));
	    (*(out_SPR_WRITE_ACK                  [j])) (*( in_SPR_WRITE_STATUS_ACK        [i][j]));
	  }
      }
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_spr_write_status");

    SC_METHOD (genMealy_spr_write_status);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t j=0; j<_param->_nb_spr_write; j++)
      {
	sensitive << *(in_SPR_WRITE_VAL           [j]);
	if (_param->_have_port_ooo_engine_id == true)
	  sensitive << *(in_SPR_WRITE_OOO_ENGINE_ID [j]);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  sensitive << *(in_SPR_WRITE_REGISTERFILE_ACK  [i][j]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t j=0; j<_param->_nb_spr_write; j++)
      {
	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    (*(out_SPR_WRITE_STATUS_VAL        [i][j])) (*( in_SPR_WRITE_VAL                  [j]));
	    (*(out_SPR_WRITE_STATUS_VAL        [i][j])) (*( in_SPR_WRITE_REGISTERFILE_ACK  [i][j]));
	    if (_param->_have_port_ooo_engine_id == true)
	    (*(out_SPR_WRITE_STATUS_VAL        [i][j])) (*( in_SPR_WRITE_OOO_ENGINE_ID        [j]));
	  }
      }
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_spr_write_registerfile");

    SC_METHOD (genMealy_spr_write_registerfile);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t j=0; j<_param->_nb_spr_write; j++)
      {
	sensitive << *(in_SPR_WRITE_VAL           [j]);
	if (_param->_have_port_ooo_engine_id == true)
	  sensitive << *(in_SPR_WRITE_OOO_ENGINE_ID [j]);

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  sensitive << *(in_SPR_WRITE_STATUS_ACK        [i][j]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t j=0; j<_param->_nb_spr_write; j++)
      {
	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    (*(out_SPR_WRITE_REGISTERFILE_VAL  [i][j])) (*( in_SPR_WRITE_VAL                  [j]));
	    (*(out_SPR_WRITE_REGISTERFILE_VAL  [i][j])) (*( in_SPR_WRITE_STATUS_ACK        [i][j]));
	    if (_param->_have_port_ooo_engine_id == true)
	    (*(out_SPR_WRITE_REGISTERFILE_VAL  [i][j])) (*( in_SPR_WRITE_OOO_ENGINE_ID        [j]));
	  }
      }
#endif    

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_insert");

    SC_METHOD (genMealy_insert);
    dont_initialize ();
//     sensitive << (*(in_CLOCK)).neg();
    for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
      {
	uint32_t x=_param->_nb_inst_insert_rob [i];
	for (uint32_t j=0; j<x; j++)
	  sensitive << *( in_INSERT_ROB_VAL            [i][j])
		    << *( in_INSERT_ROB_RD_USE         [i][j]) 
		    << *( in_INSERT_ROB_RE_USE         [i][j]) 
		    << *( in_INSERT_ROB_GPR_STATUS_ACK [i][j])
		    << *( in_INSERT_ROB_SPR_STATUS_ACK [i][j]);
      }
#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
      {
	uint32_t x=_param->_nb_inst_insert_rob [i];
	for (uint32_t j=0; j<x; j++)
	  {
	    (*(out_INSERT_ROB_ACK            [i][j]))(*( in_INSERT_ROB_GPR_STATUS_ACK [i][j]));
	    (*(out_INSERT_ROB_ACK            [i][j]))(*( in_INSERT_ROB_SPR_STATUS_ACK [i][j]));

	    (*(out_INSERT_ROB_GPR_STATUS_VAL [i][j]))(*( in_INSERT_ROB_VAL            [i][j]));
	    (*(out_INSERT_ROB_GPR_STATUS_VAL [i][j]))(*( in_INSERT_ROB_RD_USE         [i][j])); 
	    (*(out_INSERT_ROB_GPR_STATUS_VAL [i][j]))(*( in_INSERT_ROB_SPR_STATUS_ACK [i][j]));

	    (*(out_INSERT_ROB_SPR_STATUS_VAL [i][j]))(*( in_INSERT_ROB_VAL            [i][j])); 
	    (*(out_INSERT_ROB_SPR_STATUS_VAL [i][j]))(*( in_INSERT_ROB_RE_USE         [i][j]));
	    (*(out_INSERT_ROB_SPR_STATUS_VAL [i][j]))(*( in_INSERT_ROB_GPR_STATUS_ACK [i][j]));
	  }
      }
#endif    

//     log_printf(INFO,Register_unit_Glue,FUNCTION,"Method - genMealy_retire");

//     SC_METHOD (genMealy_retire);
//     dont_initialize ();
// //     sensitive << (*(in_CLOCK)).neg();
//     for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
//       {
// 	uint32_t x=_param->_nb_inst_retire_rob [i];
// 	for (uint32_t j=0; j<x; j++)
// 	  sensitive << *( in_RETIRE_ROB_VAL                [i][j])
// 		    << *( in_RETIRE_ROB_RD_OLD_USE         [i][j]) 
// 		    << *( in_RETIRE_ROB_RD_NEW_USE         [i][j])
// 		    << *( in_RETIRE_ROB_RE_OLD_USE         [i][j]) 
// 		    << *( in_RETIRE_ROB_RE_NEW_USE         [i][j])
// 		    << *( in_RETIRE_ROB_GPR_STATUS_NEW_ACK [i][j])
// 		    << *( in_RETIRE_ROB_GPR_STATUS_OLD_ACK [i][j])
// 		    << *( in_RETIRE_ROB_SPR_STATUS_NEW_ACK [i][j])
// 		    << *( in_RETIRE_ROB_SPR_STATUS_OLD_ACK [i][j]);
//       }
// #ifdef SYSTEMCASS_SPECIFIC
//     // List dependency information
//     for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
//       {
// 	uint32_t x=_param->_nb_inst_retire_rob [i];
// 	for (uint32_t j=0; j<x; j++)
// 	  {
// 	    (*(out_RETIRE_ROB_ACK                [i][j]))(*( in_RETIRE_ROB_GPR_STATUS_NEW_ACK [i][j]));
// 	    (*(out_RETIRE_ROB_ACK                [i][j]))(*( in_RETIRE_ROB_GPR_STATUS_OLD_ACK [i][j]));
// 	    (*(out_RETIRE_ROB_ACK                [i][j]))(*( in_RETIRE_ROB_SPR_STATUS_NEW_ACK [i][j]));
// 	    (*(out_RETIRE_ROB_ACK                [i][j]))(*( in_RETIRE_ROB_SPR_STATUS_OLD_ACK [i][j]));

// 	    (*(out_RETIRE_ROB_GPR_STATUS_OLD_VAL [i][j]))(*( in_RETIRE_ROB_VAL                [i][j]));
// 	    (*(out_RETIRE_ROB_GPR_STATUS_OLD_VAL [i][j]))(*( in_RETIRE_ROB_RD_OLD_USE         [i][j])); 
// 	    (*(out_RETIRE_ROB_GPR_STATUS_OLD_VAL [i][j]))(*( in_RETIRE_ROB_GPR_STATUS_NEW_ACK [i][j]));
// 	    (*(out_RETIRE_ROB_GPR_STATUS_OLD_VAL [i][j]))(*( in_RETIRE_ROB_SPR_STATUS_NEW_ACK [i][j]));
// 	    (*(out_RETIRE_ROB_GPR_STATUS_OLD_VAL [i][j]))(*( in_RETIRE_ROB_SPR_STATUS_OLD_ACK [i][j]));

// 	    (*(out_RETIRE_ROB_GPR_STATUS_NEW_VAL [i][j]))(*( in_RETIRE_ROB_VAL                [i][j])); 
// 	    (*(out_RETIRE_ROB_GPR_STATUS_NEW_VAL [i][j]))(*( in_RETIRE_ROB_RD_NEW_USE         [i][j]));
// 	    (*(out_RETIRE_ROB_GPR_STATUS_NEW_VAL [i][j]))(*( in_RETIRE_ROB_GPR_STATUS_OLD_ACK [i][j]));
// 	    (*(out_RETIRE_ROB_GPR_STATUS_NEW_VAL [i][j]))(*( in_RETIRE_ROB_SPR_STATUS_NEW_ACK [i][j]));
// 	    (*(out_RETIRE_ROB_GPR_STATUS_NEW_VAL [i][j]))(*( in_RETIRE_ROB_SPR_STATUS_OLD_ACK [i][j]));

// 	    (*(out_RETIRE_ROB_SPR_STATUS_OLD_VAL [i][j]))(*( in_RETIRE_ROB_VAL                [i][j])); 
// 	    (*(out_RETIRE_ROB_SPR_STATUS_OLD_VAL [i][j]))(*( in_RETIRE_ROB_RE_OLD_USE         [i][j]));
// 	    (*(out_RETIRE_ROB_SPR_STATUS_OLD_VAL [i][j]))(*( in_RETIRE_ROB_GPR_STATUS_NEW_ACK [i][j]));
// 	    (*(out_RETIRE_ROB_SPR_STATUS_OLD_VAL [i][j]))(*( in_RETIRE_ROB_GPR_STATUS_OLD_ACK [i][j]));
// 	    (*(out_RETIRE_ROB_SPR_STATUS_OLD_VAL [i][j]))(*( in_RETIRE_ROB_SPR_STATUS_NEW_ACK [i][j]));

// 	    (*(out_RETIRE_ROB_SPR_STATUS_NEW_VAL [i][j]))(*( in_RETIRE_ROB_VAL                [i][j])); 
// 	    (*(out_RETIRE_ROB_SPR_STATUS_NEW_VAL [i][j]))(*( in_RETIRE_ROB_RE_NEW_USE         [i][j]));
// 	    (*(out_RETIRE_ROB_SPR_STATUS_NEW_VAL [i][j]))(*( in_RETIRE_ROB_GPR_STATUS_NEW_ACK [i][j]));
// 	    (*(out_RETIRE_ROB_SPR_STATUS_NEW_VAL [i][j]))(*( in_RETIRE_ROB_GPR_STATUS_OLD_ACK [i][j]));
// 	    (*(out_RETIRE_ROB_SPR_STATUS_NEW_VAL [i][j]))(*( in_RETIRE_ROB_SPR_STATUS_OLD_ACK [i][j]));
// 	  }
//       }
// #endif    
      }
#endif
    log_printf(FUNC,Register_unit_Glue,FUNCTION,"End");
  };
  
#undef  FUNCTION
#define FUNCTION "Register_unit_Glue::~Register_unit_Glue"
  Register_unit_Glue::~Register_unit_Glue (void)
  {
    log_printf(FUNC,Register_unit_Glue,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
        log_printf(INFO,Register_unit_Glue,FUNCTION,"Generate Statistics file");
        
        delete _stat;
      }
#endif

    log_printf(INFO,Register_unit_Glue,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Register_unit_Glue,FUNCTION,"End");
  };

}; // end namespace register_unit_glue
}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              



