/*
 * $Id: Generator_toXML.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Generator.h"
#include "Common/include/Basename.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

#undef  FUNCTION
#define FUNCTION "Generator::toXML"
  XML Generator::toXML (void)
  {
    XML xml (basename(_filename,false).c_str());
    xml.filename_extension("gen");
    
    xml.balise_open("parameters");
    for (std::map<std::string, Parameter_definition *>::iterator it = _array_param->begin();
         it != _array_param->end();
         ++it)
      {
        xml.insert_XML(it->second->toXML(),1);
      }
    for (std::map<std::string, Link_definition *>::iterator it = _array_link->begin();
         it != _array_link->end();
         ++it)
      {
        xml.insert_XML(it->second->toXML(),1);
      }
    xml.balise_close();

    return xml;
  }

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
