/*
 * $Id: Instance_toXML.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Instance.h"
#include "Common/include/Basename.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

#undef  FUNCTION
#define FUNCTION "Instance::toXML"
  XML Instance::toXML (void)
  {
    XML xml (basename(_filename,false).c_str());
    xml.filename_extension("cfg");
    
    xml.balise_open_begin("core");
    xml.attribut("name",_name);
    xml.balise_open_end  ();

    for (list_parameters_t::iterator it = _list_parameters->begin();
         it != _list_parameters->end();
         ++it)
      xml.insert_XML(it->second->toXML(),1);

    for (list_links_t::iterator it1 = _list_links->begin();
         it1 != _list_links->end();
         ++it1)
      for (list_link_t::iterator it2 = it1->second.begin();
           it2 != it1->second.end();
           ++it2)
        xml.insert_XML(it2->second->toXML(),1);
    
    for (list_components_t::iterator it1 = _list_components->begin();
         it1 != _list_components->end();
         ++it1)
      for (list_instances_t::iterator it2 = it1->second.begin();
           it2 != it1->second.end();
           ++it2)
      xml.insert_XML(it2->second->toXML(),1);

    xml.balise_close();

    return xml;
  }

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
