/*
 * $Id: Register_unit.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/include/Register_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {


#undef  FUNCTION
#define FUNCTION "Register_unit::Register_unit"
  Register_unit::Register_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Register_unit,FUNCTION,"Begin");

// #if DEBUG_Register_unit == true
//     log_printf(INFO,Register_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Register_unit,FUNCTION,"Allocation");
    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Register_unit,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
        // generate the vhdl
        log_printf(INFO,Register_unit,FUNCTION,"Generate the vhdl");
        
        vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    log_printf(INFO,Register_unit,FUNCTION,"Method - transition");

    SC_METHOD (transition);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).pos();
//#endif

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    
      }
#endif
    log_printf(FUNC,Register_unit,FUNCTION,"End");
  };
  
#undef  FUNCTION
#define FUNCTION "Register_unit::~Register_unit"
  Register_unit::~Register_unit (void)
  {
    log_printf(FUNC,Register_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
        log_printf(INFO,Register_unit,FUNCTION,"Generate Statistics file");
        delete _stat;
      }
#endif

    log_printf(INFO,Register_unit,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Register_unit,FUNCTION,"End");
  };

}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
