#ifdef SYSTEMC
/*
 * $Id: Address_management_genMoore.cpp 132 2009-07-11 16:39:35Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management/include/Address_management.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace address_management {


#undef  FUNCTION
#define FUNCTION "Address_management::genMoore"
  void Address_management::genMoore (void)
  {
    log_begin(Address_management,FUNCTION);
    log_function(Address_management,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    // =========================================
    // ===== ADDRESS ===========================
    // =========================================

    internal_ADDRESS_VAL = reg_PC_ACCESS_VAL;

    // Align pc on instruction packet address.
    PORT_WRITE(out_ADDRESS_INSTRUCTION_ADDRESS        ,reg_PC_ACCESS - (reg_PC_ACCESS%_param->_nb_instruction));
    if (_param->_have_port_inst_ifetch_ptr)
    PORT_WRITE(out_ADDRESS_INST_IFETCH_PTR            ,reg_PC_ACCESS_INST_IFETCH_PTR            );
    PORT_WRITE(out_ADDRESS_BRANCH_STATE               ,reg_PC_ACCESS_BRANCH_STATE               );
    if (_param->_have_port_depth)
    PORT_WRITE(out_ADDRESS_BRANCH_UPDATE_PREDICTION_ID,reg_PC_ACCESS_BRANCH_UPDATE_PREDICTION_ID);

    for (uint32_t i=0; i<_param->_nb_instruction; i++)
      PORT_WRITE(out_ADDRESS_INSTRUCTION_ENABLE [i], reg_PC_ACCESS_INSTRUCTION_ENABLE[i]);

    // =========================================
    // ===== PREDICT ===========================
    // =========================================

    internal_PREDICT_VAL = not reg_PC_NEXT_NEXT_VAL;

    PORT_WRITE(out_PREDICT_PC_PREVIOUS          ,reg_PC_CURRENT        );
    PORT_WRITE(out_PREDICT_PC_CURRENT           ,reg_PC_NEXT           );
    PORT_WRITE(out_PREDICT_PC_CURRENT_IS_DS_TAKE,reg_PC_NEXT_IS_DS_TAKE);

      }
    else
      {
    internal_ADDRESS_VAL = 0;
    internal_PREDICT_VAL = 0;
      }

    log_printf(TRACE,Address_management,FUNCTION," * ADDRESS_VAL : %d",internal_ADDRESS_VAL);
    log_printf(TRACE,Address_management,FUNCTION," * PREDICT_VAL : %d",internal_PREDICT_VAL);

    PORT_WRITE(out_ADDRESS_VAL,internal_ADDRESS_VAL);
    PORT_WRITE(out_PREDICT_VAL,internal_PREDICT_VAL);

    log_end(Address_management,FUNCTION);
  };

}; // end namespace address_management
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
