/*
 * $Id: Core_Glue.cpp 132 2009-07-11 16:39:35Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {


#undef  FUNCTION
#define FUNCTION "Core_Glue::Core_Glue"
  Core_Glue::Core_Glue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::core_glue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Core_Glue,FUNCTION);

    usage_environment(_usage);

// #if DEBUG_Core_Glue == true
//     log_printf(INFO,Core_Glue,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Core_Glue,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Core_Glue,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Core_Glue,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
#ifdef SYSTEMCASS_SPECIFIC
        constant();
#else
	log_printf(INFO,Core_Glue,FUNCTION,_("<%s> : Method - constant"),_name.c_str());

	SC_METHOD (constant);
// 	dont_initialize ();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
#endif

	log_printf(INFO,Core_Glue,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

// 	log_printf(INFO,Core_Glue,FUNCTION,_("<%s> : Method - genMoore"),_name.c_str());
// 	SC_METHOD (genMoore);
// 	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // need internal register

// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information
// # endif    

	log_printf(INFO,Core_Glue,FUNCTION,_("<%s> : Method - genMealy_branch_complete"),_name.c_str());
	SC_METHOD (genMealy_branch_complete);
	dont_initialize ();
//	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
	sensitive << (*(in_NRESET));
        for (uint32_t i=0; i<_param->_nb_front_end; ++i)
          for (uint32_t j=0; j<_param->_front_end_nb_inst_branch_complete[i]; ++j)
            sensitive << (*(in_BRANCH_COMPLETE_FRONT_END_ACK             [i][j]))
                      << (*(in_BRANCH_COMPLETE_FRONT_END_MISS_PREDICTION [i][j]));

        for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
          for (uint32_t j=0; j<_param->_ooo_engine_nb_inst_branch_complete[i]; ++j)
            {
              sensitive << (*(in_BRANCH_COMPLETE_OOO_ENGINE_VAL            [i][j]))
                        << (*(in_BRANCH_COMPLETE_OOO_ENGINE_ADDRESS        [i][j]))
                        << (*(in_BRANCH_COMPLETE_OOO_ENGINE_NO_SEQUENCE    [i][j]));
              if (_param->_have_port_front_end_id)
              sensitive << (*(in_BRANCH_COMPLETE_OOO_ENGINE_FRONT_END_ID   [i][j]));
              if (_param->_have_port_context_id)
              sensitive << (*(in_BRANCH_COMPLETE_OOO_ENGINE_CONTEXT_ID     [i][j]));
              if (_param->_have_port_depth)
              sensitive << (*(in_BRANCH_COMPLETE_OOO_ENGINE_DEPTH          [i][j]));
            }	


# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Core_Glue,FUNCTION,_("<%s> : Method - genMealy_commit_event"),_name.c_str());
	SC_METHOD (genMealy_commit_event);
	dont_initialize ();
//	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
	sensitive << (*(in_NRESET));
        for (uint32_t i=0; i<_param->_nb_front_end; ++i)
          sensitive << (*(in_COMMIT_EVENT_FRONT_END_ACK               [i]));
        for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
          {
            sensitive << (*(in_COMMIT_EVENT_OOO_ENGINE_VAL              [i]))
                      << (*(in_COMMIT_EVENT_OOO_ENGINE_TYPE             [i]))
                      << (*(in_COMMIT_EVENT_OOO_ENGINE_IS_DELAY_SLOT    [i]))
                      << (*(in_COMMIT_EVENT_OOO_ENGINE_ADDRESS          [i]))
                      << (*(in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR_VAL [i]))
                      << (*(in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR     [i]))
                      << (*(in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR_VAL [i]))
                      << (*(in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR     [i]));
            if (_param->_have_port_front_end_id)
            sensitive << (*(in_COMMIT_EVENT_OOO_ENGINE_FRONT_END_ID     [i]));
            if (_param->_have_port_context_id)
            sensitive << (*(in_COMMIT_EVENT_OOO_ENGINE_CONTEXT_ID       [i]));
            if (_param->_have_port_depth)
            sensitive << (*(in_COMMIT_EVENT_OOO_ENGINE_DEPTH            [i]));
          }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Core_Glue,FUNCTION,_("<%s> : Method - genMealy_issue"),_name.c_str());
	SC_METHOD (genMealy_issue);
	dont_initialize ();
//	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
	sensitive << (*(in_NRESET));
        for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
          for (uint32_t j=0; j<_param->_nb_inst_issue_queue [i]; ++j)
            {
              sensitive << (*(in_ISSUE_OOO_ENGINE_VAL                   [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_TYPE                  [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_OPERATION             [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_READ  [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_STORE_QUEUE_EMPTY     [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT          [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_IMMEDIAT              [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_READ_RA               [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_NUM_REG_RA            [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_READ_RB               [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_NUM_REG_RB            [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_READ_RC               [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_NUM_REG_RC            [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_WRITE_RD              [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_NUM_REG_RD            [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_WRITE_RE              [i][j]))
                        << (*(in_ISSUE_OOO_ENGINE_NUM_REG_RE            [i][j]));
              if (_param->_have_port_front_end_id)
              sensitive << (*(in_ISSUE_OOO_ENGINE_FRONT_END_ID          [i][j]));
              if (_param->_have_port_context_id)
              sensitive << (*(in_ISSUE_OOO_ENGINE_CONTEXT_ID            [i][j]));
              if (_param->_have_port_rob_ptr)
              sensitive << (*(in_ISSUE_OOO_ENGINE_PACKET_ID             [i][j]));
              if (_param->_have_port_load_queue_ptr)
              sensitive << (*(in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE  [i][j]));
            }

        for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
          for (uint32_t j=0; j<_param->_nb_read_unit [i]; ++j)
            sensitive << (*(in_ISSUE_EXECUTE_LOOP_ACK [i][j]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Core_Glue,FUNCTION,_("<%s> : Method - genMealy_execute"),_name.c_str());
	SC_METHOD (genMealy_execute);
	dont_initialize ();
//	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
	sensitive << (*(in_NRESET));

        for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
          for (uint32_t j=0; j<_param->_ooo_engine_nb_execute_loop[i]; ++j)
            for (uint32_t k=0; k<_param->_nb_inst_execute[i][j]; ++k)
              sensitive << (*(in_EXECUTE_OOO_ENGINE_ACK [i][j][k]));
        
        for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
          for (uint32_t j=0; j<_param->_nb_write_unit[i]; ++j)
            {
              sensitive << (*(in_EXECUTE_EXECUTE_LOOP_VAL           [i][j]))
//                      << (*(in_EXECUTE_EXECUTE_LOOP_OPERATION     [i][j]))
//                      << (*(in_EXECUTE_EXECUTE_LOOP_TYPE          [i][j]))
                        << (*(in_EXECUTE_EXECUTE_LOOP_FLAGS         [i][j]))
                        << (*(in_EXECUTE_EXECUTE_LOOP_EXCEPTION     [i][j]))
                        << (*(in_EXECUTE_EXECUTE_LOOP_NO_SEQUENCE   [i][j]))
                        << (*(in_EXECUTE_EXECUTE_LOOP_ADDRESS       [i][j]))
                        << (*(in_EXECUTE_EXECUTE_LOOP_DATA          [i][j]));
              if (_param->_have_port_context_id)
              sensitive << (*(in_EXECUTE_EXECUTE_LOOP_CONTEXT_ID    [i][j]));
              if (_param->_have_port_front_end_id)
              sensitive << (*(in_EXECUTE_EXECUTE_LOOP_FRONT_END_ID  [i][j]));
              if (_param->_have_port_ooo_engine_id)
              sensitive << (*(in_EXECUTE_EXECUTE_LOOP_OOO_ENGINE_ID [i][j]));
              if (_param->_have_port_rob_ptr)
              sensitive << (*(in_EXECUTE_EXECUTE_LOOP_PACKET_ID     [i][j]));
            }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Core_Glue,FUNCTION,_("<%s> : Method - genMealy_insert"),_name.c_str());
	SC_METHOD (genMealy_insert);
	dont_initialize ();
//	sensitive << (*(in_CLOCK)).neg(); // don't need internal register
	sensitive << (*(in_NRESET));

        for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
          for (uint32_t j=0; j<_param->_nb_inst_insert[i]; ++j)
            sensitive << (*(in_INSERT_OOO_ENGINE_VAL        [i][j]))
                      << (*(in_INSERT_OOO_ENGINE_RD_USE     [i][j]))
                      << (*(in_INSERT_OOO_ENGINE_RD_NUM_REG [i][j]))
                      << (*(in_INSERT_OOO_ENGINE_RE_USE     [i][j]))
                      << (*(in_INSERT_OOO_ENGINE_RE_NUM_REG [i][j]));
        for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
          for (uint32_t j=0; j<_param->_execute_loop_nb_ooo_engine[i]; ++j)
            for (uint32_t k=0; k<_param->_execute_loop_nb_inst_insert[i][j]; ++k)
              sensitive << (*(in_INSERT_EXECUTE_LOOP_ACK [i][j][k]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_end(Core_Glue,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Core_Glue::~Core_Glue"
  Core_Glue::~Core_Glue (void)
  {
    log_begin(Core_Glue,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Core_Glue,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Core_Glue,FUNCTION);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
