/*
 * $Id: Sort.cpp 132 2009-07-11 16:39:35Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Sort/include/Sort.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace sort {


#undef  FUNCTION
#define FUNCTION "Sort::Sort"
  Sort::Sort 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::generic::sort::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Sort,FUNCTION,"Begin");

// #if DEBUG_Sort == true
//     log_printf(INFO,Sort,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Sort,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Sort,FUNCTION,"Allocation of statistics");

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Sort,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
	log_printf(INFO,Sort,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
#  ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
#  endif    
# endif

	log_printf(INFO,Sort,FUNCTION,"Method - genMealy");

	SC_METHOD (genMealy);
	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // don't use internal register
	sensitive << (*(in_NRESET));
	for (uint32_t i=0; i<_param->_nb_input; i++)
	  sensitive << (*(in_INPUT_VAL  [i]))
		    << (*(in_INPUT_DATA [i]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_output; i++)
	  for (uint32_t j=0; j<_param->_nb_input; j++)
	    {
	      (*(out_OUTPUT_VAL   [i])) (*(in_INPUT_VAL  [j]));
	      (*(out_OUTPUT_VAL   [i])) (*(in_INPUT_DATA [j]));
	      
	      if (_param->_have_port_index_out)
		{
	      (*(out_OUTPUT_INDEX [i])) (*(in_INPUT_VAL  [j]));
	      (*(out_OUTPUT_INDEX [i])) (*(in_INPUT_DATA [j]));
		}
	      if (_param->_have_port_data_out)
		{
	      (*(out_OUTPUT_DATA  [i])) (*(in_INPUT_VAL  [j]));
	      (*(out_OUTPUT_DATA  [i])) (*(in_INPUT_DATA [j]));
		}
	    }
# endif    
	
#endif
      }
    log_printf(FUNC,Sort,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Sort::~Sort"
  Sort::~Sort (void)
  {
    log_printf(FUNC,Sort,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Sort,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Sort,FUNCTION,"End");
  };

}; // end namespace sort
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
