#ifdef SYSTEMC
/*
 * $Id: Functionnal_unit_transition.cpp 134 2009-07-15 08:41:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Functionnal_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace functionnal_unit {


#undef  FUNCTION
#define FUNCTION "Functionnal_unit::transition"
  void Functionnal_unit::transition (void)
  {
    log_begin(Functionnal_unit,FUNCTION);
    log_function(Functionnal_unit,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET) == 0)
      {
        if (_param->_have_pipeline_in)
	reg_BUSY_IN  = false;
	reg_BUSY_OUT = false;
	
	for (uint32_t i=0; i<_param->_nb_context; i++)
	  for (uint32_t j=0; j<_param->_nb_front_end; j++)
	    for (uint32_t k=0; k<_param->_nb_ooo_engine; k++)
	      {
// 		uint32_t num_thread = get_num_thread(i,_param->_size_context_id,
// 						     j,_param->_size_front_end_id,
// 						     k,_param->_size_ooo_engine_id);
		
		for (uint32_t x=GROUP_CUSTOM_1; x<GROUP_CUSTOM_8; x++)
		  {
		    function_execute_end_cycle_t * fct = (_param->_get_custom_information()._get_custom_execute_reset(x));
		    
		    if (fct != NULL)
		      (* fct) (_execute_register[i][j][k], _execute_param);
		  }
	      }

        _execute_operation_out->_context_id    = 0; // not necessary
        _execute_operation_out->_front_end_id  = 0; // not necessary
        _execute_operation_out->_ooo_engine_id = 0; // not necessary
        _execute_operation_out->_packet_id     = 0; // not necessary
  //    _execute_operation_out->_operation     = 0; // not necessary
  //    _execute_operation_out->_type          = 0; // not necessary
        _execute_operation_out->_write_rd      = 0; // not necessary
        _execute_operation_out->_num_reg_rd    = 0; // not necessary
        _execute_operation_out->_data_rd       = 0; // not necessary
        _execute_operation_out->_write_re      = 0; // not necessary
        _execute_operation_out->_num_reg_re    = 0; // not necessary
        _execute_operation_out->_data_re       = 0; // not necessary
        _execute_operation_out->_exception     = 0; // not necessary
        _execute_operation_out->_no_sequence   = 0; // not necessary
        _execute_operation_out->_address       = 0; // not necessary
      }
    else
      {
	// Test if pop an instruction
	if (internal_EXECUTE_OUT_VAL and PORT_READ(in_EXECUTE_OUT_ACK))
	  {
            log_printf(TRACE,Functionnal_unit,FUNCTION,"  * EXECUTE_OUT : Transaction Accepted");
	    reg_BUSY_OUT = false;
	  }
	
        // Test if can move instruction in pipeline in to pipeline out
        if (_param->_have_pipeline_in)
        if (reg_BUSY_IN and not reg_BUSY_OUT)
	  {
	    reg_BUSY_OUT = reg_BUSY_IN;
	    reg_BUSY_IN  = false;

	    _execute_operation_out->_timing        = _execute_operation_in->_timing       ;
	    _execute_operation_out->_context_id    = _execute_operation_in->_context_id   ;
	    _execute_operation_out->_front_end_id  = _execute_operation_in->_front_end_id ;
	    _execute_operation_out->_ooo_engine_id = _execute_operation_in->_ooo_engine_id;
	    _execute_operation_out->_packet_id     = _execute_operation_in->_packet_id    ;
	    _execute_operation_out->_operation     = _execute_operation_in->_operation    ;
	    _execute_operation_out->_type          = _execute_operation_in->_type         ;
	    _execute_operation_out->_has_immediat  = _execute_operation_in->_has_immediat ;
	    _execute_operation_out->_immediat      = _execute_operation_in->_immediat     ;
	    _execute_operation_out->_data_ra       = _execute_operation_in->_data_ra      ;
	    _execute_operation_out->_data_rb       = _execute_operation_in->_data_rb      ;
	    _execute_operation_out->_data_rc       = _execute_operation_in->_data_rc      ;
	    _execute_operation_out->_data_rd       = _execute_operation_in->_data_rd      ;
	    _execute_operation_out->_data_re       = _execute_operation_in->_data_re      ;
	    _execute_operation_out->_write_rd      = _execute_operation_in->_write_rd     ;
	    _execute_operation_out->_num_reg_rd    = _execute_operation_in->_num_reg_rd   ;
	    _execute_operation_out->_write_re      = _execute_operation_in->_write_re     ;
	    _execute_operation_out->_num_reg_re    = _execute_operation_in->_num_reg_re   ;
	    _execute_operation_out->_exception     = _execute_operation_in->_exception    ;
	    _execute_operation_out->_no_sequence   = _execute_operation_in->_no_sequence  ;
	    _execute_operation_out->_address       = _execute_operation_in->_address      ;
	  }

	// Test if push
	execute_register_t * execute_register = NULL;

	if (PORT_READ(in_EXECUTE_IN_VAL) and internal_EXECUTE_IN_ACK)
	  {
            log_printf(TRACE,Functionnal_unit,FUNCTION,"  * EXECUTE_IN : Transaction Accepted");

            execute_operation_t * execute_operation;

            if (_param->_have_pipeline_in)
              {
	    reg_BUSY_IN       = true;
            execute_operation = _execute_operation_in;
              }
            else
              {
	    reg_BUSY_OUT      = true;
            execute_operation = _execute_operation_out;
              }

	    Tcontext_t   context_id    = (_param->_have_port_context_id   )?PORT_READ(in_EXECUTE_IN_CONTEXT_ID   ):0;
	    Tcontext_t   front_end_id  = (_param->_have_port_front_end_id )?PORT_READ(in_EXECUTE_IN_FRONT_END_ID ):0;
	    Tcontext_t   ooo_engine_id = (_param->_have_port_ooo_engine_id)?PORT_READ(in_EXECUTE_IN_OOO_ENGINE_ID):0;
	    Tcontext_t   packet_id     = (_param->_have_port_rob_ptr      )?PORT_READ(in_EXECUTE_IN_PACKET_ID    ):0;
	    Toperation_t operation     = PORT_READ(in_EXECUTE_IN_OPERATION);
	    Ttype_t      type          = PORT_READ(in_EXECUTE_IN_TYPE);

	    execute_operation->_context_id    = context_id   ;
	    execute_operation->_front_end_id  = front_end_id ;
	    execute_operation->_ooo_engine_id = ooo_engine_id;
	    execute_operation->_packet_id     = packet_id    ;
	    execute_operation->_operation     = operation    ;
	    execute_operation->_type          = type         ;
	    execute_operation->_has_immediat  = PORT_READ(in_EXECUTE_IN_HAS_IMMEDIAT);
	    execute_operation->_immediat      = PORT_READ(in_EXECUTE_IN_IMMEDIAT    );
	    execute_operation->_data_ra       = PORT_READ(in_EXECUTE_IN_DATA_RA     );
	    execute_operation->_data_rb       = PORT_READ(in_EXECUTE_IN_DATA_RB     );
	    execute_operation->_data_rc       = PORT_READ(in_EXECUTE_IN_DATA_RC     );
	    execute_operation->_write_rd      = PORT_READ(in_EXECUTE_IN_WRITE_RD    );
	    execute_operation->_num_reg_rd    = PORT_READ(in_EXECUTE_IN_NUM_REG_RD  );
	    execute_operation->_data_rd       = 0; // no necessaray
	    execute_operation->_write_re      = PORT_READ(in_EXECUTE_IN_WRITE_RE    );
	    execute_operation->_num_reg_re    = PORT_READ(in_EXECUTE_IN_NUM_REG_RE  );
	    execute_operation->_data_re       = 0; // no necessaray
	    execute_operation->_exception     = 0; // no necessaray
	    execute_operation->_no_sequence   = 0; // no necessaray
	    execute_operation->_address       = 0; // no necessaray

            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * context_id    : %d",execute_operation->_context_id   );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * front_end_id  : %d",execute_operation->_front_end_id );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * ooo_engine_id : %d",execute_operation->_ooo_engine_id);
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * packet_id     : %d",execute_operation->_packet_id    );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * operation     : %d",execute_operation->_operation    );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * type          : %s",toString(execute_operation->_type).c_str());
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * has_immediat  : %d",execute_operation->_has_immediat );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * immediat      : %.8x",execute_operation->_immediat     );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * data_ra       : %.8x",execute_operation->_data_ra      );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * data_rb       : %.8x",execute_operation->_data_rb      );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * data_rc       : %.8x",execute_operation->_data_rc      );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * write_rd      : %d"  ,execute_operation->_write_rd     );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * num_reg_rd    : %d"  ,execute_operation->_num_reg_rd   );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * write_re      : %d"  ,execute_operation->_write_re     );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * num_reg_re    : %d"  ,execute_operation->_num_reg_re   );
            
#ifdef DEBUG_TEST
	    if (type >= _param->_nb_type)
	      throw ERRORMORPHEO(FUNCTION,"Invalid type : '"+toString(type)+"' is higher that _nb_type");
	    if (operation >= _param->_nb_operation)
	      throw ERRORMORPHEO(FUNCTION,"Invalid operation : '"+toString(operation)+"' is higher that _nb_operation");
#endif

	    // execute the operation
 	    execute_register = _execute_register[context_id][front_end_id][ooo_engine_id];

	    // Test if operation is a custom
	    if (type == TYPE_CUSTOM)
	      {
// 		uint32_t num_thread = get_num_thread(context_id   ,_param->_size_context_id,
// 						     front_end_id ,_param->_size_front_end_id,
// 						     ooo_engine_id,_param->_size_ooo_engine_id);

		(*(_param->_get_custom_information()._get_custom_execute_genMoore(operation))) (execute_operation, execute_register, _execute_param);
	      }
	    else
	      (*(_function_execute[type][operation])) (execute_operation, execute_register, _execute_param);


            log_printf(TRACE,Functionnal_unit,FUNCTION,"    -----------------");
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * latence       : %.8x",execute_operation->_timing._latence);
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * delay         : %.8x",execute_operation->_timing._delay);
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * data_rd       : %.8x",execute_operation->_data_rd    );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * data_re       : %.8x",execute_operation->_data_re    );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * exception     : %d"  ,execute_operation->_exception  );
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * no_sequence   : %d"  ,execute_operation->_no_sequence);
            log_printf(TRACE,Functionnal_unit,FUNCTION,"    * address       : %.8x (%.8x)",execute_operation->_address,execute_operation->_address<<2);

#ifdef STATISTICS
            if (usage_is_set(_usage,USE_STATISTICS))
              {
                (*_stat_use_functionnal_unit) ++;
                (*_stat_sum_delay)   += execute_operation->_timing._delay;
                (*_stat_sum_latence) += execute_operation->_timing._latence;
              }
#endif
	  }
	
	// End cycle
	{
	  for (uint32_t i=0; i<_param->_nb_context; i++)
	    for (uint32_t j=0; j<_param->_nb_front_end; j++)
	      for (uint32_t k=0; k<_param->_nb_ooo_engine; k++)
		{
// 		  uint32_t num_thread = get_num_thread(i,_param->_size_context_id,
// 						       j,_param->_size_front_end_id,
// 						       k,_param->_size_ooo_engine_id);

		  for (uint32_t x=GROUP_CUSTOM_1; x<GROUP_CUSTOM_8; x++)
		    {
		      function_execute_end_cycle_t * fct = (_param->_get_custom_information()._get_custom_execute_transition(x));
		      
		      if (fct != NULL)
			(* fct) (_execute_register[i][j][k], _execute_param);
		    }
		}

	  // Update status
	  if (execute_register != NULL)
	    {
	      // They have an access
	      execute_register->_i_write_spr = false;
	      execute_register->_i_read_spr  = false;
	    }
	}

	
	// each cycle : decrease the latence
	if (reg_BUSY_OUT and (_execute_operation_out->_timing._latence > 0))
	  _execute_operation_out->_timing._latence --;

#if defined(DEBUG) and DEBUG_Functionnal_unit and (DEBUG >= DEBUG_TRACE)
        {
          log_printf(TRACE,Functionnal_unit,FUNCTION,"  * Dump ALU (Functionnal_unit)");

          if (_param->_have_pipeline_in)
          log_printf(TRACE,Functionnal_unit,FUNCTION,"    * reg_BUSY_IN  : %d",reg_BUSY_IN );
          log_printf(TRACE,Functionnal_unit,FUNCTION,"    * reg_BUSY_OUT : %d",reg_BUSY_OUT);
        }
#endif
      }
    
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_end(Functionnal_unit,FUNCTION);
  };

}; // end namespace functionnal_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
