/*
 * $Id: Commit_unit_deallocation.cpp 134 2009-07-15 08:41:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Commit_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace commit_unit {


#undef  FUNCTION
#define FUNCTION "Commit_unit::deallocation"
  void Commit_unit::deallocation (void)
  {
    log_begin(Commit_unit,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE2_SIGNAL( in_INSERT_VAL                     ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],1                                   );
        DELETE2_SIGNAL(out_INSERT_ACK                     ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],1                                   );
        DELETE2_SIGNAL( in_INSERT_FRONT_END_ID            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_front_end_id          );
        DELETE2_SIGNAL( in_INSERT_CONTEXT_ID              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_context_id            );
        DELETE2_SIGNAL(out_INSERT_PACKET_ID               ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_rob_ptr               );
//      DELETE2_SIGNAL( in_INSERT_RENAME_UNIT_ID          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_rename_unit_id        );
        DELETE2_SIGNAL( in_INSERT_DEPTH                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_depth                 );
        DELETE2_SIGNAL( in_INSERT_TYPE                    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_type                  );
        DELETE2_SIGNAL( in_INSERT_OPERATION               ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_operation             );
        DELETE2_SIGNAL( in_INSERT_NO_EXECUTE              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],1                                   );
        DELETE2_SIGNAL( in_INSERT_LAST_EVENT              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],1                                   );
        DELETE2_SIGNAL( in_INSERT_IS_DELAY_SLOT           ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],1                                   );
#ifdef DEBUG
        DELETE2_SIGNAL( in_INSERT_ADDRESS                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_instruction_address               );
#endif
        DELETE2_SIGNAL( in_INSERT_ADDRESS_NEXT            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_instruction_address               );
        DELETE2_SIGNAL( in_INSERT_EXCEPTION               ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_exception             );
        DELETE2_SIGNAL( in_INSERT_EXCEPTION_USE           ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_exception             );
        DELETE2_SIGNAL( in_INSERT_STORE_QUEUE_PTR_WRITE   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_store_queue_ptr       );
        DELETE2_SIGNAL( in_INSERT_LOAD_QUEUE_PTR_WRITE    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_load_queue_ptr        );
#ifdef DEBUG
        DELETE2_SIGNAL( in_INSERT_READ_RA                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],1                                   );
        DELETE2_SIGNAL( in_INSERT_NUM_REG_RA_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_general_register_logic);
        DELETE2_SIGNAL( in_INSERT_NUM_REG_RA_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_general_register      );
        DELETE2_SIGNAL( in_INSERT_READ_RB                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],1                                   );
        DELETE2_SIGNAL( in_INSERT_NUM_REG_RB_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_general_register_logic);
        DELETE2_SIGNAL( in_INSERT_NUM_REG_RB_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_general_register      );
        DELETE2_SIGNAL( in_INSERT_READ_RC                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],1                                   );
        DELETE2_SIGNAL( in_INSERT_NUM_REG_RC_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_special_register_logic);
        DELETE2_SIGNAL( in_INSERT_NUM_REG_RC_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_special_register      );
#endif
        DELETE2_SIGNAL( in_INSERT_WRITE_RD                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],1                                   );
        DELETE2_SIGNAL( in_INSERT_NUM_REG_RD_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_general_register_logic);
        DELETE2_SIGNAL( in_INSERT_NUM_REG_RD_PHY_OLD      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_general_register      );
        DELETE2_SIGNAL( in_INSERT_NUM_REG_RD_PHY_NEW      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_general_register      );
        DELETE2_SIGNAL( in_INSERT_WRITE_RE                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],1                                   );
        DELETE2_SIGNAL( in_INSERT_NUM_REG_RE_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_special_register_logic);
        DELETE2_SIGNAL( in_INSERT_NUM_REG_RE_PHY_OLD      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_special_register      );
        DELETE2_SIGNAL( in_INSERT_NUM_REG_RE_PHY_NEW      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1],_param->_size_special_register      );

        DELETE2_SIGNAL(out_RETIRE_VAL                     ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],1                                   );
        DELETE2_SIGNAL( in_RETIRE_ACK                     ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],1                                   );
        DELETE2_SIGNAL(out_RETIRE_FRONT_END_ID            ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_front_end_id          );  
        DELETE2_SIGNAL(out_RETIRE_CONTEXT_ID              ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_context_id            );    
//      DELETE2_SIGNAL(out_RETIRE_RENAME_UNIT_ID          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_rename_unit_id        );
        DELETE2_SIGNAL(out_RETIRE_USE_STORE_QUEUE         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],1                                   );
        DELETE2_SIGNAL(out_RETIRE_USE_LOAD_QUEUE          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],1                                   );
        DELETE2_SIGNAL(out_RETIRE_STORE_QUEUE_PTR_WRITE   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_store_queue_ptr       );
        DELETE2_SIGNAL(out_RETIRE_LOAD_QUEUE_PTR_WRITE    ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_load_queue_ptr        );
//         DELETE2_SIGNAL(out_RETIRE_READ_RA                 ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],1                                   );
//         DELETE2_SIGNAL(out_RETIRE_NUM_REG_RA_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_general_register      );
//         DELETE2_SIGNAL(out_RETIRE_READ_RB                 ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],1                                   );
//         DELETE2_SIGNAL(out_RETIRE_NUM_REG_RB_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_general_register      );
//         DELETE2_SIGNAL(out_RETIRE_READ_RC                 ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],1                                   );
//         DELETE2_SIGNAL(out_RETIRE_NUM_REG_RC_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_special_register      );
        DELETE2_SIGNAL(out_RETIRE_WRITE_RD                ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],1                                   );
        DELETE2_SIGNAL(out_RETIRE_NUM_REG_RD_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_general_register_logic);
        DELETE2_SIGNAL(out_RETIRE_NUM_REG_RD_PHY_OLD      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_general_register      );
        DELETE2_SIGNAL(out_RETIRE_NUM_REG_RD_PHY_NEW      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_general_register      );
        DELETE2_SIGNAL(out_RETIRE_WRITE_RE                ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],1                                   );
        DELETE2_SIGNAL(out_RETIRE_NUM_REG_RE_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_special_register_logic);
        DELETE2_SIGNAL(out_RETIRE_NUM_REG_RE_PHY_OLD      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_special_register      );
        DELETE2_SIGNAL(out_RETIRE_NUM_REG_RE_PHY_NEW      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1],_param->_size_special_register      );

        DELETE2_SIGNAL(out_RETIRE_EVENT_VAL               ,_param->_nb_front_end,_param->_nb_context[it1],1);
        DELETE2_SIGNAL( in_RETIRE_EVENT_ACK               ,_param->_nb_front_end,_param->_nb_context[it1],1);
        DELETE2_SIGNAL(out_RETIRE_EVENT_STATE             ,_param->_nb_front_end,_param->_nb_context[it1],_param->_size_event_state);
//      DELETE2_SIGNAL(out_RETIRE_EVENT_FLUSH             ,_param->_nb_front_end,_param->_nb_context[it1],1);
        DELETE2_SIGNAL(out_RETIRE_EVENT_STOP              ,_param->_nb_front_end,_param->_nb_context[it1],1);

        DELETE1_SIGNAL( in_COMMIT_VAL               ,_param->_nb_inst_commit,1                             );
        DELETE1_SIGNAL(out_COMMIT_ACK               ,_param->_nb_inst_commit,1                             );
        DELETE1_SIGNAL( in_COMMIT_WEN               ,_param->_nb_inst_commit,1                             );
        DELETE1_SIGNAL( in_COMMIT_PACKET_ID         ,_param->_nb_inst_commit,_param->_size_rob_ptr         );
//      DELETE1_SIGNAL( in_COMMIT_OPERATION         ,_param->_nb_inst_commit,_param->_size_operation       );
//      DELETE1_SIGNAL( in_COMMIT_TYPE              ,_param->_nb_inst_commit,_param->_size_type            );
        DELETE1_SIGNAL( in_COMMIT_FLAGS             ,_param->_nb_inst_commit,_param->_size_general_data    );
        DELETE1_SIGNAL( in_COMMIT_EXCEPTION         ,_param->_nb_inst_commit,_param->_size_exception       );
        DELETE1_SIGNAL( in_COMMIT_NO_SEQUENCE       ,_param->_nb_inst_commit,1                             );
        DELETE1_SIGNAL( in_COMMIT_ADDRESS           ,_param->_nb_inst_commit,_param->_size_instruction_address         );
        DELETE1_SIGNAL(out_COMMIT_NUM_REG_RD        ,_param->_nb_inst_commit,_param->_size_general_register+_param->_size_rename_unit_id);

        DELETE1_SIGNAL(out_REEXECUTE_VAL                  ,_param->_nb_inst_reexecute,1                            );
        DELETE1_SIGNAL( in_REEXECUTE_ACK                  ,_param->_nb_inst_reexecute,1                            );
        DELETE1_SIGNAL(out_REEXECUTE_CONTEXT_ID           ,_param->_nb_inst_reexecute,_param->_size_context_id     );
        DELETE1_SIGNAL(out_REEXECUTE_FRONT_END_ID         ,_param->_nb_inst_reexecute,_param->_size_front_end_id   );
        DELETE1_SIGNAL(out_REEXECUTE_PACKET_ID            ,_param->_nb_inst_reexecute,_param->_size_rob_ptr        );
        DELETE1_SIGNAL(out_REEXECUTE_OPERATION            ,_param->_nb_inst_reexecute,_param->_size_operation      );
        DELETE1_SIGNAL(out_REEXECUTE_TYPE                 ,_param->_nb_inst_reexecute,_param->_size_type           );
        DELETE1_SIGNAL(out_REEXECUTE_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_reexecute,_param->_size_store_queue_ptr);

        DELETE1_SIGNAL(out_BRANCH_COMPLETE_VAL            ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_ACK            ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_CONTEXT_ID     ,_param->_nb_inst_branch_complete,_param->_size_context_id  );
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_ID   ,_param->_nb_inst_branch_complete,_param->_size_front_end_id);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_DEPTH          ,_param->_nb_inst_branch_complete,_param->_size_depth       );
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_ADDRESS        ,_param->_nb_inst_branch_complete,_param->_size_instruction_address     );
//      DELETE1_SIGNAL(out_BRANCH_COMPLETE_FLAG           ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_NO_SEQUENCE    ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_MISS_PREDICTION,_param->_nb_inst_branch_complete,1);

        DELETE0_SIGNAL(out_UPDATE_VAL                      ,1                         );
        DELETE0_SIGNAL( in_UPDATE_ACK                      ,1                         );
        DELETE0_SIGNAL(out_UPDATE_CONTEXT_ID               ,_param->_size_context_id  );
        DELETE0_SIGNAL(out_UPDATE_FRONT_END_ID             ,_param->_size_front_end_id);
        DELETE0_SIGNAL(out_UPDATE_DEPTH                    ,_param->_size_depth       );
        DELETE0_SIGNAL(out_UPDATE_TYPE                     ,_param->_size_event_type  );
        DELETE0_SIGNAL(out_UPDATE_IS_DELAY_SLOT            ,1                         );
        DELETE0_SIGNAL(out_UPDATE_ADDRESS                  ,_param->_size_instruction_address     );
        DELETE0_SIGNAL(out_UPDATE_ADDRESS_EPCR_VAL         ,1                         );
        DELETE0_SIGNAL(out_UPDATE_ADDRESS_EPCR             ,_param->_size_instruction_address     );
        DELETE0_SIGNAL(out_UPDATE_ADDRESS_EEAR_VAL         ,1                         );
        DELETE0_SIGNAL(out_UPDATE_ADDRESS_EEAR             ,_param->_size_instruction_address     );

        DELETE2_SIGNAL( in_EVENT_VAL                       ,_param->_nb_front_end, _param->_nb_context[it1],1                    );
        DELETE2_SIGNAL(out_EVENT_ACK                       ,_param->_nb_front_end, _param->_nb_context[it1],1                    );
        DELETE2_SIGNAL( in_EVENT_ADDRESS                   ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_instruction_address);
        DELETE2_SIGNAL( in_EVENT_ADDRESS_NEXT              ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_instruction_address); 
        DELETE2_SIGNAL( in_EVENT_ADDRESS_NEXT_VAL          ,_param->_nb_front_end, _param->_nb_context[it1],1                    );
        DELETE2_SIGNAL( in_EVENT_IS_DS_TAKE                ,_param->_nb_front_end, _param->_nb_context[it1],1                    );

        DELETE2_SIGNAL(out_NB_INST_COMMIT_ALL             ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_nb_inst_commit);
        DELETE2_SIGNAL(out_NB_INST_COMMIT_MEM             ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_nb_inst_commit);
        DELETE2_SIGNAL( in_NB_INST_DECOD_ALL              ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_nb_inst_decod);

        DELETE2_SIGNAL( in_DEPTH_MIN                      ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_depth);
        DELETE2_SIGNAL( in_DEPTH_MAX                      ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_depth);
        DELETE2_SIGNAL( in_DEPTH_FULL                     ,_param->_nb_front_end, _param->_nb_context[it1],1);

	DELETE2_SIGNAL( in_SPR_READ_SR_OVE                ,_param->_nb_front_end, _param->_nb_context[it1],1);

	DELETE2_SIGNAL(out_SPR_WRITE_VAL                  ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL( in_SPR_WRITE_ACK                  ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL(out_SPR_WRITE_SR_F_VAL             ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL(out_SPR_WRITE_SR_F                 ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL(out_SPR_WRITE_SR_CY_VAL            ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL(out_SPR_WRITE_SR_CY                ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL(out_SPR_WRITE_SR_OV_VAL            ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL(out_SPR_WRITE_SR_OV                ,_param->_nb_front_end, _param->_nb_context[it1],1);

#ifdef DEBUG_TEST
        DELETE0_SIGNAL(out_INFO_ROB_EMPTY                 ,1);
#endif

        // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
        DELETE1(internal_BANK_INSERT_VAL             ,_param->_nb_bank);
        DELETE1(internal_BANK_INSERT_NUM_RENAME_UNIT ,_param->_nb_bank);
        DELETE1(internal_BANK_INSERT_NUM_INST        ,_param->_nb_bank);
        
        DELETE2(internal_BANK_COMMIT_VAL             ,_param->_nb_bank,_param->_nb_bank_access_commit);
        DELETE2(internal_BANK_COMMIT_NUM_INST        ,_param->_nb_bank,_param->_nb_bank_access_commit);
        DELETE2(internal_BANK_COMMIT_ENTRY           ,_param->_nb_bank,_param->_nb_bank_access_commit);
        
        DELETE1(internal_BANK_RETIRE_VAL             ,_param->_nb_bank);
        DELETE1(internal_BANK_RETIRE_NUM_RENAME_UNIT ,_param->_nb_bank);
        DELETE1(internal_BANK_RETIRE_NUM_INST        ,_param->_nb_bank);
        
        DELETE1(internal_REEXECUTE_VAL               ,_param->_nb_inst_reexecute);
        DELETE1(internal_REEXECUTE_NUM_BANK          ,_param->_nb_inst_reexecute);
        
        DELETE1(internal_BRANCH_COMPLETE_VAL         ,_param->_nb_inst_branch_complete);
        DELETE1(internal_BRANCH_COMPLETE_NUM_BANK    ,_param->_nb_inst_branch_complete);
        
        DELETE2(internal_EVENT_ACK                   ,_param->_nb_front_end,_param->_nb_context [it1]);
        
        DELETE2(internal_RETIRE_EVENT_VAL            ,_param->_nb_front_end,_param->_nb_context[it1]);
        
        // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
	for (uint32_t i=0; i<_param->_nb_bank; ++i)
	  while(not _rob[i].empty())
	    {
	      entry_t * entry = _rob[i].front();
	      delete entry;
	      _rob[i].pop_front();
	    }

        DELETE2(_nb_cycle_idle           ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE1(_rob                     ,_param->_nb_bank);
        DELETE1(reg_BANK_PTR             ,_param->_nb_bank);
        DELETE2(reg_NB_INST_COMMIT_ALL   ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_NB_INST_COMMIT_MEM   ,_param->_nb_front_end,_param->_nb_context [it1]);

        DELETE2(reg_EVENT_STATE          ,_param->_nb_front_end,_param->_nb_context [it1]);
//      DELETE2(reg_EVENT_FLUSH          ,_param->_nb_front_end,_param->_nb_context [it1]);
//      DELETE2(reg_EVENT_STOP           ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_EVENT_NUM_BANK       ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_EVENT_NUM_PTR        ,_param->_nb_front_end,_param->_nb_context [it1]);
//      DELETE2(reg_EVENT_CAN_RESTART    ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_EVENT_PACKET         ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_EVENT_NB_INST        ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_EVENT_LAST           ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_EVENT_LAST_NUM_BANK  ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_EVENT_LAST_NUM_PTR   ,_param->_nb_front_end,_param->_nb_context [it1]);

        DELETE2(reg_EVENT_NEXT_STOP      ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_EVENT_NEXT_PACKET    ,_param->_nb_front_end,_param->_nb_context [it1]);

//      DELETE2(reg_PC_PREVIOUS          ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_PC_CURRENT           ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_PC_CURRENT_IS_DS     ,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_PC_CURRENT_IS_DS_TAKE,_param->_nb_front_end,_param->_nb_context [it1]);
        DELETE2(reg_PC_NEXT              ,_param->_nb_front_end,_param->_nb_context [it1]);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _priority_insert;

    delete _component;

#if defined(DEBUG) and defined(DEBUG_Commit_unit) and (DEBUG_Commit_unit == true)
    if (log_file_generate)
      {   
	for (uint32_t i=0; i<_param->_nb_thread; ++i)
	  if (_param->_have_thread [i])
	    {
	      instruction_log_file [i].close();
	    }
	delete [] instruction_log_file;
      }
#endif

    log_end(Commit_unit,FUNCTION);
  };

}; // end namespace commit_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
